<?php
define( 'WOOCOMMERCE_USE_CSS', false );

function woocommerce_enabled() {
    if ( class_exists( 'woocommerce' ) )
        return true;
    return false;
}


/* ====== Remove Actions ====== */

remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );




/* ====== Remove Page Title ====== */

add_filter('woocommerce_show_page_title', 'title_none');
function title_none(){
    return false;
}







/* ====== Change Pagination ====== */

remove_action('woocommerce_pagination', 'woocommerce_pagination', 10);
add_action('woocommerce_pagination', 'pagination', 10);




/* ====== Change Breadcrumbs ====== */

remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
add_filter( 'woocommerce_breadcrumb_defaults', 'lioit_woocommerce_breadcrumbs' );
function lioit_woocommerce_breadcrumbs() {
    return array(
            'delimiter'   => ' &#47; ',
            'wrap_before' => '<div class="span6"><div class="lioit-breadcrumb pull-right" itemprop="breadcrumb">',
            'wrap_after'  => '</div></div>',
            'before'      => '<span>',
            'after'       => '</span>',
            'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
        );
}







/* ====== Change Thumbnail ====== */

remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
add_action('woocommerce_before_shop_loop_item_title', 'lioit_woocommerce_thumb', 10);

function lioit_woocommerce_thumb()
{
	global $product;
	$rating = $product->get_rating_html();	
	$id = $post->ID;
	$width = 300;	
	echo "<div class='thumbnail_container'>";
                echo post_image_show( $width );
		echo lioit_woocommerce_gallery_first_thumb( $id , $width);		
		if(!empty($rating)) echo "<span class='rating_container'>".$rating."</span>";
		echo "<span class='cart-load'></span>";
	echo "</div>";
}
function lioit_woocommerce_gallery_first_thumb($id, $width)
{
    $gallery = get_post_meta( $id, '_product_image_gallery', true );
    if(!empty($gallery))
    {
            $woo_gallery = explode(',',$gallery);
            $image_id = $woo_gallery[0];
            $image = aq_resize(wp_get_attachment_url($image_id), $width, "", true);
            $alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
            $alt = !empty($alt) ? $alt : get_the_title();
            if(!empty($image)) return '<img src="'.$image.'" class="product-hover-thumb" alt="'.$alt.'">';
    }
}




/* ====== Change Add To Cart ====== */

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
add_action( 'woocommerce_after_shop_loop_item', 'lioit_add_cart_button', 16);
function lioit_add_cart_button() {
	global $product;

	if ($product->product_type == 'bundle' ){
		$product = new WC_Product_Bundle($product->id);
	}

	ob_start();
	woocommerce_template_loop_add_to_cart();
	$output = ob_get_clean();

	if($product->product_type == 'variable' && empty($output))
	{
		$output = "<a class='add_to_cart_button product_type_variable button' href='".get_permalink($product->id)."'>".__('Select options','lioit')."</a>";
	}

	if($product->product_type == 'simple')
	{
		$output .= "<a class='show_details_button button' href='".get_permalink($product->id)."'>".__('Show Details','lioit')."</a>";
	}	
	
	if($output) echo "<div class='lioit_cart_buttons button'>$output</div>";
}







/**
 * WooCommerce Extra Feature
 * --------------------------
 *
 * Register a shortcode that creates a product categories dropdown list
 *
 * Use: [product_categories_dropdown orderby="title" count="0" hierarchical="0"]
 *
 */
add_shortcode( 'product_categories_dropdown', 'woo_product_categories_dropdown' );
 
function woo_product_categories_dropdown( $atts ) {
 
  extract(shortcode_atts(array(
    'count'         => '0',
    'hierarchical'  => '0',
    'orderby' 	    => ''
    ), $atts));
	
	ob_start();
	
	$c = $count;
	$h = $hierarchical;
	$o = ( isset( $orderby ) && $orderby != '' ) ? $orderby : 'order';
		
	// Stuck with this until a fix for http://core.trac.wordpress.org/ticket/13258
	woocommerce_product_dropdown_categories( $c, $h, 0, $o );
 
	?>
	<script type='text/javascript'>
	/* <![CDATA[ */
		var product_cat_dropdown = document.getElementById("dropdown_product_cat");
		function onProductCatChange() {
			if ( product_cat_dropdown.options[product_cat_dropdown.selectedIndex].value !=='' ) {
				location.href = "<?php echo home_url(); ?>/?product_cat="+product_cat_dropdown.options[product_cat_dropdown.selectedIndex].value;
			}
		}
		product_cat_dropdown.onchange = onProductCatChange;
	/* ]]> */
	</script>
	<?php
	
	return ob_get_clean();
	
}




/**
 * Function that returns an array containing the IDs of the featured products.
 *
 * @since 2.0
 * @access public
 * @return array
 */
function woo_get_featured_product_ids() {
  // Load from cache
	$featured_product_ids = get_transient( 'wc_featured_products' );
 
	// Valid cache found
	if ( false !== $featured_product_ids )
		return $featured_product_ids;
 
	$featured = get_posts( array(
		'post_type'      => array( 'product', 'product_variation' ),
		'posts_per_page' => -1,
		'post_status'    => 'publish',
		'meta_query' => array(
			array(
				'key' 		=> '_visibility',
				'value' 	=> array('catalog', 'visible'),
				'compare' 	=> 'IN'
			),
			array(
				'key' 	=> '_featured',
				'value' => 'yes'
			)
		),
		'fields' => 'id=>parent'
	) );
 
	$product_ids = array_keys( $featured );
	$parent_ids  = array_values( $featured );
	$featured_product_ids = array_unique( array_merge( $product_ids, $parent_ids ) );
 
	set_transient( 'wc_featured_products', $featured_product_ids );
 
	return $featured_product_ids;
}




/*
Plugin Name: WooCommerce - Recently Viewed Products
Plugin URL: http://remicorson.com/
Description: Adds a "recently viewed products" shortcode
Version: 1.0
Author: Remi Corson
Author URI: http://remicorson.com
Contributors: corsonr
Text Domain: lioit
Domain Path: languages
*/

/**
 * Register the [woocommerce_recently_viewed_products per_page="5"] shortcode
 *
 * This shortcode displays recently viewed products using WooCommerce default cookie
 * It only has one parameter "per_page" to choose number of items to show
 *
 * @access      public
 * @since       1.0 
 * @return      $content
*/
function rc_woocommerce_recently_viewed_products( $atts, $content = null ) {

	// Get shortcode parameters
	extract(shortcode_atts(array(
		"per_page" => '5'
	), $atts));

	// Get WooCommerce Global
	global $woocommerce;

	// Get recently viewed product cookies data
	$viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] ) : array();
	$viewed_products = array_filter( array_map( 'absint', $viewed_products ) );

	// If no data, quit
	if ( empty( $viewed_products ) )
		return __( 'You have not viewed any product yet!', 'lioit' );

	// Create the object
	ob_start();

	// Get products per page
	if( !isset( $per_page ) ? $number = 5 : $number = $per_page )

	// Create query arguments array
    $query_args = array(
    				'posts_per_page' => $number, 
    				'no_found_rows'  => 1, 
    				'post_status'    => 'publish', 
    				'post_type'      => 'product', 
    				'post__in'       => $viewed_products, 
    				'orderby'        => 'rand'
    				);

	// Add meta_query to query args
	$query_args['meta_query'] = array();

    // Check products stock status
    $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();

	// Create a new query
	$r = new WP_Query($query_args);

	// If query return results
	if ( $r->have_posts() ) {

		$content = '<ul class="lioit_product_list_widget">';

		// Start the loop
		while ( $r->have_posts()) {
			$r->the_post();
			global $product;

			$content .= '<li>
				<a href="' . get_permalink() . '">
					' . ( has_post_thumbnail() ? get_the_post_thumbnail( $r->post->ID, 'shop_thumbnail' ) : woocommerce_placeholder_img( 'shop_thumbnail' ) ) . ' ' . get_the_title() . '
				</a> ' . $product->get_price_html() . '
			</li>';
		}

		$content .= '</ul>';

	}

	// Get clean object
	$content .= ob_get_clean();
	
	// Return whole content
	return $content;
}

// Register the shortcode
add_shortcode("woocommerce_recently_viewed_products", "rc_woocommerce_recently_viewed_products");




add_action('init', 'woocommerce_clear_cart_url');
function woocommerce_clear_cart_url() {
    global $woocommerce;
    if( isset($_REQUEST['clear-cart']) ) {
        $woocommerce->cart->empty_cart();
    }
}