<?php
/*
 Template Name: Videos
*/
?>
<?php get_header();?>

<script type="text/javascript">
jQuery(document).ready(function() {	

	var $container = jQuery('.features-videos');
      var $isoID = jQuery('#filters .active').attr('data-filter');

	  $container.isotope({
		itemSelector: '.gg',
		animationEngine: 'jquery',
		animationOptions: {
		duration: 350,
		easing: 'linear',
		queue: true
		}
	  });
	  $container.isotope({ filter: $isoID });

	jQuery('#filters li a').click(function() {
		jQuery('#filters li a').removeClass('active');
		jQuery(this).addClass('active');
		$isoID = jQuery(this).attr('data-filter');
		$container.isotope({ filter: $isoID });
		return false;
	});
});	
</script>

<div id="main" class="container">
  <div id="fullContent">
    <div class="filter-wrap"> 
      
      <!-- BEGIN FILTERS -->
      <ul id="filters" class="mainBorder">
        
       
        
        <!-- LI -->
        <li id="all"><a class="btn active" href="#" data-filter="*"><?php _e('All Videos','lioit') ?></a></li>
        <?php 
			$terms = get_terms("videos_sorting");
			$count = count($terms);
			if ( $count > 0 ){
			$sPattern = '/\s*/m';
			$sReplace = '';
			foreach ( $terms as $term ) {
			$isoTax = preg_replace( $sPattern, $sReplace, $term->name);
			echo '<li><a class="btn" href="#" data-filter=".' . $isoTax . '">' . $term->name . '</a></li>';
				}
			} 
			?>
        
        <!-- END FILTERS -->
      </ul>
    </div>
    <div class="row features-videos mainBorder" id="latest-features">
      <?php query_posts( 'post_type=videos&posts_per_page=-1&paged='.$paged); ?>
      <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
      <?php $terms_l = get_the_terms ($post->id, 'videos_sorting'); ?>
      <?php $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id(), 'features-thumb'); ?>
      <div class="span3 gg <?php unset($term_links);
					$sPattern = '/\s*/m';
					$sReplace = '';
					foreach ($terms_l as $term) {
					$term_links[] = preg_replace( $sPattern, $sReplace, $term->name); }
					$on_draught = join(" ", $term_links);
					echo $on_draught; 
					?>">
        <div class="smallVideoitem">
                	<?php
					$video_type = get_post_meta($post->ID, 'lioit_video_type', true);
					$video_id = get_post_meta($post->ID, 'lioit_video_id', true);
					$video_thumb = get_post_meta($post->ID, 'lioit_video_thumb', true);
					$featured_image = get_post_meta($post->ID, 'featured_image', true);
					$video = get_post_meta($post->ID, 'video', true);
					?> 
					<?php if($video_thumb == 'video') { ?>
						<?php if($video_type == 'youtube') { ?>
						<iframe width="300" height="190" src="http://www.youtube.com/embed/<?php echo $video_id; ?>?rel=0" frameborder="0" allowfullscreen></iframe>
						<?php } elseif($video_type == 'vimeo') { ?>
						<iframe src="http://player.vimeo.com/video/<?php echo $video_id; ?>?title=0&amp;byline=0&amp;portrait=0&amp;color=ba0d16" width="300" height="190" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
						<?php } elseif($video_type == 'dialymotion') { ?>
						<iframe frameborder="0" width="300" height="190" src="http://www.dailymotion.com/embed/video/<?php echo $video_id ?>?logo=0"></iframe>
						<?php } ?>
					<?php } elseif($video_thumb == 'featured_image') { ?>
                    <?php $img = catch_that_image($post->ID); ?>
						<div class="homeVThumb ThumbCover">
                        	<div class="cover" style="top: 100%;">
                                            <a class="postype prettyphoto" href="<?php echo $img ?>" rel="prettyPhoto"></a>
                                            <a class="detail" href="<?php the_permalink(); ?>" title="View detail"></a>										
                                        </div>
							
							<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title(); ?>">
							<img src="<?php echo $img ?>" width="275" alt="<?php the_title(); ?>" />
							</a>
						</div><!--End HomeVideo Thumb-->
					<?php } ?>
                    <div class="listVideoContent">
                    <h3 class="videoTitle"><a href="<?php the_permalink(); ?>"><i class="icon-film"></i><?php the_title(); ?></a></h3>
                </div><!--End Video Content-->
                </div>
        <!--End Small Video item-->
        
       </div>
      <!-- END THREE -->
      
      <?php endwhile; ?>
      <?php endif; ?>
      <br style="clear:both">
    </div>
    <!-- END ISOTOPE --> 
  </div>
  <!--End Main Content--> 
  
</div>
<!--End Main-->
</div>
<!--End Content-->
<?php get_footer();?>
