<?php
/*
    Template Name: Timeline Page
*/
?>
<?php get_header();?>
            <div id="main" class="container">
            	<div id="fullContent">
					<div class="singlePost">
                    	<?php if(have_posts()) : while(have_posts()) : the_post('');?>
                    	<div class="article mainBorder">
                        	<div class="articleDetails">
                            	<div class="articleTitle mainPageCenterTitle">
                                    <h1><?php the_title(); ?></h1>
                                </div><!--End articleTitle-->
                            </div><!--End Article Details-->
                            <div class="articleContent">
                            	<?php the_content(); ?>
                            </div><!--End ArticleContent-->
                            
                            <?php
								$where = apply_filters( 'getarchives_where', "WHERE post_type = 'post' AND post_status = 'publish'" );
								$join = apply_filters( 'getarchives_join', '' );
								$query = "SELECT YEAR(post_date) AS `year`, count(ID) as posts FROM $wpdb->posts $join $where GROUP BY YEAR(post_date) ORDER BY post_date DESC";
								$key = md5($query);
								$cache = wp_cache_get( 'wp_get_archives' , 'general');
								if ( !isset( $cache[ $key ] ) ) {
									$arcresults = $wpdb->get_results($query);
									$cache[ $key ] = $arcresults;
									wp_cache_set( 'wp_get_archives', $cache, 'general' );
								} else {
									$arcresults = $cache[ $key ];
								}
								if ($arcresults) {
									foreach ( (array) $arcresults as $arcresult) { ?>
			
									<h2 class="timeline-head"><?php echo $arcresult->year ?></h2>
									<?php 
									$query = new WP_Query( array( 'year' => $arcresult->year , 'posts_per_page' => -1 ) ); ?>
									<ul class="timeline customTimeline">
									<?php while ( $query->have_posts() ) : $query->the_post()?>
									<li>	
										<span><i class="icon-calendar"></i><?php the_time('F d, Y') ?></span><a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'lioit' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a>
									</li>
									<?php endwhile; ?>
							</ul>
							<?php	}
							}	 
							?>
                        </div><!--End article-->
                        <?php comments_template('', true); ?>
                        <?php endwhile; ?>
						<?php  else:  ?>
                        <?php  endif; ?>
                    </div><!--End ContentBox-->
                </div><!--End Main Content-->
            </div><!--End Main-->
        </div><!--End Content-->
<?php get_footer();?>