<?php
global $smof_data;
require_once "wp-admin/includes/template.php";
$postTitleError = '';
if(isset($_POST['submitted']) && isset($_POST['post_nonce_field']) && wp_verify_nonce($_POST['post_nonce_field'], 'post_nonce')) {
	if(trim($_POST['postTitle']) === '') {
		$postTitleError = 'Please enter a title.';
		$hasError = true;
	} else {
		$postTitle = trim($_POST['postTitle']);
	}
	 /*Insert Categories*/
    $tax_array = array();
    $category = $_POST["post_category"];
    if($category){
        $tax_array["category"] = $category;
    }
    /*Insert Categories*/
	
	
	if(isset($_POST['comment_status'])) { 
		$comment_status = 'open';
	} else if(isset($_POST['ping_status'])) { 
		$ping_status = 'open';
	} else { 
		$ping_status = 'closed';
		$comment_status = 'closed';
	} 


	$post_status = $_POST["post_status"];
	$post_tags = $_POST['tagsinput'];
	$post_status = $_POST['post_status'];
	$post_thumbnail = $_POST['custom_image'];
	$post_content = $_POST['post_content'];
	$post_information = array(
		'post_title' => esc_attr(strip_tags($_POST['postTitle'])),
		'post_content' => $post_content,
		'post_excerpt' => esc_attr(strip_tags($_POST['post_excerpt'])),
		'lioit_post_badge_text' => esc_attr(strip_tags($_POST['lioit_post_badge_text'])),
		'post_type' => 'post',
		'tax_input' => $tax_array,
        'post_author' => $this_user->ID,
		'tags_input' => $post_tags,
		'post_thumbnail' => $set-post-thumbnail,
		'post_status' => $post_status,
		'comment_status' => $comment_status, 
		'ping_status' => $ping_status, 
	);

	$post_id = wp_insert_post($post_information);
	if(isset($_POST["featured_image"])){
        $default_img = get_field("default_featured_image","lioit");
        if($default_img){
            $default_img = $default_img["id"];
        }
        $thumb = $_POST["featured_image"] ? $_POST["featured_image"] : $default_img;
        set_post_thumbnail($post_id,$thumb);
    }

	

	if($post_id)
	{
		// Update Custom Meta
		update_post_meta($post_id, 'lioit_post_badge_text', esc_attr(strip_tags($_POST['lioit_post_badge_text'])));
		update_post_meta($post_id, 'lioit_post_badge_color', esc_attr(strip_tags($_POST['lioit_post_badge_color'])));
		$post = get_post($post_id);
		wp_redirect($post->guid);
  
	}
	

}
?>
<?php
/*
    Template Name: Insert Post
*/
?>
<?php acf_form_head(); get_header();?>
            <div id="main" class="container">
            	<div id="fullContent">
					<div class="singlePost singleAddPost">
                         <?php if(!empty($smof_data['allow_users_to_publish_posts'])) { ?>
                         <?php if(current_user_can('publish_posts', $post_id)) { ?>
                        <div class="articleDetails">
                            	<div class="articleTitle">
                                    <h1><i class="icon-edit"></i><?php _e('Add New Post', 'lioit') ?></h1>
                                </div><!--End articleTitle-->
                            </div><!--End Article Details-->
                        <form action="" id="primaryPostForm" method="POST">
							<div class="row">
                            	<div class="span9">
                         				<div class="newpostTitle">
                                            <input type="text" name="postTitle" placeholder="<?php _e('Enter title here', 'lioit') ?>" id="postTitle" value="<?php if(isset($_POST['postTitle'])) echo $_POST['postTitle'];?>" class="required" />
                            
											<?php if($postTitleError != '') { ?>
                                                <span class="error"><?php echo $postTitleError; ?></span>
                                                </div>
                                            <?php } ?>
                                    	</div>	
                            
                                     <div class="newPostEditor">
                                     	 <?php
											  if(class_exists('WP_Editor')){
												  global $wp_editor;
												  $media_bar = true; // set to true to show the media bar
												  $settings = array(); // additional settings,
												  
												  if(isset($action_edit_text)){
													  echo $wp_editor->editor($post_edit -> post_content, 'post_content', $settings, $media_bar);
												  }else{
													  echo $wp_editor->editor('', 'post_content', $settings, $media_bar);
												  }
											  }else{
												  if(isset($action_edit_text)){
													  wp_editor($post_edit -> post_content,'post_content');
												  }else{
													  wp_editor('','post_content');
												  }
												  
											  }	
										  ?>
											
						 
										<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
                                     
                                     </div><!--End Editor-->
                                    <div class="newPostColumn">
                                        <h4 class="newPostColumnTitle"><?php _e("Excerpt","lioit"); ?></h4>
                                        <div class="newPostColumnContent">
                                          <textarea name="post_excerpt" id="post_excerpt" rows="8" cols="30"><?php if(isset($_POST['post_excerpt'])) { if(function_exists('stripslashes')) { echo stripslashes($_POST['post_excerpt']); } else { echo $_POST['post_excerpt']; } } ?></textarea>
                                        </div>
                                      </div><!-- newPostColumn -->
                                      <div class="newPostColumn">
                                      	 <h4 class="newPostColumnTitle"><?php _e("Discussion","lioit"); ?></h4>
										 <div class="newPostColumnContent">
                                            <input name="advanced_view" type="hidden" value="1">
                                            
                                                <label for="comment_status" class="selectit"><input name="comment_status" type="checkbox" id="comment_status" value="open"> Allow comments.</label>
                                                <label for="ping_status"><input name="ping_status" type="checkbox" id="ping_status" value="open"> Allow <a href="http://codex.wordpress.org/Introduction_to_Blogging#Managing_Comments" target="_blank">trackbacks and pingbacks</a> on this page.</label>
                                             
                                            </div>	<!-- newPostColumnContent -->
                                      </div><!-- newPostColumn -->
                                      <div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Sidebars","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                    
                                                    <input name="sbg_edit" type="hidden" value="sbg_edit" />
                                    				<p><?php _e('Select the custom sidebar, leave unselected to use the default sidebar', 'lioit'); ?></p>
                                                    <ul>
                                                    <?php 
                                                    global $wp_registered_sidebars;
                                                    //var_dump($wp_registered_sidebars);		
                                                        for($i=0;$i<1;$i++){ ?>
                                                            <li>
                                                            <select name="sidebar_generator_replacement[<?php $i ?>]">
                                                                <option value="0"<?php if($selected_sidebar_replacement[$i] == ''){ echo " selected";} ?>>None</option>
                                                            <?php
                                                            
                                                            $sidebar_replacements = $wp_registered_sidebars;//sidebar_generator::get_sidebars();
                                                            if(is_array($sidebar_replacements) && !empty($sidebar_replacements)){
                                                                foreach($sidebar_replacements as $sidebar){
                                                                    if($selected_sidebar_replacement[$i] == $sidebar['name']){
                                                                        echo "<option value='{$sidebar['name']}' selected>{$sidebar['name']}</option>\n";
                                                                    }else{
                                                                        echo "<option value='{$sidebar['name']}'>{$sidebar['name']}</option>\n";
                                                                    }
                                                                }
                                                            }
                                                            ?>
                                                            </select> 
                                                            
                                                            </li>
                                                        <?php } ?>
                                                    </ul>
                                               
                                                
                                              </div>
                                         </div><!-- newPostColumn -->
                                </div><!--End Span9-->
                				<div class="span3">
                                		<div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Publish","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              
                                                <select name="post_status" id="post_status">
                                                <option value="publish"><?php _e('publish', 'lioit') ?></option>
                                                <option value="pending"><?php _e('pending', 'lioit') ?></option>
                                                <option value="draft"><?php _e('draft', 'lioit') ?></option>
                                                </select>
                                              	 <button type="submit" class="postsubmit btn"><?php _e('Add Post', 'lioit') ?></button>
                               
                                                
                                              </div>
                                         </div><!-- newPostColumn -->
                                		
                                        <div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Post Badge","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              

                                              	<input type="text" name="lioit_post_badge_text" placeholder="<?php _e('Enter Badge Text', 'lioit') ?>" id="lioit_post_badge_text" value="<?php if(isset($_POST['lioit_post_badge_text'])) echo $_POST['lioit_post_badge_text'];?>" />
                                                
                                                <input name="lioit_post_badge_color" id="lioit_post_badge_color" type="text" value="#f2c500" class="my-color-field" data-default-color="#f2c500" />
												 <script type="text/javascript">
                                                    jQuery(document).ready(function($){
                                                        jQuery('.my-color-field').wpColorPicker();
                                                    });
                                                </script>
                                                
                                              </div>
                                            </div><!-- newPostColumn -->
                               			
                                        <div class="newPostColumn">
											<?php
											$terms = wp_get_post_terms( $post->ID,"category" );
											$terms = isset($terms[0]) ? $terms[0]->term_id : "";
											?>
				
											<h4 class="newPostColumnTitle"><?php _e("Choose Post Category","lioit"); ?></h4>
											
                                            <div class="newPostColumnContent">
                                              	<?php
												wp_terms_checklist($post->ID,array(
													"descendants_and_self" => false,
													"checked_ontop" => false
												));
												?>
                                              </div>
                                              <?php echo wp_set_post_terms(); ?>
                                         </div><!-- newPostColumn -->
                                	
                                        
                                        	<script type="text/javascript">
												jQuery(document).ready(function($) {
                                            	// Tags Input
    											jQuery(".tagsinput").tagsInput();
												});
                                             </script>
                                            <div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Tags","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              	<input name="tagsinput" id="tagsinput" class="tagsinput" value="" />
                                              </div>
                                            </div><!-- newPostColumn -->
                                       
                                        
                                        <div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Featured Image","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              	<div class="acf-image-uploader clearfix" data-preview_size="thumbnail" data-library="all">
                                                    <input class="acf-image-value" type="hidden" name="featured_image" value="">
                                                    <div class="has-image">
                                                        <div class="hover">
                                                            <ul class="bl">
                                                                <li><a class="acf-button-delete ir" href="#"><?php _e("Remove","lioit"); ?></a></li>
                                                                <li><a class="acf-button-edit ir" href="#"><?php _e("Edit","lioit"); ?></a></li>
                                                            </ul>
                                                        </div>
                                                        <img class="acf-image-image" src="" alt="">
                                                    </div>
                                                        <div class="no-image">
                                                            <p><?php _e("Choose Featured Image","lioit"); ?></p> <input type="button" class="button add-image" value="<?php _e("Add Image","lioit"); ?>">
                                                            </div>
                                                    </div>
                                              </div>
                                            </div><!-- newPostColumn -->
                                            
                                              	
                                        
                                </div><!--End Span3-->
                           
                			</div><!--End Row-->
                            <input type="hidden" name="submitted" id="submitted" value="true" />
                        </form>
                        <?php } else { ?>
                        	<div class="row">
                            	<div class="span6 addpostLoginForm">
                                	<div class="widgetTitle"><h5><?php _e('Login','lioit'); ?></h5><span class="titleBorder"></span></div>
                                	<form action="<?php echo home_url(); ?>/wp-login.php" method="post" class="topAreaLoginform " novalidate>
                                      <p>
                                        <input type="text" name="log" id="log" class="required" placeholder="<?php _e( 'Username' , 'lioit' ) ?>" value="<?php echo esc_html(stripslashes($user_login), 1) ?>"></p>
                                         <p><input type="password" name="pwd" id="pwd" placeholder="<?php _e( 'Password' , 'lioit' ) ?>" class="required">
                                      </p>
                                      <!-- .loginFormInputs -->
                                      
                                      
                                      <p class="login-form-submit"> 
                                      	<span class="login-form-remember">
                                        <input class="remember-me checkbox" name="rememberme" id="rememberme" type="checkbox" checked="checked" value="forever">
                                        <label for="remember-me">
                                          <?php _e("Remember Me","lioit"); ?>
                                        </label>
                                        </span>
                                        <input type="hidden" name="action" value="log-in">
                                        <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>" />
                                        <button type="submit" class="btn btn-primary btn-large">
                                        <i class="icon-login"></i><span><?php _e("Sign in","lioit"); ?></span>
                                        </button>
                                      </p>
                                      
                                      <!-- .form-submit -->
                                    </form>
                                    <!-- .sign-in -->
                                </div><!--End span6-->
                                <div class="span6">
                                	<div class="widgetTitle"><h5><?php _e('Reset Password','lioit'); ?></h5><span class="titleBorder"></span></div>
                                    <form method="post" action="<?php echo site_url('wp-login.php?action=lostpassword', 'login_post') ?>" class="wp-user-form">
                                        <div class="username">
                                            <label for="user_login" class="hide"><?php _e('Username or Email :','lioit'); ?></label>
                                            <input type="text" name="user_login" value="" size="20" id="user_login" tabindex="1001" />
                                        </div>
                                        <div>
                                            <?php do_action('login_form', 'resetpass'); ?>
                                            <input type="submit" name="user-submit" value="<?php _e('Reset', 'lioit'); ?>" class="user-submit btn" tabindex="1002" />
                                            <?php $reset = $_GET['reset']; if($reset == true) { echo '<p>A message will be sent to your email address.</p>'; } ?>
                                            <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>?reset=true" />
                                            <input type="hidden" name="user-cookie" value="1" />
                                        </div>
                                    </form>
                                </div><!--End span6-->
                            </div><!--End Row-->
                        <?php } ?>
                 		<?php } else { ?>
                        	<p><?php _e("Closed","lioit"); ?></p>
                        <?php } ?>
                       
                     
                    </div><!--End ContentBox-->
                    
                </div><!--End Main Content-->
            </div><!--End Main-->
        </div><!--End Content-->
<?php get_footer();?>
