<?php
/*
    Template Name: Sitemap Page
*/
?>
<?php get_header();?>
            <div id="main" class="container">
            	<div id="fullContent">
					<div class="singlePost">
                    	<?php if(have_posts()) : while(have_posts()) : the_post('');?>
                    	<div class="article mainBorder">
                        	<div class="articleDetails">
                            	<div class="articleTitle">
                                    <h1><?php the_title(); ?></h1>
                                </div><!--End articleTitle-->
                            </div><!--End Article Details-->
                            <div class="articleContent">
                            	<?php the_content(); ?>
                            </div><!--End ArticleContent-->
                            
                            
                            <div id="sitemap">
                                <div class="sitemapColumn">
                                    <h2><?php _e('Pages','lioit'); ?></h2>
                                    <ul id="sitemap-pages"><?php wp_list_pages('title_li='); ?></ul>
                                </div> <!-- end .sitemap-col -->
                                    
                                <div class="sitemapColumn">
                                    <h2><?php _e('Categories','lioit'); ?></h2>
                                    <ul id="sitemap-categories"><?php wp_list_categories('title_li='); ?></ul>
                                </div> <!-- end .sitemap-col -->
                                    
                                <div class="sitemapColumn">
                                    <h2><?php _e('Tags','lioit'); ?></h2>
                                    <ul id="sitemap-tags">
                                        <?php $tags = get_tags();
                                        if ($tags) {
                                            foreach ($tags as $tag) {
                                                echo '<li><a href="' . get_tag_link( $tag->term_id ) . '">' . $tag->name . '</a></li> ';
                                            }
                                        } ?>
                                    </ul>
                                </div> <!-- end .sitemap-col -->
                                                                
                                <div class="sitemapColumn<?php echo ' last'; ?>">
                                    <h2><?php _e('Authors','lioit'); ?></h2>
                                    <ul id="sitemap-authors" ><?php wp_list_authors('optioncount=1&exclude_admin=0'); ?></ul>
                                </div> <!-- end .sitemap-col -->
                            
                            </div> <!-- end #sitemap -->
                        </div><!--End article-->
                        <?php comments_template('', true); ?>
                        <?php endwhile; ?>
						<?php  else:  ?>
                        <?php  endif; ?>
                    </div><!--End ContentBox-->
                </div><!--End Main Content-->
            </div><!--End Main-->
        </div><!--End Content-->
<?php get_footer();?>