<?php
/*
    Template Name: Signup Page
*/
?>
<?php get_header();?>
            <div id="main" class="container">
            	<div id="fullContent">
					<div class="singlePost">
                    	<?php if(have_posts()) : while(have_posts()) : the_post('');?>
                    	<div class="article row">
                        	<div class="articleDetails span12">
                            	<div class="articleTitle">
                                    <h1><?php the_title(); ?></h1>
                                </div><!--End articleTitle-->
                            </div><!--End Article Details-->
                            <div class="articleContent span12">
                            	<?php the_content(); ?>
                            </div><!--End ArticleContent-->
                            
                            <div class="singuppage span6">
                                <?php
								
								/* Load registration file. */
								require_once( ABSPATH . WPINC . '/registration.php' );
								
								/* Check if users can register. */
								$registration = get_option( 'users_can_register' );
								
								/* If user registered, input info. */
								if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'adduser' ) {
									$user_pass = wp_generate_password();
									$userdata = array(
										'user_pass' => $user_pass,
										'user_login' => esc_attr( $_POST['user_name'] ),
										'nickname' => esc_attr( $_POST['nickname'] ),
										'user_email' => esc_attr( $_POST['email'] ),
										'role' => get_option( 'default_role' ),
									);
									
									if ( !$userdata['user_login'] )
										$error = __('A username is required for registration.', 'lioit');
									elseif ( username_exists($userdata['user_login']) )
										$error = __('Sorry, that username already exists!', 'lioit');
									
									elseif ( !is_email($userdata['user_email'], true) )
										$error = __('You must enter a valid email address.', 'lioit');
									elseif ( email_exists($userdata['user_email']) )
										$error = __('Sorry, that email address is already used!', 'lioit');
									
									else{
										$new_user = wp_insert_user( $userdata );
										wp_new_user_notification($new_user, $user_pass);  
									}
								
								}
								 
								?>
								
						
										<?php if ( is_user_logged_in() && !current_user_can( 'create_users' ) ) : ?>
								
											<div class="sidebox">
                                            <h3><?php _e('Welcome,', 'lioit'); ?> <?php echo $user_identity; ?></h3>
                                            <div class="usericon">
                                                <?php global $userdata; get_currentuserinfo(); echo get_avatar($userdata->ID, 60); ?>
                                    
                                            </div>
                                            <div class="userinfo">
                                               <p class="log-in-out alert">
												<?php printf( __('You are logged in as <a href="%1$s" title="%2$s">%2$s</a>.  You don\'t need another account.', 'lioit'), get_author_posts_url( $curauth->ID ), $user_identity ); ?> <a href="<?php echo wp_logout_url( get_permalink() ); ?>" title="<?php _e('Log out of this account', 'lioit'); ?>"><?php _e('Logout &raquo;', 'lioit'); ?></a>
                                                </p><!-- .log-in-out .alert -->
                                            </div>
                                        </div>
								
										
											<?php elseif ( $new_user ) : ?>					
                                            <p class="alert">
											<?php
                                                if ( current_user_can( 'create_users' ) )
                                                    printf( __('A user account for %1$s has been created.', 'lioit'), $_POST['user-name'] );
                                                else 
                                                    printf( __('Thank you for registering, %1$s.', 'lioit'), $_POST['user-name'] );
                                                    printf( __('<br/>Please check your email address. That\'s where you\'ll recieve your login password.<br/> (It might go into your spam folder)', 'lioit') );
                                            ?>
                                            </p><!-- .alert -->
                                
                                        <?php else : ?>
                                
                                            <?php if ( $error ) : ?>
                                                <p class="error">
                                                    <?php echo $error; ?>
                                                </p><!-- .error -->
                                            <?php endif; ?>
                                
                                            <?php if ( current_user_can( 'create_users' ) && $registration ) : ?>
                                                <p class="alert">
                                                    <?php _e('Users can register themselves or you can manually create users here.', 'lioit'); ?>
                                                </p><!-- .alert -->
                                            <?php elseif ( current_user_can( 'create_users' ) ) : ?>
                                                <p class="alert">
                                                    <?php _e('Users cannot currently register themselves, but you can manually create users here.', 'lioit'); ?>
                                                </p><!-- .alert -->
                                            <?php endif; ?>
                                
                                            <?php if ( $registration || current_user_can( 'create_users' ) ) : ?>
                                
                                            <form method="post" id="adduser" class="user-forms" action="http://<?php echo $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
												<p class="form-username">
													<label for="user_name"><?php _e('Username *', 'lioit'); ?></label>
													<input class="text-input" name="user_name" type="text" id="user_name" value="<?php if ( $error ) echo esc_html( $_POST['user_name'], 1 ); ?>" />
												</p><!-- .form-username -->
												<p class="nickname">
													<label for="nickname"><?php _e('Nickname', 'lioit'); ?></label>
													<input class="text-input" name="nickname" type="text" id="nickname" value="<?php if ( $error ) echo esc_html( $_POST['nickname'], 1 ); ?>" />
												</p><!-- .nickname -->
												<p class="form-email">
                                                    <label for="email"><?php _e('E-mail (required)', 'lioit'); ?></label>
                                                    <input class="text-input" name="email" type="text" id="email" value="<?php if ( $error ) echo esc_html( $_POST['email'], 1 ); ?>" />
                                                </p><!-- .form-email -->
												<p class="form-submit">
													<?php echo $referer; ?>
                                                    <input name="adduser" type="submit" id="addusersub" class="submit btn" value="<?php if ( current_user_can( 'create_users' ) ) _e('Add User', 'lioit'); else _e('Register', 'lioit'); ?>" />
                                                    <?php wp_nonce_field( 'add-user' ) ?>
                                                    <input name="action" type="hidden" id="action" value="adduser" />
                                                </p><!-- .form-submit -->
								
											</form><!-- #adduser -->
								
											<?php endif; ?>
								
										<?php endif; ?>
											
								
								
								
								
								
								</div><!--End Signup-->
                                <div class="span6 reset">
                                    <p><?php _e('Enter your username or email to reset your password.','lioit'); ?></p>
                                    <form method="post" action="<?php echo site_url('wp-login.php?action=lostpassword', 'login_post') ?>" class="wp-user-form">
                                        <div class="username">
                                            <label for="user_login" class="hide"><?php _e('Username or Email :','lioit'); ?></label>
                                            <input type="text" name="user_login" value="" size="20" id="user_login" tabindex="1001" />
                                        </div>
                                        <div class="login_fields">
                                            <?php do_action('login_form', 'resetpass'); ?>
                                            <input type="submit" name="user-submit" value="<?php _e('Reset my password', 'lioit'); ?>" class="user-submit btn" tabindex="1002" />
                                            <?php $reset = $_GET['reset']; if($reset == true) { echo '<p>A message will be sent to your email address.</p>'; } ?>
                                            <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>?reset=true" />
                                            <input type="hidden" name="user-cookie" value="1" />
                                        </div>
                                    </form>
                            </div><!--End reset-->
                        </div><!--End article-->
                        <?php comments_template('', true); ?>
                        <?php endwhile; ?>
						<?php  else:  ?>
                        <?php  endif; ?>
                    </div><!--End ContentBox-->
                </div><!--End Main Content-->
            </div><!--End Main-->
        </div><!--End Content-->
<?php get_footer();?>