<?php /* Template Name: Edit Posts */ 
global $smof_data;
$query = new WP_Query(array('post_type' => 'post', 'posts_per_page' =>'-1', 'post_status' => array('publish', 'pending', 'draft', 'private', 'trash') ) );

if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
	
	if(isset($_GET['post'])) {
		
		if($_GET['post'] == $post->ID)
		{
			$current_post = $post->ID;

			$title = get_the_title();
			$content = get_the_content();
			
			$excerpt = get_the_excerpt();
			$badge_text = get_post_meta($current_post, 'lioit_post_badge_text', true);
			$badge_color = get_post_meta($current_post, 'lioit_post_badge_color', true);
			$poststatus = get_post_status( $current_post );
		}
	}

endwhile; endif;
wp_reset_query();

global $current_post;

$postTitleError = '';

if(isset($_POST['submitted']) && isset($_POST['post_nonce_field']) && wp_verify_nonce($_POST['post_nonce_field'], 'post_nonce')) {

	if(trim($_POST['postTitle']) === '') {
		$postTitleError = 'Please enter a title.';
		$hasError = true;
	} else {
		$postTitle = trim($_POST['postTitle']);
	}
	 /*Insert Categories*/
    $tax_array = array();
    $category = $_POST["post_category"];
    if($category){
        $tax_array["category"] = $category;
    }
    /*Insert Categories*/
	
	if(isset($_POST['comment_status'])) { 
		$comment_status = 'open';
	} else if(isset($_POST['ping_status'])) { 
		$ping_status = 'open';
	} else { 
		$ping_status = 'closed';
		$comment_status = 'closed';
	} 
	
	$post_status = $_POST["post_status"];
	$post_tags = $_POST['tagsinput'];
	$post_status = $_POST['post_status'];
	$post_thumbnail = $_POST['custom_image'];
	$post_content = $_POST['post_content'];
	$post_information = array(
		'ID' => $current_post,
		'post_title' => esc_attr(strip_tags($_POST['postTitle'])),
		'post_content' => $post_content,
		'lioit_post_badge_text' => esc_attr(strip_tags($_POST['lioit_post_badge_text'])),
		'lioit_post_badge_color' => esc_attr(strip_tags($_POST['lioit_post_badge_color'])),
		'post_type' => 'post',
		'tax_input' => $tax_array,
        'post_author' => $this_user->ID,
		'tags_input' => $post_tags,
		'post_status' => $post_status,
		'comment_status' => $comment_status, 
		'ping_status' => $ping_status,  
	);

	$current_post = wp_update_post($post_information);
	if(isset($_POST["featured_image"])){
        $default_img = get_field("default_featured_image","lioit");
        if($default_img){
            $default_img = $default_img["id"];
        }
        $thumb = $_POST["featured_image"] ? $_POST["featured_image"] : $default_img;
        set_post_thumbnail($current_post,$thumb);
    }
	if($current_post)
	{

		// Update Custom Meta
		update_post_meta($current_post, 'lioit_post_badge_text', esc_attr(strip_tags($_POST['lioit_post_badge_text'])));
		update_post_meta($current_post, 'lioit_post_badge_color', esc_attr(strip_tags($_POST['lioit_post_badge_color'])));
		$post = get_post($current_post);
		
		wp_redirect($post->guid);
	}

}

?>

<?php  acf_form_head(); get_header(); the_post(); ?>
            <div id="main" class="container">
            	<div id="fullContent">
                <?php if(!empty($smof_data['allow_users_to_publish_posts'])) { ?>
                <?php if(current_user_can('publish_posts', $post_id)) { ?>
					<div class="singlePost">
                    	<?php ob_start(); ?>
                    <form action="" id="primaryPostForm" method="POST">
							<div class="row">
                            	<div class="span9">
                         				<div class="newpostTitle">
                                            <input type="text" name="postTitle" placeholder="<?php _e('Enter title here', 'lioit') ?>" id="postTitle" value="<?php echo $title; ?>" class="required" />
                            
											<?php if($postTitleError != '') { ?>
                                                <span class="error"><?php echo $postTitleError; ?></span>
                                                </div>
                                            <?php } ?>
                                    	</div>	
                            
                                     <div class="newPostEditor">
                                     	 <?php wp_editor( $content , 'post_content' ); ?>
                                        <?php /*?> <?php
											  if(class_exists('WP_Editor')){
												  global $wp_editor;
												  $media_bar = true; // set to true to show the media bar
												  $settings = array(); // additional settings,
												  
												  if(isset($action_edit_text)){
													  echo $wp_editor->editor($post_edit -> post_content, 'post_content', $settings, $media_bar);
												  }else{
													  echo $wp_editor->editor('', 'post_content', $settings, $media_bar);
												  }
											  }else{
												  if(isset($action_edit_text)){
													  wp_editor($post_edit -> $content,'post_content');
												  }else{
													  wp_editor('','post_content');
												  }
												  
											  }	
										  ?><?php */?>
										
						 
										<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
                                     
                                     </div><!--End Editor-->
                                      <div class="newPostColumn">
                                      	 <h4 class="newPostColumnTitle"><?php _e("Discussion","lioit"); ?></h4>
										 <div class="newPostColumnContent">
                                            <input name="advanced_view" type="hidden" value="1">
                                            
                                                <label for="comment_status"><input name="comment_status" type="checkbox" id="comment_status" value="<?php echo $comment_status; ?>"> Allow comments.</label>
                                                <label for="ping_status"><input name="ping_status" type="checkbox" id="ping_status" value="<?php echo $ping_status; ?>"> Allow <a href="http://codex.wordpress.org/Introduction_to_Blogging#Managing_Comments" target="_blank">trackbacks and pingbacks</a> on this page.</label>
                                             
                                            </div>	<!-- newPostColumnContent -->
                                      </div><!-- newPostColumn -->
                                </div><!--End Span9-->
                				<div class="span3">
                                		<div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Publish","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              
                                                <select name="post_status" id="post_status">
                                                <option value="publish"><?php _e('publish', 'lioit') ?></option>
                                                <option value="pending"><?php _e('pending', 'lioit') ?></option>
                                                <option value="draft"><?php _e('draft', 'lioit') ?></option>
                                                </select>
                                              	 <button type="submit" class="postsubmit btn"><?php _e('Update Post', 'lioit') ?></button>
                                                 
                                            
                                    
                                                 <?php if($poststatus == "trash") {?>
                                                      
                                                         <?php } elseif($poststatus =="private") { ?>
                                                         <div class="delete_post">
                                                        	<a onclick="return confirm('Are you sure you wish to delete post: <?php echo $title ?>?')" href="<?php echo get_delete_post_link($current_post ); ?>">
                                                            	<i class="icon-trash"></i><?php _e("Delete","lioit"); ?>
                                                            </a>
                                                        </div>
                                                         <?php } elseif($poststatus =="pending") { ?>
                                                         <div class="delete_post">
                                                        	<a onclick="return confirm('Are you sure you wish to delete post: <?php echo $title ?>?')" href="<?php echo get_delete_post_link( $current_post ); ?>">
                                                            	<i class="icon-trash"></i><?php _e("Delete","lioit"); ?>
                                                            </a>
                                                        </div>
                                                         <?php } elseif($poststatus =="publish") { ?>
                                                         <div class="delete_post">
                                                        	<a onclick="return confirm('Are you sure you wish to delete post: <?php echo $title ?>?')" href="<?php echo get_delete_post_link( $current_post ); ?>">
                                                            	<i class="icon-trash"></i><?php _e("Delete","lioit"); ?>
                                                            </a>
                                                        </div>
                                                         <?php } ?>
                               
                                                
                                              </div>
                                         </div><!-- newPostColumn -->
                                		
                                        <div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Post Badge","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              

                                              	<input type="text" name="lioit_post_badge_text" placeholder="<?php _e('Enter Badge Text', 'lioit') ?>" id="lioit_post_badge_text" value="<?php echo $badge_text; ?>" />
                                               
                                                <input type="text" name="lioit_post_badge_color" value="<?php echo $badge_color; ?>" class="my-color-field" data-default-color="#f2c500" />
												 <script type="text/javascript">
                                                    jQuery(document).ready(function($){
                                                        jQuery('.my-color-field').wpColorPicker();
                                                    });
                                                </script>
                                                
                                              </div>
                                            </div><!-- newPostColumn -->
                               			
                                        <div class="newPostColumn">
											
				
											<h4 class="newPostColumnTitle"><?php _e("Post Category","lioit"); ?></h4>
											
                                            <div class="newPostColumnContent">
                                              <?php
											  	setup_postdata($post);
												$terms = wp_get_post_terms( $current_post,"category" );
												$terms = isset($terms[0]) ? $terms[0]->term_id : "";
												?>
					
												<?php wp_dropdown_categories( array( 'taxonomy' => 'category' , 'hierarchical'=>1 , 'show_option_none'=>__('Choose Category:','lioit') , 'name' => 'post_category' ,'selected' => $terms ) ); ?>
												
												

                            
                                              </div>
                                      
                                         </div><!-- newPostColumn -->
                                	
											 <?php
												$tags = wp_get_post_tags( $current_post, array("fields"=>"names") );
												$tags = implode(",",$tags);
												?>
                                        	<script type="text/javascript">
												jQuery(document).ready(function($) {
                                            	// Tags Input
    											jQuery(".tagsinput").tagsInput();
												});
                                            </script>
                                            <div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Tags","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              	<input name="tagsinput" id="tagsinput" class="tagsinput" value="<?php echo $tags; ?>" />
                                              </div>
                                            </div><!-- newPostColumn -->
                                       
                                        
                                        <div class="newPostColumn">
                                              <h4 class="newPostColumnTitle"><?php _e("Featured Image","lioit"); ?></h4>
                                              <div class="newPostColumnContent">
                                              
                                                 
                                                <div class="acf-image-uploader clearfix <?php echo has_post_thumbnail() ? "active" : ""; ?>" data-preview_size="thumbnail" data-library="all">
                                                    <input class="acf-image-value" type="hidden" name="featured_image" value="<?php echo get_post_thumbnail_id($current_post); ?>">
                                                    <div class="has-image">
                                                        <div class="hover">
                                                            <ul class="bl">
                                                                <li><a class="acf-button-delete ir" href="#"><?php _e("Remove","lioit"); ?></a></li>
                                                                <li><a class="acf-button-edit ir" href="#"><?php _e("Edit","lioit"); ?></a></li>
                                                            </ul>
                                                        </div>
                                                        <?php if(has_post_thumbnail()): ?>
                                                            <?php echo the_post_thumbnail($current_post); ?>
                                                        <?php else: ?>
                                                            <img class="acf-image-image" src="" alt="">
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="no-image">
                                                        <p><?php _e("Choose Image","lioit"); ?> <input type="button" class="button add-image" value="<?php _e("Add Image","lioit"); ?>">
                                                        </p></div>
                                                </div>
                                                
                                              </div>
                                            </div><!-- newPostColumn -->
                                            
                                              	
                                        
                                </div><!--End Span3-->
                           
                			</div><!--End Row-->
                            <input type="hidden" name="submitted" id="submitted" value="true" />
                        </form>
                 	

            			
                     </div><!--End ContentBox-->
                     <?php } else { ?>
                        	<div class="row">
                            	<div class="span6 addpostLoginForm">
                                	<div class="widgetTitle"><h5><?php _e('Login','lioit'); ?></h5><span class="titleBorder"></span></div>
                                	<form action="<?php echo home_url(); ?>/wp-login.php" method="post" class="topAreaLoginform " novalidate>
                                      <p>
                                        <input type="text" name="log" id="log" class="required" placeholder="<?php _e( 'Username' , 'lioit' ) ?>" value="<?php echo esc_html(stripslashes($user_login), 1) ?>"></p>
                                         <p><input type="password" name="pwd" id="pwd" placeholder="<?php _e( 'Password' , 'lioit' ) ?>" class="required">
                                      </p>
                                      <!-- .loginFormInputs -->
                                      
                                      
                                      <p class="login-form-submit"> 
                                      	<span class="login-form-remember">
                                        <input class="remember-me checkbox" name="rememberme" id="rememberme" type="checkbox" checked="checked" value="forever">
                                        <label for="remember-me">
                                          <?php _e("Remember Me","lioit"); ?>
                                        </label>
                                        </span>
                                        <input type="hidden" name="action" value="log-in">
                                        <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>" />
                                        <button type="submit" class="btn btn-primary btn-large">
                                        <i class="icon-login"></i><span><?php _e("Sign in","lioit"); ?></span>
                                        </button>
                                      </p>
                                      
                                      <!-- .form-submit -->
                                    </form>
                                    <!-- .sign-in -->
                                </div><!--End span6-->
                                <div class="span6">
                                	<div class="widgetTitle"><h5><?php _e('Reset Password','lioit'); ?></h5><span class="titleBorder"></span></div>
                                    <form method="post" action="<?php echo site_url('wp-login.php?action=lostpassword', 'login_post') ?>" class="wp-user-form">
                                        <div class="username">
                                            <label for="user_login" class="hide"><?php _e('Username or Email :','lioit'); ?></label>
                                            <input type="text" name="user_login" value="" size="20" id="user_login" tabindex="1001" />
                                        </div>
                                        <div>
                                            <?php do_action('login_form', 'resetpass'); ?>
                                            <input type="submit" name="user-submit" value="<?php _e('Reset', 'lioit'); ?>" class="user-submit btn" tabindex="1002" />
                                            <?php $reset = $_GET['reset']; if($reset == true) { echo '<p>A message will be sent to your email address.</p>'; } ?>
                                            <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>?reset=true" />
                                            <input type="hidden" name="user-cookie" value="1" />
                                        </div>
                                    </form>
                                </div><!--End span6-->
                            </div><!--End Row-->
                        <?php } ?>
					 <?php } else { ?>
                  	 	<p><?php _e("Closed","lioit"); ?></p>
                     <?php } ?>
                    
                </div><!--End Main Content-->
            </div><!--End Main-->
        </div><!--End Content-->

<?php get_footer();?>