<?php
/*
    Template Name: Contact Page
*/
?>
<?php get_header();?>
 <?php 

global $smof_data; 

$map_data = null;
$count = 0;

for($i = 1; $i <= 10; $i++){
	if(!empty($smof_data['map-point-'.$i]) && $smof_data['map-point-'.$i] != 0 ) {
		$count++;
		$map_data[$count]['lat'] = $smof_data['latitude'.$i];
		$map_data[$count]['lng'] = $smof_data['longitude'.$i];
		$map_data[$count]['mapinfo'] = $smof_data['map-info'.$i];
	}	
}

function json_map_data() {
	global $map_data; 
	return $map_data;
}

wp_localize_script( 'customMap', 'map_data', json_map_data() );

?>
            <div id="main" class="container">
            	<div id="fullContent">
					<div class="singlePost">
                    	<?php if(have_posts()) : while(have_posts()) : the_post('');?>
                    	<div class="article row">
                        	<div class="articleDetails span12">
                            	<div class="articleTitle mainPageCenterTitle">
                                    <h1><?php the_title(); ?></h1>
                                </div><!--End articleTitle-->
                            </div><!--End Article Details-->
                            <div id="GoogleMap" class="span12" data-enable-animation="1" data-enable-zoom="<?php if(!empty($smof_data['enable-map-zoom'])) echo $smof_data['enable-map-zoom']; ?>" data-zoom-level="<?php if(!empty($smof_data['zoom-level'])) echo $smof_data['zoom-level']; ?>" data-center-lat="<?php if(!empty($smof_data['center-lat'])) echo $smof_data['center-lat']; ?>" data-center-lng="<?php if(!empty($smof_data['center-lng'])) echo $smof_data['center-lng']; ?>" data-marker-img="<?php if(!empty($smof_data['marker-img'])) echo $smof_data['marker-img']; ?>"></div>
                            <div class="articleContent span8">
                            	<div class="widgetTitle"><h5><i class="icon-doc"></i><?php _e('Contact Us','lioit') ?></h5></div>
                            	<?php the_content();?> 
                            </div><!--End ArticleContent-->
                            <div class="span4 contactDetails">
                            	<div class="contactColumn">
                                	<div class="widgetTitle"><h5><i class="icon-doc"></i><?php _e('Contact Information','lioit') ?></h5></div>
                                   <?php echo $smof_data['contact-info']; ?>
                                </div><!--End Column-->
                            	<div class="contactColumn">
                                	<div class="widgetTitle"><h5><i class="icon-doc"></i><?php _e('Find Us On','lioit') ?></h5></div>
                                    <ul class="social-icons coloredIcons clearfix">
                                      <?php if(!empty($smof_data['twitter'])) { ?>
                                         <li><a href="<?php echo $smof_data['twitter']; ?>" class="twitter" title="twitter"><i class="icon-twitter"></i></a></li>
                                      <?php } ?>
                                      <?php if(!empty($smof_data['facebook'])) { ?>
                                         <li><a href="<?php echo $smof_data['facebook']; ?>" class="facebook" title="facebook"><i class="icon-facebook"></i></a></li>
                                      <?php } ?>
                                      <?php if(!empty($smof_data['rss'])) { ?>
                                         <li><a href="<?php echo $smof_data['rss']; ?>" class="rss" title="rss"><i class="icon-rss"></i></a></li>
                                      <?php } ?>
                                      <?php if(!empty($smof_data['vimeo'])) { ?>
                                         <li><a href="<?php echo $smof_data['vimeo']; ?>" class="vimeo" title="vimeo"><i class="icon-vimeo"></i></a></li>
                                      <?php } ?>
                                      <?php if(!empty($smof_data['youtube'])) { ?>
                                         <li><a href="<?php echo $smof_data['youtube']; ?>" class="youtube" title="youtube"><i class="icon-youtube"></i></a></li>
                                      <?php } ?>
                                      <?php if(!empty($smof_data['tumblr'])) { ?>
                                         <li><a href="<?php echo $smof_data['tumblr']; ?>" class="tumblr" title="tumblr"><i class="icon-tumblr"></i></a></li>
                                      <?php } ?>
                                    
                                      <?php if(!empty($smof_data['skype'])) { ?>
                                         <li><a href="<?php echo $smof_data['skype']; ?>" class="skype" title="skype"><i class="icon-skype"></i></a></li>
                                      <?php } ?>
                                      <?php if(!empty($smof_data['dribbble'])) { ?>
                                         <li><a href="<?php echo $smof_data['dribbble']; ?>" class="dribbble" title="dribbble"><i class="icon-dribbble"></i></a></li>
                                      <?php } ?>
                                      <?php if(!empty($smof_data['wordpress'])) { ?>
                                         <li><a href="<?php echo $smof_data['wordpress']; ?>" class="wordpress" title="wordpress"><i class="icon-wordpress"></i></a></li>
                                      <?php } ?>

                                    </ul>
                                </div><!--End Column-->
                            </div><!--End contactDetails-->
                        </div><!--End article-->
                        <?php endwhile; ?>
						<?php  else:  ?>
                        <?php  endif; ?>
                    </div><!--End ContentBox-->
                </div><!--End Main Content-->
            </div><!--End Main-->
        </div><!--End Content-->
<script type='text/javascript'>
/* <![CDATA[ */
var map_data = {
	<?php if(!empty($data['map-point-1']) && $data['map-point-1'] == 1) { ?>
	"1":{"lat":"<?php if(!empty($data['latitude1'])) echo $data['latitude1']; ?>",
	"lng":"<?php if(!empty($data['longitude1'])) echo $data['longitude1']; ?>",
	"mapinfo":"<?php if(!empty($data['map-info1'])) echo $data['map-info1']; ?>"},
	<?php } ?>
	<?php if(!empty($data['map-point-2']) && $data['map-point-2'] == 1) { ?>
	"2":{"lat":"<?php if(!empty($data['latitude2'])) echo $data['latitude2']; ?>",
	"lng":"<?php if(!empty($data['longitude2'])) echo $data['longitude2']; ?>",
	"mapinfo":"<?php if(!empty($data['map-info2'])) echo $data['map-info2']; ?>"},
	<?php } ?>
	<?php if(!empty($data['map-point-3']) && $data['map-point-3'] == 1) { ?>
	"3":{"lat":"<?php if(!empty($data['latitude3'])) echo $data['latitude3']; ?>",
	"lng":"<?php if(!empty($data['longitude3'])) echo $data['longitude3']; ?>",
	"mapinfo":"<?php if(!empty($data['map-info3'])) echo $data['map-info3']; ?>"},
	<?php } ?>
	<?php if(!empty($data['map-point-4']) && $data['map-point-4'] == 1) { ?>
	"4":{"lat":"<?php if(!empty($data['latitude4'])) echo $data['latitude4']; ?>",
	"lng":"<?php if(!empty($data['longitude4'])) echo $data['longitude4']; ?>",
	"mapinfo":"<?php if(!empty($data['map-info4'])) echo $data['map-info4']; ?>"},
	<?php } ?>
	<?php if(!empty($data['map-point-5']) && $data['map-point-5'] == 1) { ?>
	"5":{"lat":"<?php if(!empty($data['latitude5'])) echo $data['latitude5']; ?>",
	"lng":"<?php if(!empty($data['longitude5'])) echo $data['longitude5']; ?>",
	"mapinfo":"<?php if(!empty($data['map-info5'])) echo $data['map-info5']; ?>"},
	<?php } ?>
	
	
	};
/* ]]> */
</script>

<?php wp_register_script('googleMaps', 'http://maps.google.com/maps/api/js?sensor=false', NULL, NULL, TRUE);
		wp_register_script('customMap', Lioit_JS . '/map.js', array('jquery', 'googleMaps'), '1.0', TRUE);
		
		wp_enqueue_script('googleMaps');
		wp_enqueue_script('customMap'); get_footer();?>

