<?php
/*
    Template Name: Blog Timeline
*/
?>
<?php get_header();?>
            <div id="main" class="container">
            	<div class="singlePageContent pageContent">
                            	<div class="container">
                                	<div class="blogTimeline">
                                        <div class="timelineHead"><i class="icon-comments"></i></div>
                                        <ul class="timeline">
                                        	<?php 
											$temp = $wp_query; $wp_query= null;
											$wp_query = new WP_Query(); $wp_query->query('showposts=10' . '&paged='.$paged);
											while ($wp_query->have_posts()) : $wp_query->the_post(); ?>
                                            <li class="timelinePost">
                                                <div class="timelinePostContent clearfix">
                                                    <div class="timelineDot"></div>
                                                    <div class="timelineDate"><span><i class="icon-calendar"></i><?php the_time('F d, Y'); ?></span></div>
                                                    <div class="timelinePostWrap">
                                                        <div class="timelinePostThumb">
                                                            
                                                            <a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title(); ?>">
                                                            <?php the_post_thumbnail('slider2', array('title' => strip_tags(get_the_title()))); ?>
                                                            </a>
                                                        </div>
                                                        <h2 class="timelinePostTitle">
                                                        <a href="<?php the_permalink();?>">
														<?php 
															$badge_text = get_post_meta($post->ID, 'lioit_post_badge_text', true);
															$badge_color = get_post_meta($post->ID, 'lioit_post_badge_color', true);
														?>
                                        				<?php if ($badge_text) { ?>
                                        				<div class="articleType" style="background-color:<?php echo $badge_color; ?>;">
															<?php echo $badge_text; ?>
                                                        </div>
                                        				<?php } ?>
														<?php the_title(); ?>
                                                        </a>
                                                        </h2>
                                                        <ul class="postMeta">
															<?php
                                                            $lioit_review_enable =  get_post_meta($post->ID, 'lioit_review_enable', true);
                                                            $lioit_review_type =  get_post_meta($post->ID, 'lioit_review_type', true);
                                                            $lioit_final_score =  get_post_meta($post->ID, 'lioit_final_score', true);
                                                            $lioit_final_percentage = $lioit_final_score * 20 ;
                                                            ?>
                                                            <?php if($lioit_review_enable == 'enable'){ ?>
                                                            <li>
                                                                <span class="lioit-rating lioit-rating-<?php echo esc_html($lioit_review_type); ?>">
                                                                    <span style="width:<?php echo esc_html($lioit_final_percentage); ?>%;"></span>
                                                                </span>
                                                            </li>
                                                            <?php } ?>
                                                            <li class="postViews"><i class="icon-eye-open"></i><?php echo getPostViews($post->ID); ?> </li>
                                                            <li class="postAuthor"><i class="icon-user"></i><?php _e('By','lioit') ?> <?php the_author_posts_link(); ?></li>
                                                            <li class="postCategory"><i class="icon-folder-open"></i><?php _e('in','lioit') ?> <?php the_category(', ') ?></li>
                                                            <li class="postComments"><i class="icon-comment"></i><?php comments_popup_link(__(' 0', 'lioit'), __('1', 'lioit'), __('%', 'lioit')); ?></li>
                                                        </ul><!--End postMeta-->
                                                        <p><?php echo excerpt(30); ?></p>
                                                        <div class="timelinePostMeta">
                                                        	<div class="postTags">
                                                                <?php the_tags('','',''); ?>
                                                            </div><!--End PostTags-->
                                                        	<a href="<?php the_permalink();?>" class="postMore btn">Read More <i class="icon-right-open"></i></a>
                                                        </div><!--End TimeLineMeta-->
                                                    </div><!--End timelinePostWrap--> 
                                                </div><!--End timelinePostContent--> 
                                            </li><!--End timelinePost-->
                                            <?php endwhile; ?>
											<?php if ($paged > 1) { ?>
                                            <?php } else { ?>
                                            <?php } ?>
                                            <?php wp_reset_postdata(); ?>
                                        </ul>
                                        
                                        <div class="timelineNav">
                                            <div class="timelineDot"></div>
                                            <ul>
                                                <li class="left-nav"><?php previous_posts_link('<i class="icon-angle-left"></i>'); ?></li>
                                                <li class="right-nav"><?php next_posts_link('<i class="icon-angle-right"></i>'); ?></li>
                                            </ul>
                                        </div>
                                        
                                    </div><!--End TimeLine-->
                                </div><!--End Container-->
                        </div><!--End singlePageContent-->
            </div><!--End Main-->
        </div><!--End Content-->
<?php get_footer();?>
