<?php

	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
    <br />
    <div class="info-box">
		<span class="color"><?php _e("This post is password protected. Enter the password to view comments.", 'lioit'); ?></span>
    </div>
	<?php
		return;
	}
?>

<?php if ( have_comments() ) : ?>

<!-- Start Comments -->
      
	


    <div class="homeTitle">
      <h2><?php comments_number( __("No Comments", 'lioit'), __("Comments ( 1 )", 'lioit'), __("Comments ( % )", 'lioit') );?></h2>
    </div>
	<ul class="comment-list">
		<?php wp_list_comments('callback=wordpressapi_comments'); ?>
	</ul>
    
    <div class="clearfix"></div>
    

    
    <div class="pagination-comments top color">
		<?php paginate_comments_links( array('prev_text' => 'Previous', 'next_text' => 'Next') ); ?>
	</div>

	
 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->

	 <?php else : // comments are closed ?>
    <br />
   

	<?php endif; ?>
	
<?php endif; ?>

<?php if ( comments_open() ) : ?>

<div class="respond" class="form">

<script>
    jQuery(document).ready(function($) {
     $("input#submit").addClass("btn ButtonShadow darkBtn");
    });
    </script>

<?php 

$commenter = wp_get_current_commenter();
$req = get_option( 'require_name_email' );
$aria_req = ( $req ? " aria-required='true'" : '' );

$comments_args = array(
	'id_form' => 'commentform',
	'id_submit' => 'submit',
    'title_reply' => __('<div class="widgetTitle">
            <h5><i class="icon-comments"></i>
              Leave a Comment           </h5>
            <span class="titleBorder bigTitleBorder"></span> </div>', 'lioit'),
    'title_reply_to' => __( 'Leave a Reply to %s', 'lioit' ),
	'cancel_reply_link' => __( '<small><span class="color">Click here to cancel reply</span></small>', 'lioit' ),
	'label_submit' => __( 'Add Comment', 'lioit' ),
    'comment_notes_before' => '',
	'comment_notes_after' => '<div class="clearfix"></div><p class="form-allowed-tags">' . sprintf( __( 'You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s' ), ' <code>' . allowed_tags() . '</code>' ) . '</p>',
    'comment_field' => '<div class="textareaComment"><label for="comment">' . __('Comment', 'lioit') . '</label>
    <textarea name="comment" id="comment" tabindex="4" aria-required="true"></textarea></div><!-- End Box -->',
    'must_log_in' => '<div class="info-box"><span class="color">' .  sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'lioit' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</span></div>',
    'logged_in_as' => '<div class="info-box"><span class="color">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out ?</a>', 'lioit' ), admin_url( 'profile.php' ), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</span></div><br class="appear">',
    'fields' => apply_filters( 'comment_form_default_fields', array(
		'author' => '<div class="commentsFormInputs"><div class="form-box">' . '<label for="author">' . __( 'Name', 'lioit' ) . '' . ( $req ? " <small>(".__("*", 'lioit').")</small>" : '' ) . '</label> <input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '"' . $aria_req . ' class="text"/></div><!-- End Box -->',
		'email' => '<div class="form-box"><label for="email">' . __( 'Email', 'lioit' ) . ' <small>(' . ( $req ? " ".__("will not be published", 'lioit').")</small> <small>(".__("*", 'lioit').")</small>" : '' ) . '</label> <input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" ' . $aria_req . ' class="text"/></div><!-- End Box -->',
		'url' => '<div class="form-box last"><label for="url">' . __( 'Website', 'lioit' ) . '' . '</label><input id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '"  class="text"/></div><!-- End Box --></div><!-- End Box -->' ) ) 
    );

comment_form($comments_args);

?>

</div>

<?php else : // comments are closed ?>

<br />
    
  <?php endif; ?>
