<?php

add_action('init','of_options');

if (!function_exists('of_options'))
{
	function of_options()
	{
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages('sort_column=post_parent,menu_order');    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");       
	
		//Testing 
		$of_options_select 	= array("one","two","three","four","five"); 
		$of_options_radioed 	= array("Enabled" => "Enabled","Disabled" => "Disabled");
		$of_options_radio 	= array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
		
		//HOMEPAGE BLOCKS
$of_options_homepage_blocks = array(
	"enabled" => array (
		"placebo" => "placebo", //REQUIRED!
		"index-latest-posts" => __('Latest Posts', 'lioit'),
		"index-latest-posts-columns" => __('Latest Posts Grid', 'lioit'),
		"index-carousel-posts" => __('Carousel Posts', 'lioit'),
		"index-big-boxs" => __('Big Boxs', 'lioit'),
		"index-images" => __('News In Picture', 'lioit'),
		"index-tabs" => __('News Tabs', 'lioit'),
		"index-small-boxs" => __('Small Boxs', 'lioit'),
		"index-videos" => __('Videos', 'lioit'),
		"index-gallery" => __('Gallery', 'lioit'),
		
	),
	"disabled" => array (
		"placebo" => "placebo", //REQUIRED!
		
		
		
	),
);



//HOMEPAGE BLOCKS
$of_options_bigboxs_blocks = array(
	"enabled" => array (
		"placebo" => "placebo", //REQUIRED!
		"box-one"	=> __('Box 1', 'lioit'),
		"box-tow"	=> __('Box 2', 'lioit'),
		"box-three"	=> __('Box 3', 'lioit'),
		"box-four"	=> __('Box 4', 'lioit'),
		"box-five"	=> __('Box 5', 'lioit'),
		
	),
	"disabled" => array (
		"placebo" => "placebo", //REQUIRED!
		"box-six" => __('Box 6', 'lioit'),
		"box-seven" => __('Box 7', 'lioit'),
		"box-eight" => __('Box 8', 'lioit'),
		"box-nine" => __('Box 9', 'lioit'),
		"box-ten" => __('Box 10', 'lioit')
		
		
	),
);


//HOMEPAGE BLOCKS
$of_options_smallboxs_blocks = array(
	"enabled" => array (
		
		"sbox-one"	=> __('Box 1', 'lioit'),
		"sbox-tow"	=> __('Box 2', 'lioit'),
		"sbox-three"	=> __('Box 3', 'lioit'),
		"sbox-four"	=> __('Box 4', 'lioit'),
		
		
	),
	"disabled" => array (
		"sbox-five"	=> __('Box 5', 'lioit'),
		"sbox-six" => __('Box 6', 'lioit'),
		"sbox-seven" => __('Box 7', 'lioit'),
		"sbox-eight" => __('Box 8', 'lioit'),
		"sbox-nine" => __('Box 9', 'lioit'),
		"sbox-ten" => __('Box 10', 'lioit')
		
		
	),
);

//STYLESHEET 





		//Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$alt_stylesheets = array();
		
		if ( is_dir($alt_stylesheet_path) ) 
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) 
		    { 
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) 
		        {
		            if(stristr($alt_stylesheet_file, ".css") !== false)
		            {
		                $alt_stylesheets[] = $alt_stylesheet_file;
		            }
		        }    
		    }
		}


		//Background Images Reader
		$bg_images_path = get_stylesheet_directory(). '/images/bg/'; // change this to where you store your bg images
		$bg_images_url = get_template_directory_uri().'/images/bg/'; // change this to where you store your bg images
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
		    if ($bg_images_dir = opendir($bg_images_path) ) { 
		        while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
		            if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
		            	natsort($bg_images); //Sorts the array into a natural order
		                $bg_images[] = $bg_images_url . $bg_images_file;
		            }
		        }    
		    }
		}
		

		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr 		= wp_upload_dir();
		$all_uploads_path 	= $uploads_arr['path'];
		$all_uploads 		= get_option('of_uploads');
		$other_entries 		= array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
		$body_repeat 		= array("no-repeat","repeat-x","repeat-y","repeat");
		$body_pos 			= array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");
		$body_attachment = array("fixed","scroll","inherit");
		// Image Alignment radio box
		$of_options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 
		
		// Image Links to Options
		$of_options_image_link_to = array("image" => "The Image","post" => "The Post"); 
		$weather_units 	= array("metric" => "Metric","imperial" => "Imperial");
		$font_sizes = array(
            '10' => '10',
            '11' => '11',
            '12' => '12',
            '13' => '13',
            '14' => '14',
            '15' => '15',
            '16' => '16',
            '17' => '17',
            '18' => '18',
            '19' => '19',
            '20' => '20',
            '21' => '21',
            '22' => '22',
            '23' => '23',
            '24' => '24',
            '25' => '25',
            '26' => '26',
            '27' => '27',
            '28' => '28',
            '29' => '29',
            '30' => '30',
            '31' => '31',
            '32' => '32',
            '33' => '33',
            '34' => '34',
            '35' => '35',
            '36' => '36',
            '37' => '37',
            '38' => '38',
            '39' => '39',
            '40' => '40',
            '41' => '41',
            '42' => '42',
            '43' => '43',
            '44' => '44',
            '45' => '45',
            '46' => '46',
            '47' => '47',
            '48' => '48',
            '49' => '49',
            '50' => '50',
        );

        $google_fonts = array(
            "0" => "Select Font",
            "ABeeZee" => "ABeeZee",
            "Abel" => "Abel",
            "Abril Fatface" => "Abril Fatface",
            "Aclonica" => "Aclonica",
            "Acme" => "Acme",
            "Actor" => "Actor",
            "Adamina" => "Adamina",
            "Advent Pro" => "Advent Pro",
            "Aguafina Script" => "Aguafina Script",
            "Akronim" => "Akronim",
            "Aladin" => "Aladin",
            "Aldrich" => "Aldrich",
            "Alef" => "Alef",
            "Alegreya" => "Alegreya",
            "Alegreya SC" => "Alegreya SC",
            "Alegreya Sans" => "Alegreya Sans",
            "Alegreya Sans SC" => "Alegreya Sans SC",
            "Alex Brush" => "Alex Brush",
            "Alfa Slab One" => "Alfa Slab One",
            "Alice" => "Alice",
            "Alike" => "Alike",
            "Alike Angular" => "Alike Angular",
            "Allan" => "Allan",
            "Allerta" => "Allerta",
            "Allerta Stencil" => "Allerta Stencil",
            "Allura" => "Allura",
            "Almendra" => "Almendra",
            "Almendra Display" => "Almendra Display",
            "Almendra SC" => "Almendra SC",
            "Amarante" => "Amarante",
            "Amaranth" => "Amaranth",
            "Amatic SC" => "Amatic SC",
            "Amethysta" => "Amethysta",
            "Anaheim" => "Anaheim",
            "Andada" => "Andada",
            "Andika" => "Andika",
            "Angkor" => "Angkor",
            "Annie Use Your Telescope" => "Annie Use Your Telescope",
            "Anonymous Pro" => "Anonymous Pro",
            "Antic" => "Antic",
            "Antic Didone" => "Antic Didone",
            "Antic Slab" => "Antic Slab",
            "Anton" => "Anton",
            "Arapey" => "Arapey",
            "Arbutus" => "Arbutus",
            "Arbutus Slab" => "Arbutus Slab",
            "Architects Daughter" => "Architects Daughter",
            "Archivo Black" => "Archivo Black",
            "Archivo Narrow" => "Archivo Narrow",
            "Arimo" => "Arimo",
            "Arizonia" => "Arizonia",
            "Armata" => "Armata",
            "Artifika" => "Artifika",
            "Arvo" => "Arvo",
            "Asap" => "Asap",
            "Asset" => "Asset",
            "Astloch" => "Astloch",
            "Asul" => "Asul",
            "Atomic Age" => "Atomic Age",
            "Aubrey" => "Aubrey",
            "Audiowide" => "Audiowide",
            "Autour One" => "Autour One",
            "Average" => "Average",
            "Average Sans" => "Average Sans",
            "Averia Gruesa Libre" => "Averia Gruesa Libre",
            "Averia Libre" => "Averia Libre",
            "Averia Sans Libre" => "Averia Sans Libre",
            "Averia Serif Libre" => "Averia Serif Libre",
            "Bad Script" => "Bad Script",
            "Balthazar" => "Balthazar",
            "Bangers" => "Bangers",
            "Basic" => "Basic",
            "Battambang" => "Battambang",
            "Baumans" => "Baumans",
            "Bayon" => "Bayon",
            "Belgrano" => "Belgrano",
            "Belleza" => "Belleza",
            "BenchNine" => "BenchNine",
            "Bentham" => "Bentham",
            "Berkshire Swash" => "Berkshire Swash",
            "Bevan" => "Bevan",
            "Bigelow Rules" => "Bigelow Rules",
            "Bigshot One" => "Bigshot One",
            "Bilbo" => "Bilbo",
            "Bilbo Swash Caps" => "Bilbo Swash Caps",
            "Bitter" => "Bitter",
            "Black Ops One" => "Black Ops One",
            "Bokor" => "Bokor",
            "Bonbon" => "Bonbon",
            "Boogaloo" => "Boogaloo",
            "Bowlby One" => "Bowlby One",
            "Bowlby One SC" => "Bowlby One SC",
            "Brawler" => "Brawler",
            "Bree Serif" => "Bree Serif",
            "Bubblegum Sans" => "Bubblegum Sans",
            "Bubbler One" => "Bubbler One",
            "Buda" => "Buda",
            "Buenard" => "Buenard",
            "Butcherman" => "Butcherman",
            "Butterfly Kids" => "Butterfly Kids",
            "Cabin" => "Cabin",
            "Cabin Condensed" => "Cabin Condensed",
            "Cabin Sketch" => "Cabin Sketch",
            "Caesar Dressing" => "Caesar Dressing",
            "Cagliostro" => "Cagliostro",
            "Calligraffitti" => "Calligraffitti",
            "Cambo" => "Cambo",
            "Candal" => "Candal",
            "Cantarell" => "Cantarell",
            "Cantata One" => "Cantata One",
            "Cantora One" => "Cantora One",
            "Capriola" => "Capriola",
            "Cardo" => "Cardo",
            "Carme" => "Carme",
            "Carrois Gothic" => "Carrois Gothic",
            "Carrois Gothic SC" => "Carrois Gothic SC",
            "Carter One" => "Carter One",
            "Caudex" => "Caudex",
            "Cedarville Cursive" => "Cedarville Cursive",
            "Ceviche One" => "Ceviche One",
            "Changa One" => "Changa One",
            "Chango" => "Chango",
            "Chau Philomene One" => "Chau Philomene One",
            "Chela One" => "Chela One",
            "Chelsea Market" => "Chelsea Market",
            "Chenla" => "Chenla",
            "Cherry Cream Soda" => "Cherry Cream Soda",
            "Cherry Swash" => "Cherry Swash",
            "Chewy" => "Chewy",
            "Chicle" => "Chicle",
            "Chivo" => "Chivo",
            "Cinzel" => "Cinzel",
            "Cinzel Decorative" => "Cinzel Decorative",
            "Clicker Script" => "Clicker Script",
            "Coda" => "Coda",
            "Coda Caption" => "Coda Caption",
            "Codystar" => "Codystar",
            "Combo" => "Combo",
            "Comfortaa" => "Comfortaa",
            "Coming Soon" => "Coming Soon",
            "Concert One" => "Concert One",
            "Condiment" => "Condiment",
            "Content" => "Content",
            "Contrail One" => "Contrail One",
            "Convergence" => "Convergence",
            "Cookie" => "Cookie",
            "Copse" => "Copse",
            "Corben" => "Corben",
            "Courgette" => "Courgette",
            "Cousine" => "Cousine",
            "Coustard" => "Coustard",
            "Covered By Your Grace" => "Covered By Your Grace",
            "Crafty Girls" => "Crafty Girls",
            "Creepster" => "Creepster",
            "Crete Round" => "Crete Round",
            "Crimson Text" => "Crimson Text",
            "Croissant One" => "Croissant One",
            "Crushed" => "Crushed",
            "Cuprum" => "Cuprum",
            "Cutive" => "Cutive",
            "Cutive Mono" => "Cutive Mono",
            "Damion" => "Damion",
            "Dancing Script" => "Dancing Script",
            "Dangrek" => "Dangrek",
            "Dawning of a New Day" => "Dawning of a New Day",
            "Days One" => "Days One",
            "Delius" => "Delius",
            "Delius Swash Caps" => "Delius Swash Caps",
            "Delius Unicase" => "Delius Unicase",
            "Della Respira" => "Della Respira",
            "Denk One" => "Denk One",
            "Devonshire" => "Devonshire",
            "Didact Gothic" => "Didact Gothic",
            "Diplomata" => "Diplomata",
            "Diplomata SC" => "Diplomata SC",
            "Domine" => "Domine",
            "Donegal One" => "Donegal One",
            "Doppio One" => "Doppio One",
            "Dorsa" => "Dorsa",
            "Dosis" => "Dosis",
            "Dr Sugiyama" => "Dr Sugiyama",
            "Droid Sans" => "Droid Sans",
            "Droid Sans Mono" => "Droid Sans Mono",
            "Droid Serif" => "Droid Serif",
            "Duru Sans" => "Duru Sans",
            "Dynalight" => "Dynalight",
            "EB Garamond" => "EB Garamond",
            "Eagle Lake" => "Eagle Lake",
            "Eater" => "Eater",
            "Economica" => "Economica",
            "Electrolize" => "Electrolize",
            "Elsie" => "Elsie",
            "Elsie Swash Caps" => "Elsie Swash Caps",
            "Emblema One" => "Emblema One",
            "Emilys Candy" => "Emilys Candy",
            "Engagement" => "Engagement",
            "Englebert" => "Englebert",
            "Enriqueta" => "Enriqueta",
            "Erica One" => "Erica One",
            "Esteban" => "Esteban",
            "Euphoria Script" => "Euphoria Script",
            "Ewert" => "Ewert",
            "Exo" => "Exo",
            "Exo 2" => "Exo 2",
            "Expletus Sans" => "Expletus Sans",
            "Fanwood Text" => "Fanwood Text",
            "Fascinate" => "Fascinate",
            "Fascinate Inline" => "Fascinate Inline",
            "Faster One" => "Faster One",
            "Fasthand" => "Fasthand",
            "Fauna One" => "Fauna One",
            "Federant" => "Federant",
            "Federo" => "Federo",
            "Felipa" => "Felipa",
            "Fenix" => "Fenix",
            "Finger Paint" => "Finger Paint",
            "Fjalla One" => "Fjalla One",
            "Fjord One" => "Fjord One",
            "Flamenco" => "Flamenco",
            "Flavors" => "Flavors",
            "Fondamento" => "Fondamento",
            "Fontdiner Swanky" => "Fontdiner Swanky",
            "Forum" => "Forum",
            "Francois One" => "Francois One",
            "Freckle Face" => "Freckle Face",
            "Fredericka the Great" => "Fredericka the Great",
            "Fredoka One" => "Fredoka One",
            "Freehand" => "Freehand",
            "Fresca" => "Fresca",
            "Frijole" => "Frijole",
            "Fruktur" => "Fruktur",
            "Fugaz One" => "Fugaz One",
            "GFS Didot" => "GFS Didot",
            "GFS Neohellenic" => "GFS Neohellenic",
            "Gabriela" => "Gabriela",
            "Gafata" => "Gafata",
            "Galdeano" => "Galdeano",
            "Galindo" => "Galindo",
            "Gentium Basic" => "Gentium Basic",
            "Gentium Book Basic" => "Gentium Book Basic",
            "Geo" => "Geo",
            "Geostar" => "Geostar",
            "Geostar Fill" => "Geostar Fill",
            "Germania One" => "Germania One",
            "Gilda Display" => "Gilda Display",
            "Give You Glory" => "Give You Glory",
            "Glass Antiqua" => "Glass Antiqua",
            "Glegoo" => "Glegoo",
            "Gloria Hallelujah" => "Gloria Hallelujah",
            "Goblin One" => "Goblin One",
            "Gochi Hand" => "Gochi Hand",
            "Gorditas" => "Gorditas",
            "Goudy Bookletter 1911" => "Goudy Bookletter 1911",
            "Graduate" => "Graduate",
            "Grand Hotel" => "Grand Hotel",
            "Gravitas One" => "Gravitas One",
            "Great Vibes" => "Great Vibes",
            "Griffy" => "Griffy",
            "Gruppo" => "Gruppo",
            "Gudea" => "Gudea",
            "Habibi" => "Habibi",
            "Hammersmith One" => "Hammersmith One",
            "Hanalei" => "Hanalei",
            "Hanalei Fill" => "Hanalei Fill",
            "Handlee" => "Handlee",
            "Hanuman" => "Hanuman",
            "Happy Monkey" => "Happy Monkey",
            "Headland One" => "Headland One",
            "Henny Penny" => "Henny Penny",
            "Herr Von Muellerhoff" => "Herr Von Muellerhoff",
            "Holtwood One SC" => "Holtwood One SC",
            "Homemade Apple" => "Homemade Apple",
            "Homenaje" => "Homenaje",
            "IM Fell DW Pica" => "IM Fell DW Pica",
            "IM Fell DW Pica SC" => "IM Fell DW Pica SC",
            "IM Fell Double Pica" => "IM Fell Double Pica",
            "IM Fell Double Pica SC" => "IM Fell Double Pica SC",
            "IM Fell English" => "IM Fell English",
            "IM Fell English SC" => "IM Fell English SC",
            "IM Fell French Canon" => "IM Fell French Canon",
            "IM Fell French Canon SC" => "IM Fell French Canon SC",
            "IM Fell Great Primer" => "IM Fell Great Primer",
            "IM Fell Great Primer SC" => "IM Fell Great Primer SC",
            "Iceberg" => "Iceberg",
            "Iceland" => "Iceland",
            "Imprima" => "Imprima",
            "Inconsolata" => "Inconsolata",
            "Inder" => "Inder",
            "Indie Flower" => "Indie Flower",
            "Inika" => "Inika",
            "Irish Grover" => "Irish Grover",
            "Istok Web" => "Istok Web",
            "Italiana" => "Italiana",
            "Italianno" => "Italianno",
            "Jacques Francois" => "Jacques Francois",
            "Jacques Francois Shadow" => "Jacques Francois Shadow",
            "Jim Nightshade" => "Jim Nightshade",
            "Jockey One" => "Jockey One",
            "Jolly Lodger" => "Jolly Lodger",
            "Josefin Sans" => "Josefin Sans",
            "Josefin Slab" => "Josefin Slab",
            "Joti One" => "Joti One",
            "Judson" => "Judson",
            "Julee" => "Julee",
            "Julius Sans One" => "Julius Sans One",
            "Junge" => "Junge",
            "Jura" => "Jura",
            "Just Another Hand" => "Just Another Hand",
            "Just Me Again Down Here" => "Just Me Again Down Here",
            "Kameron" => "Kameron",
            "Kantumruy" => "Kantumruy",
            "Karla" => "Karla",
            "Kaushan Script" => "Kaushan Script",
            "Kavoon" => "Kavoon",
            "Kdam Thmor" => "Kdam Thmor",
            "Keania One" => "Keania One",
            "Kelly Slab" => "Kelly Slab",
            "Kenia" => "Kenia",
            "Khmer" => "Khmer",
            "Kite One" => "Kite One",
            "Knewave" => "Knewave",
            "Kotta One" => "Kotta One",
            "Koulen" => "Koulen",
            "Kranky" => "Kranky",
            "Kreon" => "Kreon",
            "Kristi" => "Kristi",
            "Krona One" => "Krona One",
            "La Belle Aurore" => "La Belle Aurore",
            "Lancelot" => "Lancelot",
            "Lato" => "Lato",
            "League Script" => "League Script",
            "Leckerli One" => "Leckerli One",
            "Ledger" => "Ledger",
            "Lekton" => "Lekton",
            "Lemon" => "Lemon",
            "Libre Baskerville" => "Libre Baskerville",
            "Life Savers" => "Life Savers",
            "Lilita One" => "Lilita One",
            "Lily Script One" => "Lily Script One",
            "Limelight" => "Limelight",
            "Linden Hill" => "Linden Hill",
            "Lobster" => "Lobster",
            "Lobster Two" => "Lobster Two",
            "Londrina Outline" => "Londrina Outline",
            "Londrina Shadow" => "Londrina Shadow",
            "Londrina Sketch" => "Londrina Sketch",
            "Londrina Solid" => "Londrina Solid",
            "Lora" => "Lora",
            "Love Ya Like A Sister" => "Love Ya Like A Sister",
            "Loved by the King" => "Loved by the King",
            "Lovers Quarrel" => "Lovers Quarrel",
            "Luckiest Guy" => "Luckiest Guy",
            "Lusitana" => "Lusitana",
            "Lustria" => "Lustria",
            "Macondo" => "Macondo",
            "Macondo Swash Caps" => "Macondo Swash Caps",
            "Magra" => "Magra",
            "Maiden Orange" => "Maiden Orange",
            "Mako" => "Mako",
            "Marcellus" => "Marcellus",
            "Marcellus SC" => "Marcellus SC",
            "Marck Script" => "Marck Script",
            "Margarine" => "Margarine",
            "Marko One" => "Marko One",
            "Marmelad" => "Marmelad",
            "Marvel" => "Marvel",
            "Mate" => "Mate",
            "Mate SC" => "Mate SC",
            "Maven Pro" => "Maven Pro",
            "McLaren" => "McLaren",
            "Meddon" => "Meddon",
            "MedievalSharp" => "MedievalSharp",
            "Medula One" => "Medula One",
            "Megrim" => "Megrim",
            "Meie Script" => "Meie Script",
            "Merienda" => "Merienda",
            "Merienda One" => "Merienda One",
            "Merriweather" => "Merriweather",
            "Merriweather Sans" => "Merriweather Sans",
            "Metal" => "Metal",
            "Metal Mania" => "Metal Mania",
            "Metamorphous" => "Metamorphous",
            "Metrophobic" => "Metrophobic",
            "Michroma" => "Michroma",
            "Milonga" => "Milonga",
            "Miltonian" => "Miltonian",
            "Miltonian Tattoo" => "Miltonian Tattoo",
            "Miniver" => "Miniver",
            "Miss Fajardose" => "Miss Fajardose",
            "Modern Antiqua" => "Modern Antiqua",
            "Molengo" => "Molengo",
            "Molle" => "Molle",
            "Monda" => "Monda",
            "Monofett" => "Monofett",
            "Monoton" => "Monoton",
            "Monsieur La Doulaise" => "Monsieur La Doulaise",
            "Montaga" => "Montaga",
            "Montez" => "Montez",
            "Montserrat" => "Montserrat",
            "Montserrat Alternates" => "Montserrat Alternates",
            "Montserrat Subrayada" => "Montserrat Subrayada",
            "Moul" => "Moul",
            "Moulpali" => "Moulpali",
            "Mountains of Christmas" => "Mountains of Christmas",
            "Mouse Memoirs" => "Mouse Memoirs",
            "Mr Bedfort" => "Mr Bedfort",
            "Mr Dafoe" => "Mr Dafoe",
            "Mr De Haviland" => "Mr De Haviland",
            "Mrs Saint Delafield" => "Mrs Saint Delafield",
            "Mrs Sheppards" => "Mrs Sheppards",
            "Muli" => "Muli",
            "Mystery Quest" => "Mystery Quest",
            "Neucha" => "Neucha",
            "Neuton" => "Neuton",
            "New Rocker" => "New Rocker",
            "News Cycle" => "News Cycle",
            "Niconne" => "Niconne",
            "Nixie One" => "Nixie One",
            "Nobile" => "Nobile",
            "Nokora" => "Nokora",
            "Norican" => "Norican",
            "Nosifer" => "Nosifer",
            "Nothing You Could Do" => "Nothing You Could Do",
            "Noticia Text" => "Noticia Text",
            "Noto Sans" => "Noto Sans",
            "Noto Serif" => "Noto Serif",
            "Nova Cut" => "Nova Cut",
            "Nova Flat" => "Nova Flat",
            "Nova Mono" => "Nova Mono",
            "Nova Oval" => "Nova Oval",
            "Nova Round" => "Nova Round",
            "Nova Script" => "Nova Script",
            "Nova Slim" => "Nova Slim",
            "Nova Square" => "Nova Square",
            "Numans" => "Numans",
            "Nunito" => "Nunito",
            "Odor Mean Chey" => "Odor Mean Chey",
            "Offside" => "Offside",
            "Old Standard TT" => "Old Standard TT",
            "Oldenburg" => "Oldenburg",
            "Oleo Script" => "Oleo Script",
            "Oleo Script Swash Caps" => "Oleo Script Swash Caps",
            "Open Sans" => "Open Sans",
            "Open Sans Condensed" => "Open Sans Condensed",
            "Oranienbaum" => "Oranienbaum",
            "Orbitron" => "Orbitron",
            "Oregano" => "Oregano",
            "Orienta" => "Orienta",
            "Original Surfer" => "Original Surfer",
            "Oswald" => "Oswald",
            "Over the Rainbow" => "Over the Rainbow",
            "Overlock" => "Overlock",
            "Overlock SC" => "Overlock SC",
            "Ovo" => "Ovo",
            "Oxygen" => "Oxygen",
            "Oxygen Mono" => "Oxygen Mono",
            "PT Mono" => "PT Mono",
            "PT Sans" => "PT Sans",
            "PT Sans Caption" => "PT Sans Caption",
            "PT Sans Narrow" => "PT Sans Narrow",
            "PT Serif" => "PT Serif",
            "PT Serif Caption" => "PT Serif Caption",
            "Pacifico" => "Pacifico",
            "Paprika" => "Paprika",
            "Parisienne" => "Parisienne",
            "Passero One" => "Passero One",
            "Passion One" => "Passion One",
            "Pathway Gothic One" => "Pathway Gothic One",
            "Patrick Hand" => "Patrick Hand",
            "Patrick Hand SC" => "Patrick Hand SC",
            "Patua One" => "Patua One",
            "Paytone One" => "Paytone One",
            "Peralta" => "Peralta",
            "Permanent Marker" => "Permanent Marker",
            "Petit Formal Script" => "Petit Formal Script",
            "Petrona" => "Petrona",
            "Philosopher" => "Philosopher",
            "Piedra" => "Piedra",
            "Pinyon Script" => "Pinyon Script",
            "Pirata One" => "Pirata One",
            "Plaster" => "Plaster",
            "Play" => "Play",
            "Playball" => "Playball",
            "Playfair Display" => "Playfair Display",
            "Playfair Display SC" => "Playfair Display SC",
            "Podkova" => "Podkova",
            "Poiret One" => "Poiret One",
            "Poller One" => "Poller One",
            "Poly" => "Poly",
            "Pompiere" => "Pompiere",
            "Pontano Sans" => "Pontano Sans",
            "Port Lligat Sans" => "Port Lligat Sans",
            "Port Lligat Slab" => "Port Lligat Slab",
            "Prata" => "Prata",
            "Preahvihear" => "Preahvihear",
            "Press Start 2P" => "Press Start 2P",
            "Princess Sofia" => "Princess Sofia",
            "Prociono" => "Prociono",
            "Prosto One" => "Prosto One",
            "Puritan" => "Puritan",
            "Purple Purse" => "Purple Purse",
            "Quando" => "Quando",
            "Quantico" => "Quantico",
            "Quattrocento" => "Quattrocento",
            "Quattrocento Sans" => "Quattrocento Sans",
            "Questrial" => "Questrial",
            "Quicksand" => "Quicksand",
            "Quintessential" => "Quintessential",
            "Qwigley" => "Qwigley",
            "Racing Sans One" => "Racing Sans One",
            "Radley" => "Radley",
            "Raleway" => "Raleway",
            "Raleway Dots" => "Raleway Dots",
            "Rambla" => "Rambla",
            "Rammetto One" => "Rammetto One",
            "Ranchers" => "Ranchers",
            "Rancho" => "Rancho",
            "Rationale" => "Rationale",
            "Redressed" => "Redressed",
            "Reenie Beanie" => "Reenie Beanie",
            "Revalia" => "Revalia",
            "Ribeye" => "Ribeye",
            "Ribeye Marrow" => "Ribeye Marrow",
            "Righteous" => "Righteous",
            "Risque" => "Risque",
            "Roboto" => "Roboto",
            "Roboto Condensed" => "Roboto Condensed",
            "Roboto Slab" => "Roboto Slab",
            "Rochester" => "Rochester",
            "Rock Salt" => "Rock Salt",
            "Rokkitt" => "Rokkitt",
            "Romanesco" => "Romanesco",
            "Ropa Sans" => "Ropa Sans",
            "Rosario" => "Rosario",
            "Rosarivo" => "Rosarivo",
            "Rouge Script" => "Rouge Script",
            "Ruda" => "Ruda",
            "Rufina" => "Rufina",
            "Ruge Boogie" => "Ruge Boogie",
            "Ruluko" => "Ruluko",
            "Rum Raisin" => "Rum Raisin",
            "Ruslan Display" => "Ruslan Display",
            "Russo One" => "Russo One",
            "Ruthie" => "Ruthie",
            "Rye" => "Rye",
            "Sacramento" => "Sacramento",
            "Sail" => "Sail",
            "Salsa" => "Salsa",
            "Sanchez" => "Sanchez",
            "Sancreek" => "Sancreek",
            "Sansita One" => "Sansita One",
            "Sarina" => "Sarina",
            "Satisfy" => "Satisfy",
            "Scada" => "Scada",
            "Schoolbell" => "Schoolbell",
            "Seaweed Script" => "Seaweed Script",
            "Sevillana" => "Sevillana",
            "Seymour One" => "Seymour One",
            "Shadows Into Light" => "Shadows Into Light",
            "Shadows Into Light Two" => "Shadows Into Light Two",
            "Shanti" => "Shanti",
            "Share" => "Share",
            "Share Tech" => "Share Tech",
            "Share Tech Mono" => "Share Tech Mono",
            "Shojumaru" => "Shojumaru",
            "Short Stack" => "Short Stack",
            "Siemreap" => "Siemreap",
            "Sigmar One" => "Sigmar One",
            "Signika" => "Signika",
            "Signika Negative" => "Signika Negative",
            "Simonetta" => "Simonetta",
            "Sintony" => "Sintony",
            "Sirin Stencil" => "Sirin Stencil",
            "Six Caps" => "Six Caps",
            "Skranji" => "Skranji",
            "Slackey" => "Slackey",
            "Smokum" => "Smokum",
            "Smythe" => "Smythe",
            "Sniglet" => "Sniglet",
            "Snippet" => "Snippet",
            "Snowburst One" => "Snowburst One",
            "Sofadi One" => "Sofadi One",
            "Sofia" => "Sofia",
            "Sonsie One" => "Sonsie One",
            "Sorts Mill Goudy" => "Sorts Mill Goudy",
            "Source Code Pro" => "Source Code Pro",
            "Source Sans Pro" => "Source Sans Pro",
            "Special Elite" => "Special Elite",
            "Spicy Rice" => "Spicy Rice",
            "Spinnaker" => "Spinnaker",
            "Spirax" => "Spirax",
            "Squada One" => "Squada One",
            "Stalemate" => "Stalemate",
            "Stalinist One" => "Stalinist One",
            "Stardos Stencil" => "Stardos Stencil",
            "Stint Ultra Condensed" => "Stint Ultra Condensed",
            "Stint Ultra Expanded" => "Stint Ultra Expanded",
            "Stoke" => "Stoke",
            "Strait" => "Strait",
            "Sue Ellen Francisco" => "Sue Ellen Francisco",
            "Sunshiney" => "Sunshiney",
            "Supermercado One" => "Supermercado One",
            "Suwannaphum" => "Suwannaphum",
            "Swanky and Moo Moo" => "Swanky and Moo Moo",
            "Syncopate" => "Syncopate",
            "Tangerine" => "Tangerine",
            "Taprom" => "Taprom",
            "Tauri" => "Tauri",
            "Telex" => "Telex",
            "Tenor Sans" => "Tenor Sans",
            "Text Me One" => "Text Me One",
            "The Girl Next Door" => "The Girl Next Door",
            "Tienne" => "Tienne",
            "Tinos" => "Tinos",
            "Titan One" => "Titan One",
            "Titillium Web" => "Titillium Web",
            "Trade Winds" => "Trade Winds",
            "Trocchi" => "Trocchi",
            "Trochut" => "Trochut",
            "Trykker" => "Trykker",
            "Tulpen One" => "Tulpen One",
            "Ubuntu" => "Ubuntu",
            "Ubuntu Condensed" => "Ubuntu Condensed",
            "Ubuntu Mono" => "Ubuntu Mono",
            "Ultra" => "Ultra",
            "Uncial Antiqua" => "Uncial Antiqua",
            "Underdog" => "Underdog",
            "Unica One" => "Unica One",
            "UnifrakturCook" => "UnifrakturCook",
            "UnifrakturMaguntia" => "UnifrakturMaguntia",
            "Unkempt" => "Unkempt",
            "Unlock" => "Unlock",
            "Unna" => "Unna",
            "VT323" => "VT323",
            "Vampiro One" => "Vampiro One",
            "Varela" => "Varela",
            "Varela Round" => "Varela Round",
            "Vast Shadow" => "Vast Shadow",
            "Vibur" => "Vibur",
            "Vidaloka" => "Vidaloka",
            "Viga" => "Viga",
            "Voces" => "Voces",
            "Volkhov" => "Volkhov",
            "Vollkorn" => "Vollkorn",
            "Voltaire" => "Voltaire",
            "Waiting for the Sunrise" => "Waiting for the Sunrise",
            "Wallpoet" => "Wallpoet",
            "Walter Turncoat" => "Walter Turncoat",
            "Warnes" => "Warnes",
            "Wellfleet" => "Wellfleet",
            "Wendy One" => "Wendy One",
            "Wire One" => "Wire One",
            "Yanone Kaffeesatz" => "Yanone Kaffeesatz",
            "Yellowtail" => "Yellowtail",
            "Yeseva One" => "Yeseva One",
            "Yesteryear" => "Yesteryear",
            "Zeyada" => "Zeyada",
        );


/*-----------------------------------------------------------------------------------*/
/* The Options Array */
/*-----------------------------------------------------------------------------------*/

// Set the Options Array
global $of_options;
$of_options = array();

///////////////////////////////////////////////////////////////////////////////GENERAL	
$of_options[] = array( "name" => __('General', 'lioit'),
					"id" => "General",
					"icon"		=> ADMIN_IMAGES . "/icons/list.png",
					"type" => "heading");
				

					
$of_options[] = array( "name" => __("Custom Favicon", 'lioit'),
					"desc" => "",
				
					"id" => "Custom Favicon",

					"icon" => true,
					"std" => "",
					"type" => "info");	 
$url =  Lioit_URI . '/assets/images/';					
$of_options[] = array( "name" => __('Custom Favicon', 'lioit'),
					"desc" => __('Upload or past the URL for your custom favicon.', 'lioit'),
					"id" => "custom_favicon",
					"std" => $url . 'Lioit.png',
					"type" => "upload");
					
$of_options[] = array( "name" => __("Responsive Layout", 'lioit'),
					"desc" => "",
					"id" => "Responsive Layout",

					"icon" => true,
					"std" => true,
					"type" => "info");		
									
$of_options[] = array( "name" => __('Enable or Disable Responsive Layout', 'lioit'),
					"desc" => __('Select to enable/disable the responsive layout', 'lioit'),
					"id" => "responsive",
					"std" => true,
					"type" => "switch");
					

$of_options[] = array( "name" => __("Front End Submission", 'lioit'),
					"desc" => "",
					"id" => "Front End Submission",
					"icon" => true,
					"std" => "",
					"type" => "info");
					
$of_options[] = array( "name" => __('Allow users to publish posts', 'lioit'),
					"id" => "allow_users_to_publish_posts",
					"std" => true,
					"type" => "switch");					
					
$of_options[] = array( "name" => __("Additional Scripts", 'lioit'),
					"desc" => "",
					"id" => "Additional Scripts",

					"icon" => true,
					"std" => "",
					"type" => "info");						 
$of_options[] = array( "name" => __('Code (Header)', 'lioit'),
					"desc" => __('The following code will add to the <head> tag. Useful if you need to add additional scripts such as CSS or JS.', 'lioit'),
					"id" => "code_header",
					"std" => "",
					"type" => "textarea");
					
$of_options[] = array( "name" => __('Code (Footer)', 'lioit'),
					"desc" => __('The following code will add to the footer before the closing </body> tag. Useful if you need to Javascript or tracking code.', 'lioit'),
					"id" => "code_footer",
					"std" => "",
					"type" => "textarea");


///////////////////////////////////////////////////////////////////////////////STYLING
				
$of_options[] = array( "name" => __('Design', 'lioit'),
					"id" => "Styling",
					"icon"		=> ADMIN_IMAGES . "/icons/styling.png",
					"type" => "heading");
$of_options[] = array( "name" => __("Theme Skin", 'lioit'),
					"desc" => "",
					"id" => "Skin",
					"std" => "",
					"type" => "info");	 
					
$url =  ADMIN_DIR . 'assets/images/';																	
$of_options[] = array( "name" => __("Choose Your Theme Width", 'lioit'),
	
					"id" => "theme_width",
					"std" => "fullwidth",
					"type" => "images",
					"options" => array(
						'fullwidth' => $url . 'full.png',
						'fixedwithmargin' => $url . 'fixedwithmargin.png',
						'fixed' => $url . 'fixed.png'));	
						
							

						
									
$of_options[] = array( "name" => __("Style", 'lioit'),
					"desc" => "",
					"id" => "Style",
					"std" => "",
					"type" => "info");


$of_options[] = array( "name" => __('Accent Color', 'lioit'),
					"desc" => __('Change this color to alter the accent color globally for your site, try one of the amazing eight pre-picked colors.', 'lioit'),
					"id" => "accent_color",
					"std" => "",
					"type" => "color");
$of_options[] = array( "name" => __('General Background Color', 'lioit'),
					"desc" => __('If you do not want to use an image, you can choose a color, instead.  You want to leave this blank if you would rather have an image pattern as a background.', 'lioit'),
					"id" => "bg_color",
					"std" => "",
					"type" => "color");
					
					
$of_options[] = array( "name" => __('Boxed Content Background Color', 'lioit'),
					"desc" => __('If you select Boxed Skin choose Color for Boxed Content Background, you can choose a color. ', 'lioit'),
					"id" => "boxedbg_color",
					"std" => "",
					"type" => "color");
					
$of_options[] = array( "name" => __('Use Background Image', 'lioit'),
					"desc" => __('Use Background Image', 'lioit'),
					"id" => "use_bg_image",
					"std" => "",
					"folds"		=> 1,
					"type" => "switch");																	
$of_options[] = array( "name" => __("General Background Image", 'lioit'),
					"desc" => __('Select a background pattern. You can add your own by dropping the images into your images/bg in the theme folder', 'lioit'),
					"id" => "custom_bg",
					"std" => "",
					"fold" 		=> "use_bg_image", 
					"type" => "tiles",
					"options" => $bg_images,
);


$of_options[] = array( "name" => __('Custom Background Image', 'lioit'),
					"desc" => __('Upload your custom Background using the native media uploader, or define the URL directly', 'lioit'),
					"id" => "custom_bgimg",
					"std" => '',
					"fold" 		=> "use_bg_image", 
					"type" => "upload");
					
$of_options[] = array( "name" => __("Custom Background Repeat", 'lioit'),
					"desc" => __('Select a background Repeat postion. ', 'lioit'),
					"id" => "custom_bgimgrepeat",
					"std" => "no-repeat",
					"type" => "select",
					"fold" 		=> "use_bg_image", 
					"options" => $body_repeat,
);

$of_options[] = array( "name" => __("Custom Background attachment", 'lioit'),
					"desc" => __('Select a background attachment. ', 'lioit'),
					"id" => "custom_bgimgattachment",
					"std" => "fixed",
					"type" => "select",
					"fold" 		=> "use_bg_image", 
					"options" => $body_attachment,
);
$of_options[] = array( "name" => __("Custom Background position", 'lioit'),
					"desc" => __('Select a background position. ', 'lioit'),
					"id" => "custom_bgimgpos",
					"std" => "center center",
					"type" => "select",
					"fold" 		=> "use_bg_image", 
					"options" => $body_pos,
);

				




$of_options[] = array( "name" => __("Top Navigation", 'lioit'),
					"desc" => "",
					"id" => "Top Navigation",
					"std" => "",
					"type" => "info");
$of_options[] = array( "name" => __('Top Navigation Background Color', 'lioit'),
					"desc" => __('Top Navigation Background Color', 'lioit'),
					"id" => "tobbar_color",
					"std" => "",
					"type" => "color");



$of_options[] = array( "name" => __("Header", 'lioit'),
					"desc" => "",
					"id" => "Header",
					"std" => "",
					"type" => "info");					
$of_options[] = array( "name" => __('Header Background Color', 'lioit'),
					"desc" => __('Header Background Color', 'lioit'),
					"id" => "header_color",
					"std" => "",
					"type" => "color");

$of_options[] = array( "name" => __("Typography", 'lioit'),
					"desc" => "",
					"id" => "Typography",
					"std" => "",
					"type" => "info");
      
$of_options[] = array( "name" => __("Custom Body Font", 'lioit'),
                        "desc" => __('Choose Body Font.', 'lioit'),
						"id" 		=> "body_google_font",
						"std" 		=> "Select a font",
						"type" 		=> "select_google_font",
						"preview" 	=> array(
										"text" => "This is my preview text!", 
										"size" => "15px" 
						),
						"options" => $google_fonts);
				
$of_options[] = array( "name" => __("Custom Heading Font", 'lioit'),
                        "desc" => __('Choose Heading , Titles Font.', 'lioit'),
						"id" 		=> "head_google_font",
						"std" 		=> "Select a font",
						"type" 		=> "select_google_font",
						"preview" 	=> array(
										"text" => "This is my preview text!", 
										"size" => "18px"
						),
						"options" => $google_fonts);



	
					

$of_options[] = array( "name" => __("Custom", 'lioit'),
					"desc" => "",
					"id" => "Custom",
					"std" => "",
					"type" => "info");		
$of_options[] = array( "name" => __('Custom CSS', 'lioit'),
                    "desc" => __('Quickly add some CSS to your theme by adding it to this block.', 'lioit'),
                    "id" => "custom_css",
                    "std" => "",
                    "type" => "textarea");  

		

					
					
///////////////////////////////////////////////////////////////////////////////GENERAL	
$of_options[] = array( "name" => __('Header & Footer', 'lioit'),
					"id" => "Header",
					"icon"		=> ADMIN_IMAGES . "/icons/list.png",
					"type" => "heading");


$of_options[] = array( "name" => __("Top Area", 'lioit'),
					"desc" => "",
					"id" => "Top Area",
					"std" => "",
					"type" => "info");	

$url =  ADMIN_DIR . 'assets/images/footer/';
$of_options[] = array( "name" => __("Choose Your Top Area Widgets Layout", 'lioit'),
	
					"id" => "topwidgets_layout",
					"std" => "topwidgets-1",
					"type" => "images",
					"options" => array(
						'topwidgets-1' => $url . 'footer-1.png',
						'topwidgets-2' => $url . 'footer-2.png',
						'topwidgets-3' => $url . 'footer-3.png',
						'topwidgets-4' => $url . 'footer-4.png',
						'topwidgets-5' => $url . 'footer-5.png',
						'topwidgets-6' => $url . 'footer-6.png',
						'topwidgets-7' => $url . 'footer-7.png',
						'topwidgets-8' => $url . 'footer-8.png',
						));		
						
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("Top Bar", 'lioit'),
					"desc" => "",
					"id" => "Top Bar",
					"std" => "",
					"type" => "info");							
$of_options[] = array( "name" => __('Enable or Disable Top Bar', 'lioit'),
					"desc" => __('On or Off Top Bar', 'lioit'),
					"id" => "top_navigation",
					"std" => true,
					"type" => "switch");
$of_options[] = array( "name" => __("Header Style", 'lioit'),
					"desc" => "",
					"id" => "Header Style",
					"std" => "",
					"type" => "info");																	
$of_options[] = array( "name" => __("Choose Header Style", 'lioit'),
	
					"id" => "header_style",
					"std" => "header_style1",
					"type" => "images",
					"options" => array(
						'header_style1' => $url . 'header1.png',
						'header_style2' => $url . 'header2.png',
						'header_style3' => $url . 'header3.png'));	
						
$of_options[] = array( "name" => __("Main Logo Upload", 'lioit'),
					"desc" => "",
					
					"id" => "Main Logo Upload",

					"icon" => true,
					"std" => "",
					"type" => "info");	 
$url =  Lioit_URI . '/images/';							
$of_options[] = array( "name" => __('Custom Logo Image', 'lioit'),
					"desc" => __('Upload your custom logo using the native media uploader, or define the URL directly', 'lioit'),
					"id" => "custom_logo",
					"std" => $url . 'logo.png',
					"type" => "upload");
$of_options[] = array( "name" => __('Logo Margin Top', 'lioit'),
					"desc" => __('Set the distance between the wall of the header and your logo.', 'lioit'),
					"id" => "margin_logo",
					"std" => "0",
					"step" => "1",
					"min" => "0",
					"max" => "30",
					
					"type" => "sliderui",
					);


$of_options[] = array( "name" => __("Header Weather", 'lioit'),
					"desc" => "",
					"id" => "Header Weather",
					"std" => "",
					"type" => "info");
			
$of_options[] = array( "name" => __('City to pull weather information for','lioit'),
					"desc" => __('Egypt, New York, Australia, etc.','lioit'),
					"id" => "weather_city",
					"std" => "Egypt",
					"type" => "text");
					
$of_options[] = array( "name" => __('City to pull weather information for','lioit'),
					"desc" => __('Use Metric or Imperial system?','lioit'),
					"id" => "weather_units",
					"std" 		=> "two",
					"type" 		=> "select",
					"options" 	=> $weather_units
				); 
				
				
				
$of_options[] = array( "name" => __("Main Navigation", 'lioit'),
					"desc" => "",
					"id" => "Main Navigation",
					"icon" => true,
					"std" => "",
					"type" => "info");	
													
$of_options[] = array( 	"name" 		=> "Default Categories Menu",
						"id" 		=> "default_categories_menu",
						"std" 		=> "classic_menu",
						"type" 		=> "select",
						"options" 	=> array(
									
										"mega_menu" => "Mega Menu",
										"classic_menu" => "Classic Menu",
										"classic_menu_colored" => "Classic Menu 'Colored'",
						)
				);
						
														
$of_options[] = array( "name" => __("News Ticker", 'lioit'),
					"desc" => "",
					"id" => "News Ticker",

					"icon" => true,
					"std" => "",
					"type" => "info");	
$of_options[] = array( "name" => __('Enable or Disable News Ticker', 'lioit'),
					"desc" => __('On or Off News Ticker', 'lioit'),
					"id" => "newsticker",
					"std" => true,
          			"folds" => 1,
					"type" => "switch");
					
					
$of_options[] = array( "name" => __("News Ticker Category", 'lioit'),
					"desc" => __("Select Category for News Ticker", 'lioit'),
					"id" => "newsticker_cat",
					"std" => "",
					"type" => "select",
					"fold" => "newsticker",
					"options" => $of_categories);
$of_options[] = array( "name" => __(' News Ticker Posts', 'lioit'),
					"desc" => __('How many News Ticker Posts do you want to show on the homepage.', 'lioit'),
					"id" => "newsticker_count",
					"std" => "4",
					"step" => "1",
					"min" => "1",
					"max" => "20",
					"fold" => "newsticker",
					"type" => "sliderui",
					);
										
$of_options[] = array( "name" => __("Custom Search", 'lioit'),
					"desc" => "",
					"id" => "Custom Search",

					"icon" => true,
					"std" => "",
					"type" => "info");
						
$of_options[] = array( "name" => __('Enable or Disable Custom Search', 'lioit'),
					"desc" => __('On or Off Search in cats', 'lioit'),
					"id" => "customsearch",
					"std" => true,
					"type" => "switch");

$of_options[] = array( "name" => __("Notification Box", 'lioit'),
					"desc" => "",
					"id" => "Notification Box",

					"icon" => true,
					"std" => 0,
					"type" => "info");					
$of_options[] = array( "name" => __('Enable or Disable Notification Box', 'lioit'),
					"desc" => __('On or Off  to enable/disable the Notification Box', 'lioit'),
					"id" => "disable_top_bar",
					"std" => false,
					"type" => "switch");
					
					
$of_options[] = array( "name" => __('Notification Text','lioit'),
					"desc" => __('Add a drop down notification bar at top of main page.','lioit'),
					"id" => "note",
					"std" => "Check out this cool (optional) notification bar, nice hey?",
					"type" => "text");
					$of_options[] = array( "name" => __('Notification Link Text','lioit'),
					"desc" => __('if you want add link in notification type text here and link below','lioit'),
					"id" => "note_text",
					"std" => "Click Here",
					"type" => "text");
					$of_options[] = array( "name" => __('Notification Link Url','lioit'),
					"desc" => __('add url as you want here','lioit'),
					"id" => "note_url",
					"std" => "http://bit.ly/Vx1YSI",
					"type" => "text");

					
					
					


	


$url =  ADMIN_DIR . 'assets/images/footer/';
$of_options[] = array( "name" => __("Choose Your Footer Layout", 'lioit'),
	
					"id" => "footer_layout",
					"std" => "footer-1",
					"type" => "images",
					"options" => array(
						'footer-1' => $url . 'footer-1.png',
						'footer-2' => $url . 'footer-2.png',
						'footer-3' => $url . 'footer-3.png',
						'footer-4' => $url . 'footer-4.png',
						'footer-5' => $url . 'footer-5.png',
						'footer-6' => $url . 'footer-6.png',
						'footer-7' => $url . 'footer-7.png',
						'footer-8' => $url . 'footer-8.png',
						));		
			
$of_options[] = array( "name" => __("Custom Copyrights", 'lioit'),
					"desc" => "",
					"id" => "Copyrights",
					"std" => "",
					"type" => "info");						
$of_options[] = array( "name" => __('Custom Copyright', 'lioit'),
                    "desc" => __('Add your own custom text/html for copyright region.', 'lioit'),
                    "id" => "footercopyrights",
                    "std" => __("Some Text Here &copy; Copyright 2012. Powered by WordPress.", 'lioit'),
                    "type" => "textarea");

					
					
					
							
///////////////////////////////////////////////////////////////////////////////BLOG
					
$of_options[] = array( "name" => __('Blog', 'lioit'),
					"id" => "Post Elements",
					"icon"		=> ADMIN_IMAGES . "/icons/note.png",
					"type" => "heading");
					
$of_options[] = array( "name" => __("Post Elements", 'lioit'),
					"desc" => "",
					"id" => "post_elements",
					"icon" => true,
					"std" => "",
					"type" => "info");	



$of_options[] = array( "name" => __('Show Banner Into Post ', 'lioit'),
					"id" => "banner_box",
					"std" => true,
					"type" => "switch");
					
										
$of_options[] = array( "name" => __('Show Review Box Into Post ', 'lioit'),
					"id" => "review_box",
					"std" => true,
					"type" => "switch");
					
					
$of_options[] = array( "name" => __('Show Share Buttons ', 'lioit'),
					"id" => "show_postsocial",
					"std" => true,
					"type" => "switch");
					
$of_options[] = array( "name" => __('Show Feature Image Into Post ', 'lioit'),
					"id" => "feature_image",
					"std" => true,
					"type" => "switch");
					
$of_options[] = array( "name" => __('Show Next/Prev Post  ', 'lioit'),
					"id" => "show_postnav",
					"std" => true,
					"type" => "switch");
					
$of_options[] = array( "name" => __('Show Related Posts ', 'lioit'),
					"id" => "show_related",
					"std" => true,
					"type" => "switch");
					
$of_options[] = array( "name" => __('Show Author Info Box ', 'lioit'),
					"id" => "show_authorinfo",
					"std" => true,
					"type" => "switch");

$of_options[] = array( "name" => __("Post Meta", 'lioit'),
					"id" => "post_meta",
					"std" => "",
					"type" => "info");	
					
									
$of_options[] = array( "name" => __('Post Meta ', 'lioit'),
					"id" => "show_postmeta",
					"std" => true,
					"type" => "switch");
					
$of_options[] = array( "name" => __('Author Meta', 'lioit'),
					"id" => "show_postauthor",
					"std" => true,
					"type" => "switch");
					
					
$of_options[] = array( "name" => __('Date Meta', 'lioit'),
					"id" => "show_postdate",
					"std" => true,
					"type" => "switch");
					
					
$of_options[] = array( "name" => __('Category Meta ', 'lioit'),
					"id" => "show_postcat",
					"std" => true,
					"type" => "switch");
					
$of_options[] = array( "name" => __('Comments Meta ', 'lioit'),
					"id" => "show_postcomm",
					"std" => true,
					"type" => "switch");
					
$of_options[] = array( "name" => __('Tags Meta ', 'lioit'),
					"id" => "show_posttags",
					"std" => true,
					"type" => "switch");
					
					
$of_options[] = array( "name" => __('Views Meta ', 'lioit'),
					"id" => "show_viewsmeta",
					"std" => true,
					"type" => "switch");


					
					
					
					
					
					
					
					
					
				

									
///////////////////////////////////////////////////////////////////////////////HOME LAYOUT MANAGER

$of_options[] = array( "name" => __('Home', 'lioit'),
					"id" => "Home",
					"icon"		=> ADMIN_IMAGES . "/icons/home.png",
                    "type" => "heading");
$of_options[] = array( "name" => __("Home Slider", 'lioit'),
					"desc" => "",
					"id" => "Home Layout",
					"std" => "",
					"type" => "info");	
	
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("Choose Home Slider", 'lioit'),
	
					"id" => "home_slider",
					"std" => "homeslider1",
					"type" => "images",
					"options" => array(
						'homeslider1' => $url . 'slider1.png',
						'homeslider2' => $url . 'slider2.png',
						'homeslider3' => $url . 'slider3.png',
						'homeslider4' => $url . 'slider4.png',
						'homeslider5' => $url . 'slider5.png',
						'slidernone' => $url . 'slidernone.png',
						));
						
						
						
$of_options[] = array( "name" => __("Home Layout", 'lioit'),
					"desc" => "",
					"id" => "Home Layout",
					"std" => "",
					"type" => "info");	
	
$url =  ADMIN_DIR . 'assets/images/homestyle/';
$of_options[] = array( "name" => __("Choose Home Style", 'lioit'),
	
					"id" => "home_style",
					"std" => "style3",
					"type" => "images",
					"options" => array(
						'style1' => $url . 'style1.png',
						'style2' => $url . 'style2.png',
						'style3' => $url . 'style3.png',
						'style4' => $url . 'style4.png',
						'style5' => $url . 'style5.png',
						'style6' => $url . 'style6.png',
						'style7' => $url . 'style7.png',
						'style8' => $url . 'style8.png',
						));
	
	
					

				  	
 $of_options[] = array( "name" => __("Homepage Layout Manager", 'lioit'),
					"desc" => "",
					"id" => "Layout Manager",

					"std" => "",
					"type" => "info");	 			
$of_options[] = array( 
					"desc" => __('Organize how you want the layout to appear on the homepage.', 'lioit'),
					"id" => "homepage_blocks",

					"std" => $of_options_homepage_blocks,
					"type" => "sorter");
					
					
					
$of_options[] = array( "name" => __("Big News Boxs", 'lioit'),
					"desc" => "",
					"id" => "news_boxs_title",
					"std" => "",
					"type" => "info");	

$of_options[] = array( 
					"desc" => __("Big News Boxs Nubmer to show", 'lioit'),
					"id" => "bigboxs_blocks",
					"std" => $of_options_bigboxs_blocks,
					"type" => "sorter");
					
					
					
					

$of_options[] = array( "name" => __("Small News Boxs", 'lioit'),
					"desc" => "",
					"id" => "news_boxs_title",
					"std" => "",
					"type" => "info");	
					

$of_options[] = array( 
					"desc" => __("Small News Boxs Nubmer to show", 'lioit'),
					"id" => "smallboxs_blocks",
					"std" => $of_options_smallboxs_blocks,
					"type" => "sorter");
					
					
$of_options[] = array( "name" => __("Latest Posts", 'lioit'),
					"desc" => "",
					"id" => "Latest Posts",
					"std" => "",
					"type" => "info");		
					
					
$of_options[] = array( "name" => __('How Many Latest Posts', 'lioit'),
					"desc" => __('How many Latest Posts do you want to show on the homepage.', 'lioit'),
					"id" => "latestcount",
					"std" => "9",
					"step" => "1",
					"min" => "1",
					"max" => "20",
					
					"type" => "sliderui",
					);
					
					
					
$of_options[] = array( "name" => __("Home Galleries", 'lioit'),
					"desc" => "",
					"id" => "Home Galleries",
					"std" => "",
					"type" => "info");		
					
					
$of_options[] = array( "name" => __('How Many Home Galleries', 'lioit'),
					"desc" => __('How many Home Galleries do you want to show on the homepage.', 'lioit'),
					"id" => "home_gallery_count",
					"std" => "4",
					"step" => "1",
					"min" => "1",
					"max" => "20",
					
					"type" => "sliderui",
					);

$of_options[] = array( "name" => __("Home Posts in Images", 'lioit'),
					"desc" => "",
					"id" => "Home Images",
					"std" => "",
					"type" => "info");					
				
	$of_options[] = array( "name" => __("Posts in Images Category", 'lioit'),
					"desc" => __("Select Category for Posts in Images", 'lioit'),
					"id" => "homeimages_cat",
					"std" => "",
					"type" => "select",
					"fold" => "newsticker",
					"options" => $of_categories);
$of_options[] = array( "name" => __(' Posts in Images Posts', 'lioit'),
					"desc" => __('How many Posts in Images items do you want to show on the homepage.', 'lioit'),
					"id" => "homeimages_count",
					"std" => "4",
					"step" => "1",
					"min" => "1",
					"max" => "20",
					"type" => "sliderui",
					);			
				
				
$of_options[] = array( "name" => __("Carousel Slider", 'lioit'),
					"desc" => "",
					"id" => "Carousel Slider",
					"std" => "",
					"type" => "info");		
					
$of_options[] = array( "name" => __('Carousel Posts Title', 'lioit'),
					"desc" => __('Type Title .', 'lioit'),
					"id" => "carotitle",
					"std" => __("Highlights", 'lioit'),
					"type" => "text",
					);
							
$of_options[] = array( "name" => __('Carousel Category', 'lioit'),
					"desc" => __('Select to show posts in Carousel Posts.', 'lioit'),
					"id" => "cat_carouselposts",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
$of_options[] = array( "name" => __('How Many Carousel Posts', 'lioit'),
					"desc" => __('How many Carousel items do you want to show on the homepage.', 'lioit'),
					"id" => "carocount",
					"std" => "6",
					"step" => "1",
					"min" => "1",
					"max" => "60",
					
					"type" => "sliderui",
					);
					
					
	

		
		                        		
/////////////////////////////////////////////////////////////////////////Big News Boxs

$of_options[] = array( "name" => __('Big Boxs', 'lioit'),
					"id" => "Big Boxs",
					"icon"		=> ADMIN_IMAGES . "/icons/thumblnail.png",
					"type" => "heading");


	

				
$of_options[] = array( "name" => __('Box 1 Color', 'lioit'),
					
					"id" => "one_color",
					"std" => "",
					"type" => "color");
					
							
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 1 Layout", 'lioit'),
					
					"id" => "one_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
						
$of_options[] = array( "name" => __("News Box 1 Category", 'lioit'),
					
					"id" => "bigbox_one",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
	
					
$of_options[] = array( "name" => __('Box 2 Color', 'lioit'),
					
					"id" => "tow_color",
					"std" => "",
					"type" => "color");
					
						 				
					$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 2 Layout", 'lioit'),
					
					"id" => "tow_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
						
$of_options[] = array( "name" => __("News Box 2 Category", 'lioit'),
					
					"id" => "bigbox_tow",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
					

$of_options[] = array( "name" => __('Box 3 Color', 'lioit'),
					
					"id" => "three_color",
					"std" => "",
					"type" => "color");
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 3 Layout", 'lioit'),
					
					"id" => "three_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
						
$of_options[] = array( "name" => __("News Box 3 Category", 'lioit'),
					
					"id" => "bigbox_three",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
				
				

$of_options[] = array( "name" => __('Box 4 Color', 'lioit'),
					
					"id" => "four_color",
					"std" => "",
					"type" => "color");	 	
					$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 4 Layout", 'lioit'),
					
					"id" => "four_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
$of_options[] = array( "name" => __("News Box 4 Category", 'lioit'),
					
					"id" => "bigbox_four",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);

$of_options[] = array( "name" => __('Box 5 Color', 'lioit'),
					
					"id" => "five_color",
					"std" => "",
					"type" => "color"); 
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 5 Layout", 'lioit'),
					
					"id" => "five_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
$of_options[] = array( "name" => __("News Box 5 Category", 'lioit'),
					
					"id" => "bigbox_five",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
	 
$of_options[] = array( "name" => __('Box 6 Color', 'lioit'),
					
					"id" => "six_color",
					"std" => "",
					"type" => "color");
					$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 6 Layout", 'lioit'),
					
					"id" => "six_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
$of_options[] = array( "name" => __("News Box 6 Category", 'lioit'),
					
					"id" => "bigbox_six",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
	
$of_options[] = array( "name" => __('Box 7 Color', 'lioit'),
					
					"id" => "seven_color",
					"std" => "",
					"type" => "color");	 
					$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 7 Layout", 'lioit'),
					
					"id" => "seven_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
$of_options[] = array( "name" => __("News Box 7 Category", 'lioit'),
					
					"id" => "bigbox_seven",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
 
$of_options[] = array( "name" => __('Box 8 Color', 'lioit'),
					
					"id" => "eight_color",
					"std" => "",
					"type" => "color");
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 8 Layout", 'lioit'),
					
					"id" => "eight_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
$of_options[] = array( "name" => __("News Box 8 Category", 'lioit'),
					
					"id" => "bigbox_eight",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					

$of_options[] = array( "name" => __('Box 9 Color', 'lioit'),
					
					"id" => "nine_color",
					"std" => "",
					"type" => "color");	 
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 9 Layout", 'lioit'),
					
					"id" => "nine_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
$of_options[] = array( "name" => __("News Box 9 Category", 'lioit'),
					
					"id" => "bigbox_nine",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					

$of_options[] = array( "name" => __('Box 10 Color', 'lioit'),
					
					"id" => "ten_color",
					"std" => "",
					"type" => "color"); 
$url =  ADMIN_DIR . 'assets/images/';
$of_options[] = array( "name" => __("News Box 10 Layout", 'lioit'),
					
					"id" => "ten_layout",
					"std" => "bigboxs1",
					"type" => "images",
					"options" => array(
						'bigboxs1' => $url . 'bigboxs1.png',
						'bigboxs2' => $url . 'bigboxs2.png'));
$of_options[] = array( "name" => __("News Box 10 Category", 'lioit'),
					
					"id" => "bigbox_ten",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
					
					
									
/////////////////////////////////////////////////////////////////////////Small News Boxs

$of_options[] = array( "name" => __('Small Boxs', 'lioit'),
					"id" => "Small Boxs",
					"icon"		=> ADMIN_IMAGES . "/icons/grid.png",
					"type" => "heading");

					
	 
$of_options[] = array( "name" => __('Box 1 Color', 'lioit'),
					
					"id" => "one_scolor",
					"std" => "",
					"type" => "color");					
$of_options[] = array( "name" => __("News Box 1 Category", 'lioit'),
					
					"id" => "smallbox_one",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					

					$of_options[] = array( "name" => __('Box2 Color', 'lioit'),
					
					"id" => "tow_scolor",
					"std" => "",
					"type" => "color");				
$of_options[] = array( "name" => __("News Box 2 Category", 'lioit'),
					
					"id" => "smallbox_tow",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					

$of_options[] = array( "name" => __('Box 3 Color', 'lioit'),
					
					"id" => "three_scolor",
					"std" => "",
					"type" => "color");				
$of_options[] = array( "name" => __("News Box 3 Category", 'lioit'),
					
					"id" => "smallbox_three",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);

	$of_options[] = array( "name" => __('Box 4 Color', 'lioit'),
					
					"id" => "four_scolor",
					"std" => "",
					"type" => "color");			
$of_options[] = array( "name" => __("News Box 4 Category", 'lioit'),
					
					"id" => "smallbox_four",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
	
					$of_options[] = array( "name" => __('Box 5 Color', 'lioit'),
					
					"id" => "five_scolor",
					"std" => "",
					"type" => "color");	
$of_options[] = array( "name" => __("News Box 5 Category", 'lioit'),
					
					"id" => "smallbox_five",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
	
$of_options[] = array( "name" => __('Box 6 Color', 'lioit'),
					
					"id" => "six_scolor",
					"std" => "",
					"type" => "color");				
$of_options[] = array( "name" => __("News Box 6 Category", 'lioit'),
					
					"id" => "smallbox_six",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
			
					$of_options[] = array( "name" => __('Box 7 Color', 'lioit'),
					
					"id" => "seven_scolor",
					"std" => "",
					"type" => "color");	
$of_options[] = array( "name" => __("News Box 7 Category", 'lioit'),
					
					"id" => "smallbox_seven",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
	
$of_options[] = array( "name" => __('Box 8 Color', 'lioit'),
					
					"id" => "eight_scolor",
					"std" => "",
					"type" => "color");			
$of_options[] = array( "name" => __("News Box 8 Category", 'lioit'),
					
					"id" => "smallbox_eight",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
	
$of_options[] = array( "name" => __('Box 9 Color', 'lioit'),
					
					"id" => "nine_scolor",
					"std" => "",
					"type" => "color");			
$of_options[] = array( "name" => __("News Box 9 Category", 'lioit'),
					
					"id" => "smallbox_nine",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					

$of_options[] = array( "name" => __('Box 10 Color', 'lioit'),
					
					"id" => "ten_scolor",
					"std" => "",
					"type" => "color");			
$of_options[] = array( "name" => __("News Box 10 Category", 'lioit'),
					
					"id" => "smallbox_ten",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
					




					


					
					

                    
                    
/////////////////////////////////////////////////////////////////////////FEATURED TABS


$of_options[] = array( "name" => __('News In Tabs', 'lioit'),
					"id" => "News In Tabs",
					"icon"		=> ADMIN_IMAGES . "/icons/tabs.png",
					"type" => "heading");
		
$of_options[] = array( "name" => __("Tab 1", 'lioit'),
					"desc" => "",
					"id" => "Tab 1",
					"std" => "",
					"type" => "info");
$of_options[] = array( "name" => __('Show Tab', 'lioit'),
					"desc" => __('On or Off Tab ', 'lioit'),
					"id" => "tab1_show",
					"std" => "",
					"type" => "switch");	
$of_options[] = array( "name" => __('Tab Title', 'lioit'),
                    "desc" => __('type Title here.', 'lioit'),
                    "id" => "tab1_title",
                    "std" => "Tab 1",
                    "type" => "text");
		
$of_options[] = array( "name" => __('Tab Category', 'lioit'),
					"desc" => __('Select to show posts in Tab.', 'lioit'),
					"id" => "tab1_category",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
					
$of_options[] = array( "name" => __("Tab 2", 'lioit'),
					"desc" => "",
					"id" => "Tab 2",
					"std" => "",
					"type" => "info");
$of_options[] = array( "name" => __('Show Tab', 'lioit'),
					"desc" => __('On or Off Tab ', 'lioit'),
					"id" => "tab2_show",
					"std" => true,
					"type" => "switch");	
$of_options[] = array( "name" => __('Tab Title', 'lioit'),
                    "desc" => __('type Title here.', 'lioit'),
                    "id" => "tab2_title",
                    "std" => "Tab 2",
                    "type" => "text");
					
$of_options[] = array( "name" => __('Tab Category', 'lioit'),
					"desc" => __('Select to show posts in Tab.', 'lioit'),
					"id" => "tab2_category",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
				
$of_options[] = array( "name" => __("Tab 3", 'lioit'),
					"desc" => "",
					"id" => "Tab 3",
					"std" => "",
					"type" => "info");
$of_options[] = array( "name" => __('Show Tab', 'lioit'),
					"desc" => __('On or Off Tab ', 'lioit'),
					"id" => "tab3_show",
					"std" => true,
					"type" => "switch");		
					
$of_options[] = array( "name" => __('Tab Title', 'lioit'),
                    "desc" => __('type Title here.', 'lioit'),
                    "id" => "tab3_title",
                    "std" => "Tab 3",
                    "type" => "text");
$of_options[] = array( "name" => __('Tab Category', 'lioit'),
					"desc" => __('Select to show posts in Tab.', 'lioit'),
					"id" => "tab3_category",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
					
					
$of_options[] = array( "name" => __("Tab 4", 'lioit'),
					"desc" => "",
					"id" => "Tab 4",
					"std" => "",
					"type" => "info");	
$of_options[] = array( "name" => __('Show Tab', 'lioit'),
					"desc" => __('On or Off Tab ', 'lioit'),
					"id" => "tab4_show",
					"std" => true,
					"type" => "switch");	
$of_options[] = array( "name" => __('Tab Title', 'lioit'),
                    "desc" => __('type Title here.', 'lioit'),
                    "id" => "tab4_title",
                    "std" => "Tab 4",
                    "type" => "text");
$of_options[] = array( "name" => __('Tab Category', 'lioit'),
					"desc" => __('Select to show posts in Tab.', 'lioit'),
					"id" => "tab4_category",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
				
				
$of_options[] = array( "name" => __("Tab 5", 'lioit'),
					"desc" => "",
					"id" => "Tab 5",
					"std" => "",
					"type" => "info");	
$of_options[] = array( "name" => __('Show Tab', 'lioit'),
					"desc" => __('On or Off Tab ', 'lioit'),
					"id" => "tab5_show",
					"std" => true,
					"type" => "switch");	
$of_options[] = array( "name" => __('Tab Title', 'lioit'),
                    "desc" => __('type Title here.', 'lioit'),
                    "id" => "tab5_title",
                    "std" => "Tab 5",
                    "type" => "text");
$of_options[] = array( "name" => __('Tab Category', 'lioit'),
					"desc" => __('Select to show posts in Tab.', 'lioit'),
					"id" => "tab5_category",
					"std" => "",
					"type" => "select",
					"options" => $of_categories);
				
					

					


					
					

                    
                    
              
	

/////////////////////////////////////////////////////////////////////////MARKETING                    

$of_options[] = array( "name" => __('Banners', 'lioit'),
					"id" => "Banners",
					"icon"		=> ADMIN_IMAGES . "/icons/ads.png",
					"type" => "heading");

$of_options[] = array( "name" => __("Top Banner", 'lioit'),
					"desc" => "",
					"id" => "Banners",
					"std" => "",
					"type" => "info");		

$of_options[] = array( "name" => __('Enable or Disable Banner', 'lioit'),
					"desc" => __('Select to enable/disable the Banner', 'lioit'),
					"id" => "show_top_banner",
					"std" => true,
					"type" => "switch");                    
$url =  Lioit_URI . '/images/';		
$of_options[] = array( "name" => __('Banner Img', 'lioit'),
					"desc" => __('Upload or past the URL for your Images', 'lioit'),
					"id" => "top_banner_img",
					"std" => $url . 'headbanner.png',
					"type" => "upload");
                    
$of_options[] = array( "name" => __('Banner Link', 'lioit'),
                    "desc" => __('Add a Link Banner', 'lioit'),
                    "id" => "top_banner_url",
                    "std" => "http://www.lioit.com",
                    "type" => "text");
$of_options[] = array( "name" => __('Alternative Text', 'lioit'),
                    "desc" => __('Add a Title Banner', 'lioit'),
                    "id" => "top_banner_alt",
                    "std" => "http://www.lioit.com",
                    "type" => "text");


$of_options[] = array( "name" => __('Ads Code', 'lioit'),
                    "desc" => __('Add Ads Code', 'lioit'),
                    "id" => "top_banner_code",
                    "std" => "",
                    "type" => "textarea");
									
$of_options[] = array( "name" => __("Bottom Banner ", 'lioit'),
					"desc" => "",
					"id" => "Banners",
					"std" => "",
					"type" => "info");		

$of_options[] = array( "name" => __('Enable or Disable Banner', 'lioit'),
					"desc" => __('Select to enable/disable the Banner', 'lioit'),
					"id" => "show_btm_banner",
					"std" => false,
					"type" => "switch");                    
$url =  Lioit_URI . '/images/';		
$of_options[] = array( "name" => __('Banner Img', 'lioit'),
					"desc" => __('Upload or past the URL for your Images', 'lioit'),
					"id" => "btm_banner_img",
					"std" => $url . 'headbanner.png',
					"type" => "upload");
                    
$of_options[] = array( "name" => __('Banner Link', 'lioit'),
                    "desc" => __('Add a Link Banner', 'lioit'),
                    "id" => "btm_banner_url",
                    "std" => "http://www.lioit.com",
                    "type" => "text");
$of_options[] = array( "name" => __('Alternative Text', 'lioit'),
                    "desc" => __('Add a Title Banner', 'lioit'),
                    "id" => "btm_banner_alt",
                    "std" => "http://www.lioit.com",
                    "type" => "text");
					
$of_options[] = array( "name" => __('Ads Code', 'lioit'),
                    "desc" => __('Add Ads Code', 'lioit'),
                    "id" => "btm_banner_code",
                    "std" => "",
                    "type" => "textarea");
                    
                    
                    
/////////////////////////////////////////////////////////////////////////SOCIAL

$of_options[] = array( "name" => __('Social', 'lioit'),
					"id" => "Social",
					"icon"		=> ADMIN_IMAGES . "/icons/globe.png",
					"type" => "heading");


					
$of_options[] = array( "name" => __("Enable or Disable Social icons", 'lioit'),
					"desc" => "",
					"id" => "Enable or Disable Social icons",
					"icon" => true,
					"std" => "",
					"type" => "info");	
$of_options[] = array( "name" => __('Social icons in Header', 'lioit'),
					"desc" => __('On or Off Social icons in Header ', 'lioit'),
					"id" => "social_header",
					"std" => "",
					"type" => "switch");
$of_options[] = array( "name" => __('Social icons in Footer', 'lioit'),
					"desc" => __('On or Off Social icons in Footer ', 'lioit'),
					"id" => "social_footer",
					"std" => "",
					"type" => "switch");

$of_options[] = array( "name" => __("Social Icons", 'lioit'),
					"desc" => "",
					"id" => "Social Icons",
					"std" => "",
					"type" => "info");
																
$of_options[] = array( "name" => __('Twitter', 'lioit'),
                    "desc" => __('Add your twitter url.', 'lioit'),
                    "id" => "twitter",
                    "std" => "http://twitter.com/#!/lioit",
                    "type" => "text");
					
$of_options[] = array( "name" => __('Dribbble', 'lioit'),
                    "desc" => __('Add your dribbble url.', 'lioit'),
                    "id" => "dribbble",
                    "std" => "http://dribbble.com/lioit",
                    "type" => "text");

$of_options[] = array( "name" => __('Website', 'lioit'),
                    "desc" => __('Add your Website url.', 'lioit'),
                    "id" => "wordpress",
                    "std" => "https://lioit.com",
                    "type" => "text");

$of_options[] = array( "name" => __('skype', 'lioit'),
                    "desc" => __('Add your skype nme.', 'lioit'),
                    "id" => "skype",
                    "std" => "lioit.com",
                    "type" => "text");

$of_options[] = array( "name" => __('Facebook', 'lioit'),
                    "desc" => __('Add your facebook url.', 'lioit'),
                    "id" => "facebook",
                    "std" => "https://www.facebook.com/pages/lioit/174221319304233",
                    "type" => "text");
					

					

					
$of_options[] = array( "name" => __('Youtube', 'lioit'),
                    "desc" => __('Add your youtube url.', 'lioit'),
                    "id" => "youtube",
                    "std" => "#",
                    "type" => "text");

$of_options[] = array( "name" => __('Vimeo', 'lioit'),
                    "desc" => __('Add your vimeo url.', 'lioit'),
                    "id" => "vimeo",
                    "std" => "http://vimeo.com/user7001558",
                    "type" => "text");

$of_options[] = array( "name" => __('RSS', 'lioit'),
                    "desc" => __('Add your rss url.', 'lioit'),
                    "id" => "rss",
                    "std" => "#",
                    "type" => "text");	
                    
$of_options[] = array( "name" => __('stublupon', 'lioit'),
                    "desc" => __('Add your stublupon url.', 'lioit'),
                    "id" => "stublupon",
                    "std" => "http://www.stublupon.com/#/people/lioit/",
                    "type" => "text");
                    
$of_options[] = array( "name" => __('tumblr', 'lioit'),
                    "desc" => __('Add your tumblr url.', 'lioit'),
                    "id" => "tumblr",
                    "std" => "#",
                    "type" => "text");

                   
$of_options[] = array( "name" => __("Twitter API", 'lioit'),
					"id" => "Twitter API",
					"std" => "",
					"type" => "info");
$of_options[] = array( "name" => __('Twitter Username', 'lioit'),
                    "id" => "twitter_username",
                    "std" => "",
                    "type" => "text");

$of_options[] = array( "name" => __('Twitter Consumer Key', 'lioit'),
                    "id" => "twitter_consumer_key",
                    "std" => "",
                    "type" => "text");

$of_options[] = array( "name" => __('Twitter Consumer Secret', 'lioit'),
                    "id" => "twitter_consumer_secret",
                    "std" => "",
                    "type" => "text");	
                    
$of_options[] = array( "name" => __('Twitter Access Token', 'lioit'),
                    "id" => "twitter_access_token",
                    "std" => "",
                    "type" => "text");
                    
$of_options[] = array( "name" => __('Twitter Access Token Secret', 'lioit'),
                    "id" => "twitter_access_token_secret",
                    "std" => "",
                    "type" => "text");



global $woocommerce; 
if ($woocommerce) {
		 
  $of_options[] = array( "name" => __('WooCommerce Options', 'lioit'),
	  "id" => "WooCommerce Options",
	  "icon"		=> ADMIN_IMAGES . "/icons/globe.png",
	  "type" => "heading");
	  

  
$url =  ADMIN_DIR . 'assets/images/woo/';
$of_options[] = array( "name" => __("Main Shop Layout", 'lioit'),
					"desc" 		=> __('Please select layout you would like to use on your main shop page.', 'lioit'),
					"id" => "main_shop_layout",
					"std" => "no-sidebar",
					"type" => "images",
					"options" => array(
						'no-sidebar' => $url . 'no-sidebar.png',
						'right-sidebar' => $url . 'right-sidebar.png',
						'left-sidebar' => $url . 'left-sidebar.png',
						));	
						
$of_options[] = array( "name" => __("Single Product Layout", 'lioit'),
					"desc" 		=> __('Please select layout you would like to use on your single product page.', 'lioit'),
					"id" => "single_product_layout",
					"std" => "no-sidebar",
					"type" => "images",
					"options" => array(
						'no-sidebar' => $url . 'no-sidebar.png',
						'right-sidebar' => $url . 'right-sidebar.png',
						'left-sidebar' => $url . 'left-sidebar.png',
						));	
						
						
						

			
}

/////////////////////////////////////////////////////////////////////////SOCIAL

$of_options[] = array( "name" => __('Contact Page', 'lioit'),
					"id" => "Contact",
					"icon"		=> ADMIN_IMAGES . "/icons/globe.png",
					"type" => "heading");


$of_options[] = array( "name" => __("Map Settings", 'lioit'),
					"id" => "Map Settings",
					"std" => "",
					"type" => "info");						
$of_options[] = array( "name" => __('Default Map Zoom Level', 'lioit'),
					"desc" => __('Value should be between 1-18, 1 being the entire earth and 18 being right at street level.', 'lioit'),
					"id" => "zoom-level",
					"std" => "14",
					"step" => "1",
					"min" => "1",
					"max" => "18",
					
					"type" => "sliderui",
					);
					
$of_options[] = array( 	"name" 		=> __('Enable Map Zoom In/Out', 'lioit'),
						"desc" 		=> __('Do you want users to be able to zoom in/out on the map?', 'lioit'),
						"id" 		=> "enable-map-zoom",
						"std" 		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( "name" => __('Map Center Latitude', 'lioit'),
					"desc" 		=> __('Please enter the latitude for the maps center point.', 'lioit'),
                    "id" => "center-lat",
                    "std" => "51.472081",
                    "type" => "text");
$of_options[] = array( "name" => __('Map Center Longitude', 'lioit'),
					"desc" 		=> __('Please enter the longitude for the maps center point.', 'lioit'),
                    "id" => "center-lng",
                    "std" => "-0.259938",
                    "type" => "text");

$of_options[] = array( "name" => __('Marker Icon Upload', 'lioit'),
					"desc" => __('Please upload an image that will be used for all the markers on your map.', 'lioit'),
					"id" => "marker-img",
					"std" => '',
					"type" => "upload");


$of_options[] = array( "name" => __("Map Locations", 'lioit'),
					"id" => "Map Locations",
					"std" => "",
					"type" => "info");
											
$of_options[] = array( "name" => __('Location #1', 'lioit'),
						"desc" => __('Toggle location #1', 'lioit'),
						"id" 		=> "map-point-1",
						"std" 		=> 0,
						"folds" 	=> 1,
						"type" 		=> "switch"
				);	
$of_options[] = array( "name" => __('Latitude', 'lioit'),
					"desc" 		=> __('Please enter the latitude for your first location.', 'lioit'),
                    "id" => "latitude1",
                    "std" => "",
					"fold" 		=> "map-point-1",
                    "type" => "text");
$of_options[] = array( "name" => __('longitude1', 'lioit'),
					"desc" 		=> __('Please enter the longitude for your first location.', 'lioit'),
                    "id" => "longitude1",
                    "std" => "",
					"fold" 		=> "map-point-1",
                    "type" => "text");
$of_options[] = array( "name" => __('Map Infowindow Text', 'lioit'),
					"desc" 		=> __('If you would like to display any text in an info window for your first location, please enter it here.', 'lioit'),
                    "id" => "map-info1",
                    "std" => "",
					"fold" 		=> "map-point-1",
                    "type" => "textarea");
					

					


$of_options[] = array( "name" => __('Location #2', 'lioit'),
						"desc" => __('Toggle location #2', 'lioit'),
						"id" 		=> "map-point-2",
						"std" 		=> 0,
						"folds" 	=> 1,
						"type" 		=> "switch"
				);	
$of_options[] = array( "name" => __('Latitude', 'lioit'),
					"desc" 		=> __('Please enter the latitude for your first location.', 'lioit'),
                    "id" => "latitude2",
                    "std" => "",
					"fold" 		=> "map-point-2",
                    "type" => "text");
$of_options[] = array( "name" => __('Longitude', 'lioit'),
					"desc" 		=> __('Please enter the longitude for your first location.', 'lioit'),
                    "id" => "longitude2",
                    "std" => "",
					"fold" 		=> "map-point-2",
                    "type" => "text");
$of_options[] = array( "name" => __('Map Infowindow Text', 'lioit'),
					"desc" 		=> __('If you would like to display any text in an info window for your first location, please enter it here.', 'lioit'),
                    "id" => "map-info2",
                    "std" => "",
					"fold" 		=> "map-point-2",
                    "type" => "textarea");
					


$of_options[] = array( "name" => __('Location #3', 'lioit'),
						"desc" => __('Toggle location #3', 'lioit'),
						"id" 		=> "map-point-3",
						"std" 		=> 0,
						"folds" 	=> 1,
						"type" 		=> "switch"
				);	
$of_options[] = array( "name" => __('Latitude', 'lioit'),
					"desc" 		=> __('Please enter the latitude for your first location.', 'lioit'),
                    "id" => "latitude3",
                    "std" => "",
					"fold" 		=> "map-point-3",
                    "type" => "text");
$of_options[] = array( "name" => __('Longitude', 'lioit'),
					"desc" 		=> __('Please enter the longitude for your first location.', 'lioit'),
                    "id" => "longitude3",
                    "std" => "",
					"fold" 		=> "map-point-3",
                    "type" => "text");
$of_options[] = array( "name" => __('Map Infowindow Text', 'lioit'),
					"desc" 		=> __('If you would like to display any text in an info window for your first location, please enter it here.', 'lioit'),
                    "id" => "map-info3",
                    "std" => "",
					"fold" 		=> "map-point-3",
                    "type" => "textarea");
					
					
					
$of_options[] = array( "name" => __('Location #4', 'lioit'),
						"desc" => __('Toggle location #4', 'lioit'),
						"id" 		=> "map-point-4",
						"std" 		=> 0,
						"folds" 	=> 1,
						"type" 		=> "switch"
				);	
$of_options[] = array( "name" => __('Latitude', 'lioit'),
					"desc" 		=> __('Please enter the latitude for your first location.', 'lioit'),
                    "id" => "latitude4",
                    "std" => "",
					"fold" 		=> "map-point-4",
                    "type" => "text");
$of_options[] = array( "name" => __('Longitude', 'lioit'),
					"desc" 		=> __('Please enter the longitude for your first location.', 'lioit'),
                    "id" => "longitude4",
                    "std" => "",
					"fold" 		=> "map-point-4",
                    "type" => "text");
$of_options[] = array( "name" => __('Map Infowindow Text', 'lioit'),
					"desc" 		=> __('If you would like to display any text in an info window for your first location, please enter it here.', 'lioit'),
                    "id" => "map-info4",
                    "std" => "",
					"fold" 		=> "map-point-4",
                    "type" => "textarea");
					
					
					
$of_options[] = array( "name" => __('Location #5', 'lioit'),
						"desc" => __('Toggle location #5', 'lioit'),
						"id" 		=> "map-point-5",
						"std" 		=> 0,
						"folds" 	=> 1,
						"type" 		=> "switch"
				);	
$of_options[] = array( "name" => __('Latitude', 'lioit'),
					"desc" 		=> __('Please enter the latitude for your first location.', 'lioit'),
                    "id" => "latitude5",
                    "std" => "",
					"fold" 		=> "map-point-5",
                    "type" => "text");
$of_options[] = array( "name" => __('Longitude', 'lioit'),
					"desc" 		=> __('Please enter the longitude for your first location.', 'lioit'),
                    "id" => "longitude5",
                    "std" => "",
					"fold" 		=> "map-point-5",
                    "type" => "text");
$of_options[] = array( "name" => __('Map Infowindow Text', 'lioit'),
					"desc" 		=> __('If you would like to display any text in an info window for your first location, please enter it here.', 'lioit'),
                    "id" => "map-info5",
                    "std" => "",
					"fold" 		=> "map-point-5",
                    "type" => "textarea");
					
					
					
$of_options[] = array( "name" => __("Contact Details", 'lioit'),
					"id" => "Contact Details",
					"std" => "",
					"type" => "info");				
$of_options[] = array( "name" => __('Contact Information', 'lioit'),
                    "id" => "contact-info",
                    "std" => "",
                    "type" => "textarea");
/////////////////////////////////////////////////////////////////////////FOOTER

					


					
					
/////////////////////////////////////////////////////////////////////////Buckup					
$of_options[] = array( "name" => __("Backup", 'lioit'),
					"id" => "Backup",
					"icon"		=> ADMIN_IMAGES . "/icons/settings.png",
					"type" => "heading");

$of_options[] = array( "name" => __("Backup and Restore", 'lioit'),
					"desc" => "",
					"id" => "Backup and Restore",
					"std" => "",
					"type" => "info");	

					
$of_options[] = array( "name" => __("Backup and Restore Options", 'lioit'),
                    "id" => "of_backup",
                    "std" => "",
                    "type" => "backup",
					"desc" => __('You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.', 'lioit'),
					);

$of_options[] = array( "name" => __("Transfer Options", 'lioit'),
					"desc" => "",
					"id" => "Transfer Options",
					"std" => "",
					"type" => "info");	
										
$of_options[] = array( "name" => __("Transfer Theme Options Data", 'lioit'),
                    "id" => "of_transfer",
                    "std" => "",
                    "type" => "transfer",
					"desc" => __('You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".
						', 'lioit'),
					);
				
	}//End function: of_options()
}//End chack if function exists: of_options()
?>
