<?php

add_action( 'widgets_init', 'follow_btn_widget' );
function follow_btn_widget() {
	register_widget( 'follow_button' );
}
class follow_button extends WP_Widget {

	function follow_button() {
		$widget_ops = array( 'classname' => 'twitter-widget'  );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'follow_btn-widget' );
		$this->WP_Widget('follow_btn',__('( LioIT ) Follow Button', 'lioit'),$widget_ops);
	}
	
	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );

		$accounts = $instance['accounts'];


		echo $before_widget;
		
		wp_enqueue_script( 'lioit-tweet' );

		if ( $title )
			echo $before_title; ?>
			<?php echo $title ; ?>
		<?php echo $after_title; ?>

		<div class="TwitterFollowBox">
            <div class="followMe">
                            	<a style="border-color:#00729b;" href="https://twitter.com/<?php echo $accounts ?>" class="twitter-follow-button" data-width="170px"  data-show-count="false" data-size="small">Follow @<?php echo $accounts ?></a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>

                           </div>
        </div><!--End TwitterFollowBox-->
		

	<?php 
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );

		$instance['accounts'] = strip_tags( $new_instance['accounts'] );

		return $instance;
	}

	function form( $instance ) {
		$defaults = array( 'title' =>__('@Follow Me' , 'lioit') , 'no_of_tweets' => '5' , 'accounts' => 'Lioit' );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title : ' , 'lioit'); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
	
		<p>
			<label for="<?php echo $this->get_field_id( 'accounts' ); ?>"><?php _e('Twitter username : ' , 'lioit'); ?></label>
			<input id="<?php echo $this->get_field_id( 'accounts' ); ?>" name="<?php echo $this->get_field_name( 'accounts' ); ?>" value="<?php echo $instance['accounts']; ?>" class="widefat" type="text" />
		</p>
		

	<?php
	}
}
?>