<?php
global $post;
add_action( 'widgets_init', 'lioit_tab_widgets' );

function lioit_tab_widgets() {
	register_widget( 'Lioit_Tab_Widget' );
}

class lioit_tab_widget extends WP_Widget {


	
	function Lioit_tab_Widget() {
	
		/* Widget settings */
		$widget_ops = array( 'classname' => 'lioit_tab_widget', 'description' => __('A tabbed widget that display popular posts, recent posts, comments and tags.', 'lioit') );

		/* Widget control settings */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'lioit_tab_widget' );

		/* Create the widget */
		$this->WP_Widget( 'lioit_tab_widget', __('( LioIT ) Custom Tabbed Widget', 'lioit'), $widget_ops, $control_ops );
	}

	/* ---------------------------- */
	/* ------- Display Widget -------- */
	/* ---------------------------- */
	
	function widget( $args, $instance ) {
		global $wpdb;
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$tab1 = $instance['tab1'];
		$tab2 = $instance['tab2'];
		$tab3 = $instance['tab3'];
		$tab4 = $instance['tab4'];
	

		/* Before widget (defined by themes). */
	

		/* Display the widget title if one was input (before and after defined by themes). */
		

		//Randomize tab order in a new array
		$tab = array();
		
		?>

<div class="widget">
  <div class="sideTabs">
    <div class="tab_wrap">
      <ul class="tabNav">
        <li class="firstTab active"><a href="#tabs-1" class="tooltip top" title="<?php _e('Popular' , 'lioit') ?>"><i class="icon-star"></i>
          
          </a></li>
        <li><a href="#tabs-2" class="tooltip top" title="<?php _e('Recent' , 'lioit') ?>"><i class="icon-file-alt"></i>
          
          </a></li>
        <li><a href="#tabs-3" class="tooltip top" title="<?php _e('Comments' , 'lioit') ?>"><i class="icon-comments"></i>
          
          </a></li>
        <li><a href="#tabs-4" class="tooltip top" title="<?php _e('Tags' , 'lioit') ?>"><i class="icon-tags"></i>
          
          </a></li>
      </ul>
      <div class="tabContent" id="tabs-1">
        <ul>
          <?php 
                                           $current_year = date('Y');
                                            $current_month = date('m');
                                        ?>
          <?php query_posts(array(  "ignore_sticky_posts" => 1,'year'     => $current_year,'monthnum' => $current_month, 'showposts' => 5, "orderby" => "comment_count")); ?>
          <?php global $post; if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
          <li>
            <div class="image tabImage">
              
              <a href="<?php the_permalink(); ?>" class="tooltip top" title="<?php the_title(); ?>"><?php the_post_thumbnail('small-block', array('title' => strip_tags(get_the_title()))); ?></a> </div>
            <!--image-->
            <h5> <a href="<?php the_permalink(); ?>">
              <?php 
											$badge_text = get_post_meta($post->ID, 'lioit_post_badge_text', true);
											$badge_color = get_post_meta($post->ID, 'lioit_post_badge_color', true);
										?>
              <?php if ($badge_text) { ?>
              <div class="articleType" style="background-color:<?php echo $badge_color; ?>;"><?php echo $badge_text; ?></div>
              <?php } ?>
              <?php the_title(); ?>
              ..</a></h5>
            <div class="lioPosMeta">
              <?php
                                            $lioit_review_enable =  get_post_meta($post->ID, 'lioit_review_enable', true);
                                            $lioit_review_type =  get_post_meta($post->ID, 'lioit_review_type', true);
                                            $lioit_final_score =  get_post_meta($post->ID, 'lioit_final_score', true);
                                            $lioit_final_percentage = $lioit_final_score * 20 ;
                                        	?>
              <?php if($lioit_review_enable == 'enable'){ ?>
              <span class="lioit-rating lioit-rating-<?php echo esc_html($lioit_review_type); ?>"> <span style="width:<?php echo esc_html($lioit_final_percentage); ?>%;"></span> </span>
              <?php } ?>
              <span class="postViews"><?php echo getPostViews($post->ID); ?> </span> <span class="postComments"><?php comments_popup_link(__('<span class="icon"></span> 0 Comments', 'lioit'), __('<span class="icon"></span> 1 Comment', 'lioit'), __('<span class="icon"></span> % Comments', 'lioit')); ?></span> </div>
            <!--details--> 
          </li>
          <?php endwhile; ?>
          <?php  else:  ?>
          <!-- Else in here -->
          <?php  endif; ?>
          <?php wp_reset_query(); ?>
        </ul>
      </div>
      <!--tab-->
      <div class="tabContent" id="tabs-2">
        <ul>
          <?php query_posts(array(  "ignore_sticky_posts" => 1, 'showposts' => 5 )); ?>
          <?php global $post; if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
          <li>
            <?php $type_badge = get_post_meta($post->ID, 'lioit_post_type', true);?>
            <div class="image tabImage">
              
             <a href="<?php the_permalink(); ?>" class="tooltip top" title="<?php the_title(); ?>"><?php the_post_thumbnail('small-block', array('title' => strip_tags(get_the_title()))); ?></a> </div>
            <!--image-->
            <h5><a href="<?php the_permalink(); ?>">
              <?php 
											$badge_text = get_post_meta($post->ID, 'lioit_post_badge_text', true);
											$badge_color = get_post_meta($post->ID, 'lioit_post_badge_color', true);
										?>
              <?php if ($badge_text) { ?>
              <div class="articleType" style="background-color:<?php echo $badge_color; ?>;"><?php echo $badge_text; ?></div>
              <?php } ?>
              <?php the_title(); ?>
              ..</a></h5>
            <div class="lioPosMeta">
              <?php
                                            $lioit_review_enable =  get_post_meta($post->ID, 'lioit_review_enable', true);
                                            $lioit_review_type =  get_post_meta($post->ID, 'lioit_review_type', true);
                                            $lioit_final_score =  get_post_meta($post->ID, 'lioit_final_score', true);
                                            $lioit_final_percentage = $lioit_final_score * 20 ;
                                        	?>
              <?php if($lioit_review_enable == 'enable'){ ?>
              <span class="lioit-rating lioit-rating-<?php echo esc_html($lioit_review_type); ?>"> <span style="width:<?php echo esc_html($lioit_final_percentage); ?>%;"></span> </span>
              <?php } ?>
              <span class="postViews"><i class="icon-eye-open"></i><?php echo getPostViews($post->ID); ?> </span> <span class="MetapostDate"> <i class="icon-calendar"></i>
              <?php the_time('F d, Y'); ?>
              </span> <span class="postComments"><i class="icon-comments"></i><a href="<?php comments_link();?>">
              <?php comments_number(__('0', 'lioit'), __('1', 'lioit'), __('%', 'lioit'));?>
              </a></span> </div>
            <!--details--> 
          </li>
          <?php endwhile; ?>
          <?php  else:  ?>
          <!-- Else in here -->
          <?php  endif; ?>
          <?php wp_reset_query(); ?>
        </ul>
      </div>
      <!--tab-->
      <div class="tabContent" id="tabs-3">
        <ul>
          <?php 
                                            $sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID, comment_post_ID, comment_author, comment_author_email, comment_date_gmt, comment_approved, comment_type, comment_author_url, SUBSTRING(comment_content,1,70) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID = $wpdb->posts.ID) WHERE comment_approved = '1' AND comment_type = '' AND post_password = '' ORDER BY comment_date_gmt DESC LIMIT 5";
                                            $comments = $wpdb->get_results($sql);
                                            foreach ($comments as $comment) :
                                            ?>
          <li>
            <div class="image"> <a href="<?php echo get_permalink($comment->ID); ?>#comment-<?php echo $comment->comment_ID; ?>" title="<?php echo strip_tags($comment->comment_author); ?> <?php _e('on ', 'lioit'); ?><?php echo $comment->post_title; ?>"><?php echo get_avatar( $comment  ); ?></a> </div>
            <!--image-->
            
            <div class="details">
              <h5><a href="<?php echo get_permalink($comment->ID); ?>#comment-<?php echo $comment->comment_ID; ?>" title="<?php echo strip_tags($comment->comment_author); ?> <?php _e('on ', 'lioit'); ?><?php echo $comment->post_title; ?>"><?php echo strip_tags($comment->comment_author); ?>: <?php echo strip_tags($comment->com_excerpt); ?></a></h5>
            </div>
            <!--details--> 
          </li>
          <?php endforeach; ?>
          <?php wp_reset_query(); ?>
        </ul>
      </div>
      <!--tab-->
      <div class="tabContent tabTags" id="tabs-4">
        <?php wp_tag_cloud('largest=12&smallest=12&unit=px'); ?>
      </div>
    </div>
    <!--tab_wrap--> 
  </div>
  <!--tabs--> 
</div>
<!--End Widget-->

<?php

		/* After widget (defined by themes). */
		
	}

	/* ---------------------------- */
	/* ------- Update Widget -------- */
	/* ---------------------------- */
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );

		/* No need to strip tags */
		$instance['tab1'] = $new_instance['tab1'];
		$instance['tab2'] = $new_instance['tab2'];
		$instance['tab3'] = $new_instance['tab3'];
		$instance['tab4'] = $new_instance['tab4'];
		
		return $instance;
	}
	
	/* ---------------------------- */
	/* ------- Widget Settings ------- */
	/* ---------------------------- */
	
	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	
	function form( $instance ) {
	
		/* Set up some default widget settings. */
		$defaults = array(
		'title' => '',
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

<!-- Widget Title: Text Input -->
<p>
  <?php _e('No Setting' , 'lioit'); ?>
</p>
<?php
	}
}
?>
