<?php 

add_action('widgets_init','pop_posts');

function pop_posts() {
	register_widget('pop_posts');
	
	}

class pop_posts extends WP_Widget {
	function pop_posts() {
			
		$widget_ops = array('classname' => 'pop-posts','description' =>__('Widget Display Popular Posts','lioit'));		
		$this->WP_Widget('pop-posts',__('( LioIT ) Populer Posts','lioit'),$widget_ops);

		}
		
	function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		$count = $instance['count'];
		$type = $instance['type'];
		echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
?>

<div class="lioLatestPosts">
  <?php query_posts(array("ignore_sticky_posts" => 1, 'showposts' => $count)); ?>
  <?php global $post; if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
  
  <article class="post">
  	<div class="postThumb ">
      
       <a href="<?php the_permalink(); ?>" class="tooltip top" title="<?php the_title(); ?>"><?php the_post_thumbnail('main-block', array('title' => strip_tags(get_the_title()))); ?></a> </div>
    <!--End Post Thumb-->
    <div class="post-title">
      <aside><?php the_category(', ') ?></aside>
      <h6><a href="<?php the_permalink();?>" rel="bookmark" title="<?php the_title(); ?>" class="postlink"><?php 
											$badge_text = get_post_meta($post->ID, 'lioit_post_badge_text', true);
											$badge_color = get_post_meta($post->ID, 'lioit_post_badge_color', true);
										?>
      <?php if ($badge_text) { ?>
      <div class="articleType" style="background-color:<?php echo $badge_color; ?>;"><?php echo $badge_text; ?></div>
      <?php } ?><?php the_title(); ?></a></h6>
    </div>
    <div class="post-content">
      <p><?php echo excerpt(10); ?></p>
      <aside class="post-meta">
  
      <?php
                                            $lioit_review_enable =  get_post_meta($post->ID, 'lioit_review_enable', true);
                                            $lioit_review_type =  get_post_meta($post->ID, 'lioit_review_type', true);
                                            $lioit_final_score =  get_post_meta($post->ID, 'lioit_final_score', true);
                                            $lioit_final_percentage = $lioit_final_score * 20 ;
                                        	?>
      <?php if($lioit_review_enable == 'enable'){ ?>
      <span class="lioit-rating lioit-rating-<?php echo esc_html($lioit_review_type); ?>"> <span style="width:<?php echo esc_html($lioit_final_percentage); ?>%;"></span> </span>
      <?php } ?>
      <span class="postViews"><?php echo getPostViews($post->ID); ?> </span> <span class="postComments"><?php comments_popup_link(__('<span class="icon"></span> 0 Comments', 'lioit'), __('<span class="icon"></span> 1 Comment', 'lioit'), __('<span class="icon"></span> % Comments', 'lioit')); ?></span>
      </aside>
    </div>
  </article>
  <?php endwhile; ?>
  <?php  else:  ?>
  <!-- Else in here -->
  <?php  endif; ?>
  <?php wp_reset_query(); ?>
</div>
<?php 
		
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['count'] = $new_instance['count'];
		$instance['type'] = $new_instance['type'];

		return $instance;
	}
	
function form( $instance ) {

	
		$defaults = array( 'title' => 'Top Posts', 
			'count' => 5
 			);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
<p>
  <label for="<?php echo $this->get_field_id( 'title' ); ?>">
    <?php _e('Title : ' , 'lioit') ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"  value="<?php echo $instance['title']; ?>"  class="widefat" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'count' ); ?>">
    <?php _e('Count : ' , 'lioit') ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'count' ); ?>" name="<?php echo $this->get_field_name( 'count' ); ?>" type="text"  value="<?php echo $instance['count']; ?>" class="widefat" />
</p>
<?php 
}
	} //end class

