<?php 

add_action('widgets_init','random_posts');

function random_posts() {
	register_widget('random_posts');
	
	}

class random_posts extends WP_Widget {
	function random_posts() {
			
		$widget_ops = array('classname' => 'latest-posts','description' =>__('Widget Display Latest Posts','lioit'));		
		$this->WP_Widget('random-posts',__('( LioIT ) Latest Posts','lioit'),$widget_ops);

		}
		
	function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		$count = $instance['count'];
		$type = $instance['type'];
		echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
?>

<div class="lioLatestPosts">
  <?php query_posts(array("ignore_sticky_posts" => 1, 'showposts' => $count)); ?>
  <?php global $post; if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
  <div class="lioLatestPost">
    
    <div class="liopostThumb ">      
      <a href="<?php the_permalink(); ?>" class="tooltip top" title="<?php the_title(); ?>"><?php the_post_thumbnail('small-block', array('title' => strip_tags(get_the_title()))); ?></a> </div>
    <!--End Post Thumb-->
    <h4><a href="<?php the_permalink(); ?>">
      <?php 
											$badge_text = get_post_meta($post->ID, 'lioit_post_badge_text', true);
											$badge_color = get_post_meta($post->ID, 'lioit_post_badge_color', true);
										?>
      <?php if ($badge_text) { ?>
      <div class="articleType" style="background-color:<?php echo $badge_color; ?>;"><?php echo $badge_text; ?></div>
      <?php } ?>
      <?php the_title(); ?>
      </a></h4>
    
    <div class="lioPosMeta">
      <?php
                                            $lioit_review_enable =  get_post_meta($post->ID, 'lioit_review_enable', true);
                                            $lioit_review_type =  get_post_meta($post->ID, 'lioit_review_type', true);
                                            $lioit_final_score =  get_post_meta($post->ID, 'lioit_final_score', true);
                                            $lioit_final_percentage = $lioit_final_score * 20 ;
                                        	?>
      <?php if($lioit_review_enable == 'enable'){ ?>
      <span class="lioit-rating lioit-rating-<?php echo esc_html($lioit_review_type); ?>"> <span style="width:<?php echo esc_html($lioit_final_percentage); ?>%;"></span> </span>
      <?php } ?>
      <span class="postViews"><?php echo getPostViews($post->ID); ?> </span>  <span class="postComments"><?php comments_popup_link(__('<span class="icon"></span> 0 Comments', 'lioit'), __('<span class="icon"></span> 1 Comment', 'lioit'), __('<span class="icon"></span> % Comments', 'lioit')); ?></span> </div>
  </div>
  <?php endwhile; ?>
  <?php  else:  ?>
  <!-- Else in here -->
  <?php  endif; ?>
  <?php wp_reset_query(); ?>
</div>
<?php 
		
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['count'] = $new_instance['count'];
		$instance['type'] = $new_instance['type'];

		return $instance;
	}
	
function form( $instance ) {

	
		$defaults = array( 'title' => 'Latest Posts', 
			'count' => 5
 			);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
<p>
  <label for="<?php echo $this->get_field_id( 'title' ); ?>">
    <?php _e('Title : ' , 'lioit') ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"  value="<?php echo $instance['title']; ?>"  class="widefat" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'count' ); ?>">
    <?php _e('Count : ' , 'lioit') ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'count' ); ?>" name="<?php echo $this->get_field_name( 'count' ); ?>" type="text"  value="<?php echo $instance['count']; ?>" class="widefat" />
</p>
<?php 
}
	} //end class
