<?php

/**

 * Plugin Name: Homepage Category List Widget

 */



add_action( 'widgets_init', 'catlist_load_widgets' );



function catlist_load_widgets() {

	register_widget( 'catlist_widget' );

}



class catlist_widget extends WP_Widget {



	/**

	 * Widget setup.

	 */

	function catlist_widget() {

		/* Widget settings. */

		$widget_ops = array( 'classname' => 'catlist_widget', 'description' => __('A widget that displays a list of posts from a category of your choice.', 'lioit') );



		/* Widget control settings. */

		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'catlist_widget' );



		/* Create the widget. */

		$this->WP_Widget( 'catlist_widget', __('( LioIT ) Category List Widget', 'lioit'), $widget_ops, $control_ops );

	}



	/**

	 * How to display the widget on the screen.

	 */

	function widget( $args, $instance ) {

		extract( $args );



		/* Our variables from the widget settings. */

		$title = apply_filters('widget_title', $instance['title'] );

		$number = $instance['number'];

		$categories = $instance['categories'];



		/* Before widget (defined by themes). */

		echo $before_widget;



		/* Display the widget title if one was input (before and after defined by themes). */



		?>
<div class="lioLatestPosts"> 
<div class="widgetTitle"><h5><a href="<?php echo get_category_link( $categories ); ?>"><?php echo $title; ?></a></h5><span class="titleBorder"></span></div>
   <div class="LioLatestCat">    
<div class="catFirstPost">

<ul class="LioCatPosts">
  <?php global $post; $recent = new WP_Query(array("ignore_sticky_posts" => 1, 'cat' => $categories, 'showposts' => $number )); while($recent->have_posts()) : $recent->the_post();?>
  <div class="lioLatestPost">
    
   
    <!--End Post Thumb-->
    <h4><a href="<?php the_permalink(); ?>">
      <?php 
											$badge_text = get_post_meta($post->ID, 'lioit_post_badge_text', true);
											$badge_color = get_post_meta($post->ID, 'lioit_post_badge_color', true);
										?>
      <?php if ($badge_text) { ?>
      <div class="articleType" style="background-color:<?php echo $badge_color; ?>;"><?php echo $badge_text; ?></div>
      <?php } ?>
      <?php the_title(); ?>
      </a></h4>
  <?php endwhile; ?>
</ul>
</div></div></div>
<?php



		/* After widget (defined by themes). */

		echo $after_widget;

	}



	/**

	 * Update the widget settings.

	 */

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;



		/* Strip tags for title and name to remove HTML (important for text inputs). */

		$instance['title'] = strip_tags( $new_instance['title'] );

		$instance['number'] = strip_tags( $new_instance['number'] );

		$instance['categories'] = $new_instance['categories'];





		return $instance;

	}





	function form( $instance ) {



		/* Set up some default widget settings. */

		$defaults = array( 'title' => __('Widget Title' , 'lioit'), 'number' => 4, 'categories' => 4);

		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

<!-- Widget Title: Text Input -->

<p>
  <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:' , 'lioit'); ?></label>
  <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"  value="<?php echo $instance['title']; ?>" style="width:90%;" />
</p>

<!-- Number of posts -->

<p>
  <label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e('Number of posts to show:' , 'lioit'); ?></label>
  <input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>"  type="text" value="<?php echo $instance['number']; ?>" size="3" />
</p>

<!-- Category -->

<p>
  <label for="<?php echo $this->get_field_id('categories'); ?>"><?php _e('Select Category:' , 'lioit'); ?></label>
  <select id="<?php echo $this->get_field_id('categories'); ?>" name="<?php echo $this->get_field_name('categories'); ?>" style="width:100%;">
    <option value='all' <?php if ('all' == $instance['categories']) echo 'selected="selected"'; ?>><?php _e('All Categories' , 'lioit'); ?></option>
    <?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
    <?php foreach($categories as $category) { ?>
    <option value='<?php echo $category->term_id; ?>' <?php if ($category->term_id == $instance['categories']) echo 'selected="selected"'; ?>><?php echo $category->cat_name; ?></option>
    <?php } ?>
  </select>
</p>
<?php

	}

}



?>
