<?php

/**

 * Plugin Name: Homepage Two-Column Widget

 */



add_action( 'widgets_init', 'cat_load_widgets' );



function cat_load_widgets() {

	register_widget( 'cat_widget' );

}



class cat_widget extends WP_Widget {



	/**

	 * Widget setup.

	 */

	function cat_widget() {

		/* Widget settings. */

		$widget_ops = array( 'classname' => 'cat_widget', 'description' => __('A widget that displays 4 posts from a category of your choice.', 'lioit') );



		/* Widget control settings. */

		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'cat_widget' );



		/* Create the widget. */

		$this->WP_Widget( 'cat_widget', __('( LioIT ) Cat Widget', 'lioit'), $widget_ops, $control_ops );

	}



	/**

	 * How to display the widget on the screen.

	 */

	function widget( $args, $instance ) {

		extract( $args );



		/* Our variables from the widget settings. */

		$title = apply_filters('widget_title', $instance['title'] );

		$categories = $instance['categories'];




echo $before_widget;

		?>

<div class="lioLatestPosts mainCatWidget">
<div class="widgetTitle"><h5><a href="<?php echo get_category_link( $categories ); ?>"><?php echo $title; ?></a></h5><span class="titleBorder"></span></div>
<div class="LioLatestCat">
  
  <ul class="LioCatPosts">
    <?php global $post; $recent = new WP_Query(array("ignore_sticky_posts" => 1, 'cat' => $categories, 'showposts' => '4'  )); while($recent->have_posts()) : $recent->the_post();?>
    <div class="lioLatestPost">
    
    <div class="liopostThumb ">
      
       <a href="<?php the_permalink(); ?>" class="tooltip top" title="<?php the_title(); ?>"><?php the_post_thumbnail('small-block', array('title' => strip_tags(get_the_title()))); ?></a>  </div>
    <!--End Post Thumb-->
    <h4><a href="<?php the_permalink(); ?>">
      <?php 
											$badge_text = get_post_meta($post->ID, 'lioit_post_badge_text', true);
											$badge_color = get_post_meta($post->ID, 'lioit_post_badge_color', true);
										?>
      <?php if ($badge_text) { ?>
      <div class="articleType" style="background-color:<?php echo $badge_color; ?>;"><?php echo $badge_text; ?></div>
      <?php } ?>
      <?php the_title(); ?>
      </a></h4>
    
    <div class="lioPosMeta">
      <?php
                                            $lioit_review_enable =  get_post_meta($post->ID, 'lioit_review_enable', true);
                                            $lioit_review_type =  get_post_meta($post->ID, 'lioit_review_type', true);
                                            $lioit_final_score =  get_post_meta($post->ID, 'lioit_final_score', true);
                                            $lioit_final_percentage = $lioit_final_score * 20 ;
                                        	?>
      <?php if($lioit_review_enable == 'enable'){ ?>
      <span class="lioit-rating lioit-rating-<?php echo esc_html($lioit_review_type); ?>"> <span style="width:<?php echo esc_html($lioit_final_percentage); ?>%;"></span> </span>
      <?php } ?>
      <span class="postViews"><?php echo getPostViews($post->ID); ?> </span>  <span class="postComments"><?php comments_popup_link(__('<span class="icon"></span> 0 Comments', 'lioit'), __('<span class="icon"></span> 1 Comment', 'lioit'), __('<span class="icon"></span> % Comments', 'lioit')); ?></span> </div>
  </div>
    <?php endwhile; ?>
  </ul>
</div></div>

<?php

echo $after_widget;

		/* After widget (defined by themes). */

	

	}



	/**

	 * Update the widget settings.

	 */

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;



		/* Strip tags for title and name to remove HTML (important for text inputs). */

		$instance['title'] = strip_tags( $new_instance['title'] );

		$instance['categories'] = $new_instance['categories'];





		return $instance;

	}





	function form( $instance ) {



		/* Set up some default widget settings. */

		$defaults = array( 'title' => __('Widget Title' , 'lioit'), 'categories' => 4);

		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

<!-- Widget Title: Text Input -->

<p>
  <label for="<?php echo $this->get_field_id( 'title' ); ?>">
    <?php _e('Title:','lioit'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"  value="<?php echo $instance['title']; ?>" style="width:90%;" />
</p>

<!-- Category -->

<p>
  <label for="<?php echo $this->get_field_id('categories'); ?>"><?php _e('Select Category:' , 'lioit'); ?></label>
  <select id="<?php echo $this->get_field_id('categories'); ?>" name="<?php echo $this->get_field_name('categories'); ?>" style="width:100%;">
    <option value='all' <?php if ('all' == $instance['categories']) echo 'selected="selected"'; ?>><?php _e('All Categories' , 'lioit'); ?></option>
    <?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
    <?php foreach($categories as $category) { ?>
    <option value='<?php echo $category->term_id; ?>' <?php if ($category->term_id == $instance['categories']) echo 'selected="selected"'; ?>><?php echo $category->cat_name; ?></option>
    <?php } ?>
  </select>
</p>
<?php

	}

}



?>
