<?php 

add_action('widgets_init','Lioit_social_counter');

function Lioit_social_counter() {
	register_widget('Lioit_social_counter');
	}

class Lioit_social_counter extends WP_Widget {
	function Lioit_social_counter() {
			
		$widget_ops = array('classname' => 'Lioit_social_counter','description' => __('Widget display a count of your rss subscribers, Twitter followers, facebook fans','lioit'));
		
		$this->WP_Widget('Lioit_social_counter',__('( LioIT ) Social Counter','lioit'),$widget_ops);

		}
		
	function widget( $args, $instance ) {

		$facebook_page = $instance['facebook'] ;
		$rss_id = $instance['rss'] ;
		$twitter_id =  $instance['twitter'] ;
		$youtube_url = $instance['youtube'] ;
		


				
		$counter = 0;
		if( $rss_id ) $counter ++ ;
		if( $twitter_id ) $counter ++ ;
		if( $facebook_page ) $counter ++ ;
		if( $youtube_url ) $counter ++ ;
	


		

?>

				
		

		 					
                        		<div class="widget socialCounters">
                                			    <?php if( $twitter_id ): $twitter = lioit_followers_count(); ?>
                                            	<a href="<?php echo $twitter['page_url'] ?>" class="socialCounter twitterBox">
                                               		<span class="sNumber"><?php echo @number_format($twitter['followers_count']) ?><i><?php _e('Followers','lioit') ?></i></span>
                                                    <i class="counterIcon icon-twitter"></i>
                                                </a><!--End Twitter-->
                                                <?php endif; ?>
                                                <?php if( $facebook_page ): $facebook = lioit_facebook_fans( $facebook_page ); ?>
                                                <a href="<?php echo $facebook_page ?>" class="socialCounter facebookBox">
                                               		<span class="sNumber"><?php echo @number_format( $facebook ) ?><i><?php _e('Fans','lioit') ?></i></span>
                                                    <i class="counterIcon icon-facebook"></i>
                                                </a><!--End facebookBox-->
                                                <?php endif; ?>
                                                <?php if( $youtube_url ): $youtube = lioit_youtube_subs( $youtube_url ); ?>
                                                <a href="<?php echo $youtube_url ?>" class="socialCounter youtubeBox">
                                               		<span class="sNumber"><?php echo @number_format( $youtube ) ?><i><?php _e('Subscribers','lioit') ?></i></span>
                                                    <i class="counterIcon icon-youtube"></i>
                                                </a><!--End youtubeBox-->
                                                <?php endif; ?>
                                                
                                                <?php if( $rss_id ): ?>
                                                <a href="<?php echo $rss_id ?>" class="socialCounter newsletterBox">
                                               		<span class="sNumber"><?php _e('Join Now','lioit') ?><i><?php _e('Subscribe','lioit') ?></i></span>
                                                    <i class="counterIcon icon-rss"></i>
                                                </a><!--End newsletterBox-->
                                                <?php endif; ?>
                                            </div><!--End Widget-->
                       
<?php 
		
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['facebook'] = $new_instance['facebook'] ;
		$instance['rss'] =  $new_instance['rss'] ;
		$instance['twitter'] =  strip_tags($new_instance['twitter']) ;
		$instance['youtube'] = $new_instance['youtube'] ;
		return $instance;
	}
	
function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<label for="<?php echo $this->get_field_id( 'rss' ); ?>"><?php _e('Feed URL : ', 'lioit'); ?></label>
			<input id="<?php echo $this->get_field_id( 'rss' ); ?>" name="<?php echo $this->get_field_name( 'rss' ); ?>" value="<?php echo $instance['rss']; ?>" class="widefat" type="text" />
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<label for="<?php echo $this->get_field_id( 'facebook' ); ?>"><?php _e('Facebook Page URL : ', 'lioit'); ?></label>
			<input id="<?php echo $this->get_field_id( 'facebook' ); ?>" name="<?php echo $this->get_field_name( 'facebook' ); ?>" value="<?php echo $instance['facebook']; ?>" class="widefat" type="text" />
			<small><?php _e('Link must be like', 'lioit'); ?> http://www.facebook.com/username/ <?php _e('or', 'lioit'); ?> http://www.facebook.com/PageID/</small>

		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<label for="<?php echo $this->get_field_id( 'twitter' ); ?>"><?php _e('Enable Twitter : ', 'lioit'); ?></label>
			<input id="<?php echo $this->get_field_id( 'twitter' ); ?>" name="<?php echo $this->get_field_name( 'twitter' ); ?>"  value="true" <?php if( $instance['twitter'] ) echo 'checked="checked"'; ?> type="checkbox"  />
			<small><em style="color:red;"><?php _e('Make sure you Setup Twitter API OAuth settings under Theme Options > Social', 'lioit'); ?></em></small>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<label for="<?php echo $this->get_field_id( 'youtube' ); ?>"><?php _e('Youtube Channel URL :', 'lioit'); ?> </label>
			<input id="<?php echo $this->get_field_id( 'youtube' ); ?>" name="<?php echo $this->get_field_name( 'youtube' ); ?>" value="<?php echo $instance['youtube']; ?>" class="widefat" type="text" />
			<small><?php _e('Link must be like', 'lioit'); ?> http://www.youtube.com/user/username </small>

		</p>
		
      


	<?php
	}
	} //end class