<?php 

add_action('widgets_init','custom_ad');

function custom_ad() {
	register_widget('custom_ad');
	
	}

class custom_ad extends WP_Widget {
	function custom_ad() {
			
		$widget_ops = array('classname' => 'custom_ad','description' => 'Widget display Custom Ads');
		$this->WP_Widget('custom_ad',__('( LioIT ) Custom Ads','lioit'),$widget_ops);

		}
		
	function widget( $args, $instance ) {
		extract( $args );
		/* User-selected settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$adsurl = $instance['adsurl'];
		$adstitle = $instance['adstitle'];
		$adsdesc = $instance['adsdesc'];
		$adsimg = $instance['adsimg'];

		/* Before widget (defined by themes). */
		

		/* Title of widget (before and after defined by themes). */
		if ( $title )
			
?>
              <div class="widget customAd">
                  <h6><a href="<?php echo $adsurl ?>"><?php echo $adstitle ?><span><?php echo $adsurl ?></span></a></h6>
                  <div class="mainAdImage">
                      <a href="<?php echo $adsurl ?>"><img src="<?php echo $adsimg ?>" alt="<?php echo $adstitle ?>" /></a>
                  </div><!--End Ad Image-->
                  <p><?php echo $adsdesc ?></p>
              </div><!--End MAin Ad--->

			
<?php 
		/* After widget (defined by themes). */
		
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags (if needed) and update the widget settings. */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['adsurl'] = $new_instance['adsurl'];
		$instance['adstitle'] = $new_instance['adstitle'];
		$instance['adsdesc'] = $new_instance['adsdesc'];
		$instance['adsimg'] = $new_instance['adsimg'];

		return $instance;
	}
	
function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 'title' => 'Advertisement', 
			'adsimg' => lioit_IMG.'/big_ad.png', 
			'adstitle' => 'Ad Name',
			'adsurl' => '#',
			'adsimg' => '#',
			'adsdesc' => 'Ad Description'
 			);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
	
    	
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
		<label for="<?php echo $this->get_field_id( 'adstitle' ); ?>"><?php _e('Ad Name', 'lioit') ?></label>
        <input  id="<?php echo $this->get_field_id( 'adstitle' ); ?>" name="<?php echo $this->get_field_name( 'adstitle' ); ?>" <?php echo $instance['adstitle']; ?> class="widefat" type="text"  value="<?php echo $instance['adstitle']; ?>"  />
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
		<label for="<?php echo $this->get_field_id( 'adsimg' ); ?>"><?php _e('Ad IMG url', 'lioit') ?></label>
        <input  id="<?php echo $this->get_field_id( 'adsimg' ); ?>" name="<?php echo $this->get_field_name( 'adsimg' ); ?>" <?php echo $instance['adsimg']; ?> class="widefat" type="text"  value="<?php echo $instance['adsimg']; ?>"  />
		</p>
        <p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
		<label for="<?php echo $this->get_field_id( 'adsdesc' ); ?>"><?php _e('Ad Description', 'lioit') ?></label>
        <textarea  id="<?php echo $this->get_field_id( 'adsdesc' ); ?>" name="<?php echo $this->get_field_name( 'adsdesc' ); ?>" <?php echo $instance['adsdesc']; ?> class="widefat"><?php echo $instance['adsdesc']; ?></textarea>
		</p>
        <p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
		<label for="<?php echo $this->get_field_id( 'adsurl' ); ?>"><?php _e('Ad URL', 'lioit') ?></label>
        <input  id="<?php echo $this->get_field_id( 'adsurl' ); ?>" name="<?php echo $this->get_field_name( 'adsurl' ); ?>" <?php echo $instance['adsurl']; ?> class="widefat" type="text"  value="<?php echo $instance['adsurl']; ?>"  />
		</p>
        
	

        
   <?php 
}
	} //end class