<?php 

add_action('widgets_init','recent_comments');

function recent_comments() {
	register_widget('recent_comments');
	}

class recent_comments extends WP_Widget {
	function recent_comments() {
			
		$widget_ops = array('classname' => 'comments','description' => __('Widget display Recent Comments with avatar','lioit'));	
		$this->WP_Widget('comments',__('( LioIT ) Recent Comments','lioit'),$widget_ops);

		}
		
	function widget( $args, $instance ) {
		extract( $args );
		/* User-selected settings. */
	$title = apply_filters('widget_title', $instance['title'] );
	$count = $instance['count'];

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Title of widget (before and after defined by themes). */
		if ( $title )
			echo $before_title . $title . $after_title;

?>

		<ul class="blog_posts_widget">
                   		<?php
						global $wpdb;

						$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID, comment_post_ID, comment_author, comment_author_email, comment_date_gmt, comment_approved, comment_type, comment_author_url, SUBSTRING(comment_content,1,70) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID = $wpdb->posts.ID) WHERE comment_approved = '1' AND comment_type = '' AND post_password = '' ORDER BY comment_date_gmt DESC LIMIT $count";
						$comments = $wpdb->get_results($sql);
						foreach ($comments as $comment) :
						?>
                        <li class="blog_post">
                                <a class="rc_img" href="<?php echo get_permalink($comment->ID); ?>#comment-<?php echo $comment->comment_ID; ?>" title="<?php echo strip_tags($comment->comment_author); ?> <?php _e('on ', 'lioit'); ?><?php echo $comment->post_title; ?>"><?php echo get_avatar( $comment, '50' ); ?></a>
                            
                                <p><a href="<?php echo get_permalink($comment->ID); ?>#comment-<?php echo $comment->comment_ID; ?>" title="<?php echo strip_tags($comment->comment_author); ?> <?php _e('on ', 'lioit'); ?><?php echo $comment->post_title; ?>"><?php echo strip_tags($comment->comment_author); ?>:
                        <?php 
			$excerpt = $comment->com_excerpt;
			echo wp_html_excerpt($excerpt,75);
                        ?> ... 

				</a></p>
                        </li>

                        <?php endforeach; ?>
                        
                        <?php wp_reset_query(); ?>

                    </ul>
<?php 
		/* After widget (defined by themes). */
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['count'] = $new_instance['count'];

		return $instance;
	}
	
function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 
			'title' => __('Comments', 'lioit'),
			'count' => '5'
 			);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
	
    	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'lioit'); ?></label>
		<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" type="text"   class="widefat" />
		</p>

		<p>
		<label for="<?php echo $this->get_field_id( 'count' ); ?>"><?php _e('Number of comments', 'lioit'); ?></label>
		<input id="<?php echo $this->get_field_id( 'count' ); ?>" name="<?php echo $this->get_field_name( 'count' ); ?>" value="<?php echo $instance['count']; ?>"  type="text" class="widefat" />
		</p>


   <?php 
}
	} //end class