(function() {
    tinymce.create('tinymce.plugins.quote', {
        init : function(ed, url) {
            ed.addButton('quote', {
                title : 'Add a quote',
                image : url+'/images/quote.png',
                onclick : function() {
// triggers the thickbox
						var width = jQuery(window).width(), H = jQuery(window).height(), W = ( 720 < width ) ? 720 : width;
						W = W - 80;
						H = H - 84;
						tb_show( 'Quote Shortcodes', '#TB_inline?width=' + W + '&height=' + H + '&inlineId=quote-form' );
						                }
            });
        },
        createControl : function(n, cm) {
            return null;
        }
    });
    tinymce.PluginManager.add('quote', tinymce.plugins.quote);
    
    // executes this when the DOM is ready
	jQuery(function(){
		// creates a form to be displayed everytime the button is clicked
		// you should achieve this using AJAX instead of direct html code like this
		var form = jQuery('<div id="quote-form"><table id="quote-table" class="form-table">\
	    		<tr>\
				<th><label for="quote-float">Float</label></th>\
				<td><select id="quote-float" name="type" style="width:150px;">\
				<option value=""></option>\
				<option value="right">Right</option>\
				<option value="Left">Left</option>\
				</select>\
				<small>default without float.</small></td>\
				<br />\
			</tr>\
			<tr>\
				<th><label for="quote-by">Quote By</label></th>\
				<td><input type="text" id="quote-by" name="by" />\
				<small>The Name.</small></td>\
			</tr>\
			<tr>\
				<th><label for="quote-content">quote Content</label></th>\
				<td><textarea id="quote-content" name="content" cols="40" rows="6"></textarea><br />\
			    </td>\
			</tr>\
		</table>\
		<p class="submit">\
			<input type="button" id="quote-submit" class="btn" value="Insert quote" name="submit" />\
		</p>\
		</div>');
		var table = form.find('table');
		form.appendTo('body').hide();
		
		// handles the click event of the submit button
		form.find('#quote-submit').click(function(){
			// defines the options and their default values
			// again, this is not the most elegant way to do this
			// but well, this gets the job done nonetheless
			var options = { 
				'float':'',
				'by':''
		};
			var shortcode = '[quote';
			
			for( var index in options) {
				var value = table.find('#quote-' + index).val();
				
				// attaches the attribute to the shortcode only if it's different from the default value
				if ( value !== options[index] )
					shortcode += ' ' + index + '="' + value + '"';
			}
			
			shortcode += ']' + table.find('#quote-content').val()+'[/quote]';
			
			// inserts the shortcode into the active editor
			tinyMCE.activeEditor.execCommand('mceInsertContent', 0, shortcode);
			
			// closes Thickbox
			tb_remove();
		});
	});
})();
