<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/
 */

/********************* META BOX DEFINITIONS ***********************/

/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
// Better has an underscore as last sign
$prefix = 'lioit_';
$imagepath =  get_stylesheet_directory_uri() . '/admin/assets/images';
global $meta_boxes;

$meta_boxes = array();

$meta_boxes[] = array(
	'id' => 'type_setting',
	'context' => 'side',
	'title' => 'Post Badge',
	'pages' => array('post'),


	'fields' => array(
	 
		array(
			'id' => $prefix . 'post_badge_text',
			'type' => 'text',
			'std' =>'',
			'class' => 'post_badge_text',
		),
		
		
		array(
			'id' => $prefix . 'post_badge_color',
			'type' => 'color',
			'std' =>'#e94b35',
			'class' => 'post_badge_color',
		),
		
		
		

		), 
		
);



$imagepath =  get_stylesheet_directory_uri() . '/admin/assets/images';
$meta_boxes[] = array(
	'id' => 'postformat',
	'title' => 'Post Options',
	'pages' => array( 'post' ),
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array(
			'name'		=> '<img src="'. $imagepath . '/slider1.png">',
			'desc'		=> 'Flexslider Light',
			'id'		=> $prefix . 'slider1',
			'class'		=> 'mainslider',
			'clone'		=> false,
			'type'		=> 'checkbox',
			'std'		=> false
		),
		array(
			'name'		=> '<img src="'. $imagepath . '/slider2.png">',
			'desc'		=> 'Owl Carousel',
			'id'		=> $prefix . 'slider2',
			'class'		=> 'mainslider',
			'clone'		=> false,
			'type'		=> 'checkbox',
			'std'		=> false
		),
		array(
			'name'		=> '<img  src="'. $imagepath . '/slider3.png">',
			'desc'		=> 'Classic Carousel',
			'id'		=> $prefix . 'slider3',
			'class'		=> 'mainslider',
			'clone'		=> false,
			'type'		=> 'checkbox',
			'std'		=> false
		),
		array(
			'name'		=> '<img src="'. $imagepath . '/slider4.png">',
			'desc'		=> 'BxSlider Full',
			'id'		=> $prefix . 'slider4',
			'class'		=> 'mainslider',
			'clone'		=> false,
			'type'		=> 'checkbox',
			'std'		=> false
		),
		array(
			'name'		=> '<img src="'. $imagepath . '/slider5.png">',
			'desc'		=> 'Flexslider With Thumbnail',
			'id'		=> $prefix . 'slider5',
			'class'		=> 'mainslider',
			'clone'		=> false,
			'type'		=> 'checkbox',
			'std'		=> false
		),
		array(
			'name' => __('Enable Feature Image ', 'lioit'),
			'id' => $prefix . 'feature_image',
			"desc" => __('enable this option if you want show Feature Image in single post', 'lioit'),
			'type' => 'checkbox',
			'std' => false,
		),
		
		array(
			'name'		=> 'Post Format',
			'id'		=> $prefix . "postformat",
			'type'		=> 'select',
			'options'	=> array(
				'standart'	=> 'Standard',
				'gallery'	=> 'Gallery',
				'video'		=> 'Video',
				'audio'		=> 'Audio'
			),
			'multiple'	=> false,
			'desc'		=> 'Choose post format style. ("Standard" is default, "featured image" will use)',
			'std'		=> array( 'Standart' )
		),
		
		array(
			'name'		=> 'Gallery Images',
			'id'		=> $prefix . 'slideshow_imgs',
			'desc'		=> 'Upload more images for a slideshow.',
			'type'		=> 'image_advanced'
		),
		array(
			'name'		=> 'Vimeo Video',
			'id'		=> $prefix . 'postvideo_v',
			'desc'		=> 'Enter Vimeo Video ID. For example: 62959319 ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Youtube Video',
			'id'		=> $prefix . 'postvideo_y',
			'desc'		=> 'Enter Youtube Video ID. For example: 8F7UOBIT4Vk ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> 'Dailymotion Video',
			'id'		=> $prefix . 'postvideo_d',
			'desc'		=> 'Enter Dailymotion Video ID. For example: xzq6yf ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		
		
		
		
		
		array(
			'name' => __('MP3 File URL', 'lioit'),
			'id' => $prefix . 'mp3_url',
			"desc" => __('The URL to the .mp3 audio file', 'lioit'),
			'type' => 'text',
			'std' => '',
		),
		array(
			'name' => __('OGA File URL', 'lioit'),
			'id' => $prefix . 'oog_url',
			"desc" => __('The URL to the .oga, .ogg audio file', 'lioit'),
			'type' => 'text',
			'std' => '',
		),
		
		array(
			'name'		=> 'Soundcloud Audio',
			'id'		=> $prefix . 'audio_soundcloud',
			'desc'		=> 'Enter Soundcloud URL. For example: https://soundcloud.com/mjimmortal/sets/immortal',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		)
		
	)
);






$meta_boxes[] = array(
	'id' => 'postads',
	'title' => 'Ads Options',
	'pages' => array( 'post' ),
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		
		
		array(
			'name'		=> 'Ad Width & Position',
			'id'		=> $prefix . "postads",
			'type'		=> 'select',
			'options'	=> array(
				'nobanner'	=> 'None',
				'left300'	=> '300×250 Top Left',
				'right300'	=> '300×250 Top Right',
				'top468'	=> '468×60 Top',
				'bottom468'	=> '468×60  Bottom',
				'top728'	=> '728×90 Top',
				'bottom728'	=> '728×90  Bottom',
			),
			'multiple'	=> false,
			'desc'		=> 'Choose post format style. ("Standard" is default, "featured image" will use)',
			'std'		=> 'nobanner',
		),
		
		
		
		array(
			'name'		=> '300×250 Ad Code',
			'id'		=> $prefix . 'postadscode300',
			'desc'		=> 'Enter Ad Code ',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),
		
		
		array(
			'name'		=> '728×90 Ad Code',
			'id'		=> $prefix . 'postadscode728',
			'desc'		=> 'Enter Ad Code ',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),
		
		
		array(
			'name'		=> '468×60 Ad Code',
			'id'		=> $prefix . 'postadscode468',
			'desc'		=> 'Enter Ad Code ',
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),
		
		
	)
);




/* ----------------------------------------------------- */
//  Reviews
/* ----------------------------------------------------- */
$meta_boxes[] = array(
	'id' => 'review',
	'title' => 'Review Setting',
	'pages' => array( 'post'),
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array(
			'name'		=> 'Enable Review',
			'id'		=> $prefix . 'review_enable',
			'type'		=> 'select',
			'options'	=> array(
				'disable'	  => 'Disable',
				'enable' => 'Enable'
			),
			'std'		=> 'disable',
		),
		array(
			'name'		=> 'Enable User Ratings?',
			'id'		=> $prefix . 'user_ratings_visibility',
		 
			'type'		=> 'checkbox',
			'std'		=> false
		),
		array(
			'name'		=> 'Rating Table Skin',
			'id'		=> $prefix . "review_skin",
			'type'		=> 'select',
			'options'	=> array(
				'white'	  => 'White',
				'black'	  => 'Black'
			),
			'std'		=> 'white',
			'desc'		=> ''
		),
		array(
			'name'		=> 'Rating Type',
			'id'		=> $prefix . "review_type",
			'type'		=> 'select',
			'options'	=> array(
				'stars'	  => 'Stars',
				'heart'	  => 'Heart',
				'thumb'	  => 'Thumb',
				'check'	  => 'Check',
				'smile'	  => 'Smile',
				'percent' => 'Percentage'
			),
			'std'		=> 'stars',
			'desc'		=> ''
		),
		array(
			'name'		=> 'Criteria Header',
			'desc'		=> "Leave empty if you don't want it",
			'class'		=> "lioit_review_hide ",
			'id'		=> $prefix . "criteria_header",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "4"
		),
		array(
			'name'		=> '<span class="lioit_title">Criteria 1:</span> Description',       // CRITERIA ONE
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria1 lioit_c1 ",
			'id'		=> $prefix . "c1_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5) <em id=lioit_preview_rating_1></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c1",
			'id'		=> $prefix . "c1_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),
		array(
			'name'		=> '<span class="lioit_title">Criteria 2:</span> Description',        //CRITERIA TWO
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria2  lioit_c2",
			'id'		=> $prefix . "c2_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5) <em id=lioit_preview_rating_2></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c2",
			'id'		=> $prefix . "c2_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),
		array(
			'name'		=> '<span class="lioit_title">Criteria 3:</span> Description',		//CRITERIA THREE
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria3  lioit_c3",
			'id'		=> $prefix . "c3_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5) <em id=lioit_preview_rating_3></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c3",
			'id'		=> $prefix . "c3_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),
		array(
			'name'		=> '<span class="lioit_title">Criteria 4:</span> Description',		//CRITERIA FOUR
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria4  lioit_c4",
			'id'		=> $prefix . "c4_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5)  <em id=lioit_preview_rating_4></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c4",
			'id'		=> $prefix . "c4_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),
		array(
			'name'		=> '<span class="lioit_title">Criteria 5:</span> Description',		//CRITERIA FIVE
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria5  lioit_c5",
			'id'		=> $prefix . "c5_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5) <em id=lioit_preview_rating_5></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c5",
			'id'		=> $prefix . "c5_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),
		array(
			'name'		=> '<span class="lioit_title">Criteria 6:</span> Description',		//CRITERIA SIX
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria6  lioit_c6",
			'id'		=> $prefix . "c6_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5) <em id=lioit_preview_rating_6></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c6",
			'id'		=> $prefix . "c6_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),
		array(
			'name'		=> '<span class="lioit_title">Criteria 7:</span> Description',		//CRITERIA SEVEN
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria7  lioit_c7",
			'id'		=> $prefix . "c7_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5) <em id=lioit_preview_rating_7></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c7",
			'id'		=> $prefix . "c7_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),		
		array(
			'name'		=> '<span class="lioit_title">Criteria 8:</span> Description',		//CRITERIA EIGHT
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_add_criteria8  lioit_c8",
			'id'		=> $prefix . "c8_description",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Rating(1-5) <em id=lioit_preview_rating_8></em>',
			'desc'		=> "",
			'class'		=> "lioit_review_hide lioit_c8",
			'id'		=> $prefix . "c8_rating",
			'type' => 'number',
			'max' => 5,
			'std'		=> "",
		),				
		array(
			'name'		=> 'Total Score',
			'desc'		=> "Total score is <em>__</em>%",
			'class'		=> "lioit_review_hide lioit_fixer",
			'id'		=> $prefix . "final_score",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "1"
		),
		array(
			'name'		=> 'Brief Summary',
			'desc'		=> "Just one or two words( For example: Outstanding! ) ",
			'class'		=> "lioit_review_hide ",
			'id'		=> $prefix . "brief_summary",
			'type'		=> 'text',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "4"
		),
		array(
			'name'		=> 'Longer Summary',
			'desc'		=> "Longer Summary",
			'class'		=> "lioit_review_hide ",
			'id'		=> $prefix . "longer_summary",
			'type'		=> 'textarea',
			'std'		=> "",
			'cols'		=> "50",
			'rows'		=> "4"
		),
		array(
			'name'		=> 'Criteria Position',
			'id'		=> $prefix . "criteria_position",
			'type'		=> 'select',
			'options'	=> array(
				'top'		=> 'Top Left - 300px wide',
				'topright'	=> 'Top Right - 300px wide',
				'bottom'	=> 'Bottom - full width'
			),
			'std'		=> 'bottom',
			'desc'		=> 'Where do you want it to display in the post?'
		)
		
	)
);


$imagepath =  get_stylesheet_directory_uri() . '/admin/assets/images';
$meta_boxes[] = array(
	'id' => 'sidebar_setting',
	'title' => 'Sidebar Options',
	'pages' => array('post','page','gallery','videos'),


	'fields' => array(
	
		array(
			'name' => __('Enable Sidebar Option', 'lioit'),
			'id' => $prefix . 'sideoption',
			"desc" => __('enable this option if you want make changes for sidebar postion', 'lioit'),
			'type' => 'checkbox',
			'std' => false,
		),
		array(
			'id' => $prefix . 'side_layout',
			'type' => 'radio',
			'std' =>'rightside',
			'class' => 'hide postlayout',
			'options' => array (
				'nosidebar' =>'<img class="radio_img" src="'. $imagepath . '/nosidebar.png">',
				'doublesidebarright' =>'<img class="radio_img" src="'. $imagepath . '/doublesidebarright.png">',
				'doublesidebarleft' =>'<img class="radio_img" src="'. $imagepath . '/doublesidebarleft.png">',
				'singlesidebarright' =>'<img class="radio_img" src="'. $imagepath . '/right-sidebar.png">',
				'singlesidebarleft' =>'<img class="radio_img" src="'. $imagepath . '/left-sidebar.png">',
			)
		),
		

		), 
		
);





$meta_boxes[] = array(
	'id' => 'videos',
	'title' => 'videos Options',
	'pages' => array( 'videos' ),
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array(
			'name'     => 'Show Thumb',
			'id'       => $prefix . "video_thumb",
			'type'     => 'select',
			'std'      => 'video',
			'options'  => array(
				'featured_image' => 'Featured Image',
				'video' => 'Video',
			),
			'multiple' => false,
		),
		
		
		array(
			'name'		=> 'Video Type',
			'id'		=> $prefix . "video_type",
			'type'		=> 'select',
			'options'	=> array(
				'youtube'	=> 'Youtube',
				'vimeo'	=> 'Vimeo',
				'dialymotion'		=> 'Dialymotion',
			),
			'multiple'	=> false,
			'desc'		=> 'Choose Video Type. ("Youtube" is default)',
			'std'		=> array( 'youtube' )
		),
		
		array(
			'name'		=> 'Video ID',
			'id'		=> $prefix . 'video_id',
			'desc'		=> 'Enter Video ID. For example: 8F7UOBIT4Vk ',
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		
		
		
		
		
		
),);





$meta_boxes[] = array(
	'id' => 'gallery',
	'title' => 'gallery Options',
	'pages' => array( 'gallery' ),
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		
		
		
		
		
		array(
			'name'		=> 'Gallery Images',
			'id'		=> $prefix . 'slideshow_gallery',
			'desc'		=> 'Upload more images for a slideshow.',
			'type'		=> 'image_advanced'
		),
		
		
		
	)
);




/********************* META BOX REGISTERING ***********************/

/**
 * Register meta boxes
 *
 * @return void
 */
function lioit_register_meta_boxes()
{
	global $meta_boxes;

	// Make sure there's no errors when the plugin is deactivated or during upgrade
	if ( class_exists( 'RW_Meta_Box' ) )
	{
		foreach ( $meta_boxes as $meta_box )
		{
			new RW_Meta_Box( $meta_box );
		}
	}
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'lioit_register_meta_boxes' );
