<?php 
	register_post_type( 'videos',
		array(
		  'labels' => array(
			'name' => __( 'Videos', 'lioit' ),
			'singular_name' => __( 'New', 'lioit' ),		
			'add_new' => _x( 'Add New', 'Video', 'lioit' ),
			'add_new_item' => __( 'Add New Video', 'lioit' ),
			'edit_item' => __( 'Edit Video Item', 'lioit' ),
			'new_item' => __( 'New Video Item', 'lioit' ),
			'view_item' => __( 'View Video Item', 'lioit' ),
			'search_items' => __( 'Search Video Item', 'lioit' ),
			'not_found' =>  __( 'No Video Item find', 'lioit' ),
			'not_found_in_trash' => __( 'No Video Item found in Trash', 'lioit' ),
			'parent_item_colon' => ''
			
		  ),
		  'public' => true,
		  'supports' => array('title','thumbnail', 'comments','editor'),
		  'public' => true,
		  'show_ui' => true,
		  'capability_type' => 'post',
		  'hierarchical' => false,
		  'menu_position' => 5,
		  'rewrite' => true,
		  'query_var' => false,
		  'rewrite' => array( 'slug' => 'videos' ),
		  /*'menu_icon' => Lioit_IMG . '/videos.png',*/
		)
	  );
	  
	  
	  	register_post_type( 'gallery',
		array(
		  'labels' => array(
			'name' => __( 'Gallery', 'lioit' ),
			'singular_name' => __( 'Gallery', 'lioit' ),		
			'add_new' => _x( 'Add New', 'Gallery', 'lioit' ),
			'add_new_item' => __( 'Add New Gallery', 'lioit' ),
			'edit_item' => __( 'Edit Gallery Item', 'lioit' ),
			'new_item' => __( 'New Gallery Item', 'lioit' ),
			'view_item' => __( 'View Gallery Item', 'lioit' ),
			'search_items' => __( 'Search Gallery Item', 'lioit' ),
			'not_found' =>  __( 'No Gallery Item find', 'lioit' ),
			'not_found_in_trash' => __( 'No Gallery Item found in Trash', 'lioit' ),
			'parent_item_colon' => ''
			
		  ),
		  'public' => true,
		  'supports' => array('title','thumbnail', 'comments','editor'),
		  'public' => true,
		  'show_ui' => true,
		  'capability_type' => 'post',
		  'hierarchical' => false,
		  'menu_position' => 5,
		  'rewrite' => true,
		  'query_var' => false,
		  'rewrite' => array( 'slug' => 'gallery' ),
		  /*'menu_icon' => Lioit_IMG . '/gallery.png',*/
		)
	  );
	 
	  
	  
	  add_action( 'init', 'builds_taxonomies', 0 ); 
	  

function builds_taxonomies() {

register_taxonomy( 'videos_sorting', 'videos', array( 'hierarchical' => true, 'label' => 'Videos Categories', 'query_var' => true, 'rewrite' => true ) ); 
register_taxonomy("videos_tags", 
				array("videos"), 
				array("hierarchical" => false, 
						"label" => "Videos Tags", 
						"singular_label" => "Video Tag",
						"rewrite" => array( 'slug' => 'videos-tags' ),
						"show_ui" => true,));
						
register_taxonomy( 'gallery_sorting', 'gallery', array( 'hierarchical' => true, 'label' => 'Gallery Sorting', 'query_var' => true, 'rewrite' => true ) ); 
register_taxonomy("gallery_tags", 
				array("gallery"), 
				array("hierarchical" => false, 
						"label" => "Gallery Tags", 
						"singular_label" => "Gallery Tag",
						"rewrite" => array( 'slug' => 'gallery-tags' ),
						"show_ui" => true,));

}











function lioit_edit_columns_gallery($gallery_columns){  
	$gallery_columns = array(  
		'cb' => '<input type="checkbox" />',  
		'title' => _x( 'Title', 'lioit', 'column name' ),
		'thumbnail' => __( 'Thumbnail', 'lioit'),
		'type' => __( 'Type', 'lioit' )
	);  
	
	return $gallery_columns;  
}  
add_filter('manage_edit-gallery_columns', 'lioit_edit_columns_gallery');  
  
function lioit_custom_columns_gallery($gallery_columns, $post_id){  

	switch ($gallery_columns) {
	    case 'thumbnail':
	        $thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
	        
	        if( $thumbnail_id ) {
	            $thumb = wp_get_attachment_image( $thumbnail_id, 'galleryadmin-thumb', true );
	        }
	        
	        if( isset($thumb) ) {
	            echo $thumb;
	        } else {
	            echo __('None', 'lioit');
	        }
	        
	        break;
	        
		case 'type':  
			echo get_the_term_list( $post_id, 'gallery_sorting', '', ', ', '' );
			break;
	}  
}  
add_action('manage_posts_custom_column',  'lioit_custom_columns_gallery', 10, 2);   
?>