<?php
global $smof_data;

add_action('template_redirect', 'redirect_single_post');
function redirect_single_post() {
    if (is_search()) {
        global $wp_query;
        if ($wp_query->post_count == 1) {
            wp_redirect( get_permalink( $wp_query->posts['0']->ID ) );
        }
    }
}
function limit_posts_per_search_page() {
	if ( is_search() )
		set_query_var('posts_per_archive_page', 20); 
}

add_filter('pre_get_posts', 'limit_posts_per_search_page');


/*-----------------------------------------------------------------------------------*/
#jquery ui
/*-----------------------------------------------------------------------------------*/
function wpa82718_scripts() {
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script(
        'iris',
        admin_url( 'js/iris.min.js' ),
        array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ),
        false,
        1
    );
    wp_enqueue_script(
        'wp-color-picker',
        admin_url( 'js/color-picker.min.js' ),
        array( 'iris' ),
        false,
        1
    );
    $colorpicker_l10n = array(
        'clear' => __( 'Clear','lioit' ),
        'defaultString' => __( 'Default','lioit' ),
        'pick' => __( 'Select Color','lioit' )
    );
    wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $colorpicker_l10n );

}
add_action( 'wp_enqueue_scripts', 'wpa82718_scripts', 100 );
/*-----------------------------------------------------------------------------------*/
# version check
/*-----------------------------------------------------------------------------------*/
function lioit_theme_compatibility_check( $version = '3.6' ) {
	global $wp_version;
	if ( version_compare( $wp_version, $version, '<' ) ) {
		return false;
	}
	return true;
}
/*-----------------------------------------------------------------------------------*/
# compatibility notice
/*-----------------------------------------------------------------------------------*/
function lioit_theme_incompatibility_notice() {
	global $wp_version;
    ?>

<div class="updated">
  <p>
    <?php _e( 'Your version of WordPress is incompatible with NewsZone, it is recommended you update to 3.6 or newer.', 'lioit' ); ?>
  </p>
</div>
<?php
}
if( lioit_theme_compatibility_check() === false ){
	add_action( 'admin_notices', 'lioit_theme_incompatibility_notice' );
}

 function lioit_get_edit_user_link(){
    return get_site_url() . '/?usersettings';
 }

/*-----------------------------------------------------------------------------------*/
# compatibility notice
/*-----------------------------------------------------------------------------------*/
function no_main() {
}
/*-----------------------------------------------------------------------------------*/
# mobile menu
/*-----------------------------------------------------------------------------------*/
function mobile_menu() {

  wp_nav_menu ( array( 'menu_id' => 'dropmenu','container'=> 'ul', 'theme_location' => 'mainnav', 'echo' => true,
                             'before' => '',
                             'after' => '',
                             'link_before' => '',
                             'link_after' => '',
                             'depth' => 0,
                            ));
}
/*-----------------------------------------------------------------------------------*/
# no_mobile
/*-----------------------------------------------------------------------------------*/
function no_mobile() {
    echo "<ul class='clearfix'>";
    wp_list_pages(array('title_li' => ''));
    echo "</ul>";
}
/*-----------------------------------------------------------------------------------*/
# getPostViews
/*-----------------------------------------------------------------------------------*/
function getPostViews($postID = ''){

	global $post;
	if( empty($postID) ) $postID = $post->ID ;

    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0 View";
    }
    return $count.' '.__( 'Views' , 'lioit' ).'';
}
/*-----------------------------------------------------------------------------------*/
# setPostViews
/*-----------------------------------------------------------------------------------*/
function setPostViews() {
global $post;
	global $post;
	$postID = $post->ID ;
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{

        $count = $count + 2 - 1;
        update_post_meta($postID, $count_key, $count);
    }
}
global $post;
/*-----------------------------------------------------------------------------------*/
# Add PostViews to a column in WP-Admin
/*-----------------------------------------------------------------------------------*/
add_filter('manage_posts_columns', 'posts_column_views');
add_action('manage_posts_custom_column', 'posts_custom_column_views',5,2);
function posts_column_views($defaults){
    $defaults['post_views'] = __('Views', 'lioit');
    return $defaults;
}
function posts_custom_column_views($column_name, $id){
	
	if($column_name === 'post_views'){
		global $post;
        echo getPostViews($post->ID);
    }
}
/*-----------------------------------------------------------------------------------*/
# pages links
/*-----------------------------------------------------------------------------------*/
function get_register_page_link($post_id) {
    global $wpdb;

    $results = $wpdb->get_results("SELECT post_id FROM $wpdb->postmeta
    WHERE meta_key='_wp_page_template' AND meta_value='template-signup.php'");

    foreach ($results as $result)
    {
        $page_id = $result->post_id;
    }

	if(isset($page_id))
	{
    	return get_page_link($page_id);
    }
    else
    {
    	return(false);
    }
}
function get_profile_page_link($post_id) {
    global $wpdb;

    $results = $wpdb->get_results("SELECT post_id FROM $wpdb->postmeta
    WHERE meta_key='_wp_page_template' AND meta_value='template-profile.php'");

   foreach ($results as $result)
    {
        $page_id = $result->post_id;
    }

	if(isset($page_id))
	{
    	return get_page_link($page_id);
    }
    else
    {
    	return(false);
    }
}

function get_submit_page_link($post_id) {
    global $wpdb;

    $results = $wpdb->get_results("SELECT post_id FROM $wpdb->postmeta
    WHERE meta_key='_wp_page_template' AND meta_value='template-submit.php'");

    foreach ($results as $result)
    {
        $page_id = $result->post_id;
    }

	if(isset($page_id))
	{
    	return get_page_link($page_id);
    }
    else
    {
    	return(false);
    }
}
function get_posts_page_link($post_id) {
    global $wpdb;

    $results = $wpdb->get_results("SELECT post_id FROM $wpdb->postmeta
    WHERE meta_key='_wp_page_template' AND meta_value='template-posts.php'");

    foreach ($results as $result)
    {
        $page_id = $result->post_id;
    }

	if(isset($page_id))
	{
    	return get_page_link($page_id);
    }
    else
    {
    	return(false);
    }
}


function get_blog_page_link($post_id) {
    global $wpdb;

    $results = $wpdb->get_results("SELECT post_id FROM $wpdb->postmeta
    WHERE meta_key='_wp_page_template' AND meta_value='template-blog.php'");

    foreach ($results as $result)
    {
        $page_id = $result->post_id;
    }

	if(isset($page_id))
	{
    	return get_page_link($page_id);
    }
    else
    {
    	return(false);
    }
}

function get_editposts_page_link($post_id) {
    global $wpdb;

    $results = $wpdb->get_results("SELECT post_id FROM $wpdb->postmeta
    WHERE meta_key='_wp_page_template' AND meta_value='template-edit-posts.php'");


    foreach ($results as $result)
    {
        $page_id = $result->post_id;
    }

	if(isset($page_id))
	{
    	return get_page_link($page_id);
    }
    else
    {
    	return(false);
    }
}






/*-----------------------------------------------------------------------------------*/
# lioit Thumb SRC
/*-----------------------------------------------------------------------------------*/
function catch_that_image(){
		global $post;
		$image = '';
		$size = '';
		//get the post thumbnail
		$image_id = get_post_thumbnail_id($post->ID);
		$image = wp_get_attachment_image_src($image_id, $size);
		$image = $image[0];
		if ($image) return $image;
		//If there is still no image, get the first image from the post
		return lioit_get_first_image();
		}
		      function lioit_get_first_image()
               {
                 global $post, $posts;
                 $first_img = '';
                 ob_start();
                 ob_end_clean();
                 $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
                 if(isset($matches[1][0]))
                 {
                         $first_img = $matches[1][0];
                 }
                 else
                 {
                        $first_img = Lioit_IMG.'/preview.png';

                 }

                 return $first_img;

		}
/*-----------------------------------------------------------------------------------*/
# my_password_form
/*-----------------------------------------------------------------------------------*/
function my_password_form() {
    global $post;
    $label = 'pwbox-'.( empty( $post->ID ) ? rand() : $post->ID );
    $o = '<div class="postPassowdBox"><form class="protected-post-form" action="' . get_option( 'siteurl' ) . '/wp-pass.php" method="post">
    ' . __( "<span>To view this protected post, enter the password below: </span>","lioit" ) . '
    <label for="' . $label . '">' . __( 'Password:','lioit' ) . ' </label><input class="postPassowd" name="post_password" id="' . $label . '" type="password" size="20" /><input class="postPassowdgo" type="submit" name="Submit" value="' . esc_attr__( "Submit","lioit" ) . '" />
    </form></div>
    ';
    return $o;
}
add_filter( 'the_password_form', 'my_password_form' );



/*-----------------------------------------------------------------------------------*/
# lioit_gallery
/*-----------------------------------------------------------------------------------*/
function lioit_gallery($postid){
	 
	 if(has_post_format('gallery', $postid) || get_post_type($postid) == 'gallery') {
	?>
<script type="text/javascript">
    jQuery(document).ready(function($){
      jQuery('#postSlideshow-<?php echo $postid; ?>').flexslider({
        animation: "fade",
		
		smoothHeight: true,
		controlNav: true,        
		directionNav: true, 
		touch: true,            
	
       
      });
    });
  </script>
<?php }
	
}
/*-----------------------------------------------------------------------------------*/
/*	Audio JS
/*-----------------------------------------------------------------------------------*/

function lioit_audio($postid) {
	global $post;
	$mp3 = get_post_meta($postid, 'lioit_mp3_url', TRUE);
	$ogg = get_post_meta($postid, 'lioit_ogg_url', TRUE);
	

	 ?>
<script type="text/javascript">
        jQuery(document).ready(function($) {
            jQuery("#jquery_jplayer_<?php echo $postid; ?>").jPlayer({
                ready: function(event) {
                    jQuery(this).jPlayer("setMedia", {
                        <?php if($mp3 != '') : ?>
						mp3: "<?php echo $mp3; ?>",
						<?php endif; ?>
						<?php if($ogg != '') : ?>
						oga: "<?php echo $ogg; ?>",
						<?php endif; ?>
                    });
                },
                swfPath: "http://jplayer.org/latest/js",
                supplied: "<?php if($ogg != '') : ?>oga,<?php endif; ?><?php if($mp3 != '') : ?>mp3, <?php endif; ?> all"
            });
        });     
    </script> 
<!-- JPLAYER -->
<?php 
}


/*-----------------------------------------------------------------------------------*/
/*	Video JS
/*-----------------------------------------------------------------------------------*/

function lioit_video($postid) {
	global $post;
	$m4v = get_post_meta($postid, 'lioit_video_m4v', TRUE);
	$ogv = get_post_meta($postid, 'lioit_video_ogv', TRUE);
	
	if(has_post_format('video', $postid) || get_post_type($postid) == 'portfolio') {
	 ?>
<script type="text/javascript">
			jQuery(document).ready(function(){
				
				if(jQuery().jPlayer) {
					jQuery("#jquery_jplayer_<?php echo $postid; ?>").jPlayer({
						ready: function () {
							jQuery(this).jPlayer("setMedia", {
								<?php if($m4v != '') : ?>
								m4v: "<?php echo $m4v; ?>",
								<?php endif; ?>
								<?php if($ogv != '') : ?>
								ogv: "<?php echo $ogv; ?>",
								<?php endif; ?>

								poster: "<?php $img = catch_that_image($post->ID);  echo $img ?>"
							
							});
						},
						swfPath: "<?php echo Lioit_JS; ?>",
						cssSelectorAncestor: "#jp_interface_<?php echo $postid; ?>",
						supplied: "<?php if($m4v != '') : ?>m4v, <?php endif; ?><?php if($ogv != '') : ?>ogv, <?php endif; ?> all"
					});
					
				}
			});
		</script>
<?php }
}
/*-----------------------------------------------------------------------------------*/
/*	related_posts
/*-----------------------------------------------------------------------------------*/

function get_related_posts($post_id) {
	$query = new WP_Query();
    
    $args = '';

	$args = wp_parse_args($args, array(
		'showposts' => -1,
		'post__not_in' => array($post_id),
		'ignore_sticky_posts' => 0,
        'category__in' => wp_get_post_categories($post_id)
	));
	
	$query = new WP_Query($args);
	
  	return $query;
}

/*-----------------------------------------------------------------------------------*/
# get_related_videos
/*-----------------------------------------------------------------------------------*/
function get_related_videos($post_id) {
    $query = new WP_Query();
    
    $args = '';

    $item_cats = get_the_terms($post_id, 'videos_sorting');
    if($item_cats):
    foreach($item_cats as $item_cat) {
        $item_array[] = $item_cat->term_id;
    }
    endif;

    $args = wp_parse_args($args, array(
        'showposts' => -1,
        'post__not_in' => array($post_id),
        'ignore_sticky_posts' => 0,
        'post_type' => 'videos',
        'tax_query' => array(
            array(
                'taxonomy' => 'videos_sorting',
				'taxonomy' => 'videos_sorting',
                'field' => 'id',
                'terms' => $item_array
            )
        )
    ));
    
    $query = new WP_Query($args);
    
    return $query;
}

/*-----------------------------------------------------------------------------------*/
# get_related_Gallery
/*-----------------------------------------------------------------------------------*/
function get_related_gallery($post_id) {
    $query = new WP_Query();
    
    $args = '';

    $item_cats = get_the_terms($post_id, 'gallery_sorting');
    if($item_cats):
    foreach($item_cats as $item_cat) {
        $item_array[] = $item_cat->term_id;
    }
    endif;

    $args = wp_parse_args($args, array(
        'showposts' => -1,
        'post__not_in' => array($post_id),
        'ignore_sticky_posts' => 0,
        'post_type' => 'gallery',
        'tax_query' => array(
            array(
                'taxonomy' => 'gallery_sorting',
				'taxonomy' => 'gallery_sorting',
                'field' => 'id',
                'terms' => $item_array
            )
        )
    ));
    
    $query = new WP_Query($args);
    
    return $query;
}



/*-----------------------------------------------------------------------------------*/
# get_all_thumbnails
/*-----------------------------------------------------------------------------------*/
function get_all_thumbnails() {
    global $post;
    $args = array(
    'order'          => 'ASC',
    'orderby'        => 'menu_order',
    'post_type'      => 'attachment',
    'post_parent'    => $post->ID,
    'post_mime_type' => 'image',
    'post_status'    => null,
    'numberposts'    => -1,
    );
    $attachments = get_posts($args);
    $i = 0;
        if ($attachments) {
            foreach ($attachments as $attachment) {
            echo wp_get_attachment_link($attachment->ID, 'medium', false, false);
            $i = $i + 1;
            }
        }
   if ($i != 0) echo '<div style="clear: both;"><small>' . $i . ' </small></div>';
 
}



/*-----------------------------------------------------------------------------------*/
# browser_body_class
/*-----------------------------------------------------------------------------------*/

	function browser_body_class($classes) {

		global $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;

		if($is_lynx) $classes[] = 'lynx';
		elseif($is_gecko) $classes[] = 'gecko';
		elseif($is_opera) $classes[] = 'opera';
		elseif($is_NS4) $classes[] = 'ns4';
		elseif($is_safari) $classes[] = 'safari';
		elseif($is_chrome) $classes[] = 'chrome';
		elseif($is_IE) $classes[] = 'ie';
		else $classes[] = 'unknown';

		if($is_iphone) $classes[] = 'iphone';

		return $classes;

	}

	add_filter('body_class','browser_body_class');
	
	
/* ================================================================================== */
/*      Support upload .ico file
  /* ================================================================================== */

if (!function_exists('custom_upload_mimes')) {
    add_filter('upload_mimes', 'custom_upload_mimes');

    function custom_upload_mimes($existing_mimes = array()) {
        $existing_mimes['ico'] = "image/x-icon";
        return $existing_mimes;
    }

}
/*-----------------------------------------------------------------------------------*/
# Wordpress Edit Gallery
/*-----------------------------------------------------------------------------------*/
add_filter( 'use_default_gallery_style', '__return_false' );
add_filter( 'wp_get_attachment_link', 'tw_pretty_gallery', 10, 5); 
function tw_pretty_gallery ($content, $id, $size, $permalink) {
    if(!$permalink)
	$content = preg_replace("/<a/","<a data-rel=\"prettyPhoto[gallery]\"",$content,1);
    return $content;
}

/*-----------------------------------------------------------------------------------*/
# Facebook Open Graph Meta
/*-----------------------------------------------------------------------------------*/
function facebookOpenGraphMeta() {
    global $post;
    if(!empty($post->ID)) {
        $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
        $image = isset($image[0])?$image[0]:'';
        if(!$image){$image=tw_option("theme_logo");};
        if (is_single()) { ?>
<meta property="og:url" content="<?php the_permalink() ?>"/>
<meta property="og:title" content="<?php single_post_title(''); ?>" />
<meta property="og:description" content="<?php echo strip_tags(get_the_excerpt()); ?>" />
<meta property="og:type" content="article" />
<meta property="og:image" content="<?php echo $image; ?>" />
<?php
        } else {
            if(!is_page()&&tw_option("theme_logo")!==''){$image=tw_option("theme_logo");} ?>
<meta property="og:site_name" content="<?php bloginfo('name'); ?>" />
<meta property="og:description" content="<?php bloginfo('description'); ?>" />
<meta property="og:type" content="website" />
<meta property="og:image" content="<?php echo $image; ?>" />
<?php 
        }
    }
}

/*-----------------------------------------------------------------------------------*/
# Breadcrumbs
/*-----------------------------------------------------------------------------------*/
function lioit_breadcrumbs() {
 
  $showOnHome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
  $delimiter = '<i class="icon-angle-right"></i>';
  $home = '<i class="icone-home"></i>Home'; // text for the 'Home' link
  $showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
  $before = '<span class="current">'; // tag before the current crumb
  $after = '</span>'; // tag after the current crumb
 
  global $post;
  $homeLink = home_url('');
 
  if (is_home() || is_front_page()) {
 
    if ($showOnHome == 1) echo '<div id="breadcrumbs"><span class="breadcrumbs-title"><i class="icone-home"></i></span>' . $home . '</a></div>';
  
  } else {
 
    echo '<div id="breadcrumbs"><span class="breadcrumbs-title"><i class="icone-home"></i></span><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . ' ';
 
    if ( is_category() ) {
      global $wp_query;
      $cat_obj = $wp_query->get_queried_object();
      $thisCat = $cat_obj->term_id;
      $thisCat = get_category($thisCat);
      $parentCat = get_category($thisCat->parent);
      if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
      echo $before . 'Archive by category "' . single_cat_title('', false) . '"' . $after;
 
    } elseif ( is_search() ) {
      echo $before . 'Search results for "' . get_search_query() . '"' . $after;
 
    } elseif ( is_day() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
      echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
      echo $before . get_the_time('d') . $after;
 
    } elseif ( is_month() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
      echo $before . get_the_time('F') . $after;
 
    } elseif ( is_year() ) {
      echo $before . get_the_time('Y') . $after;
 
    } elseif ( is_single() && !is_attachment() ) {
      if ( get_post_type() != 'post' ) {
        $post_type = get_post_type_object(get_post_type());
        $slug = $post_type->rewrite;
        echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a> ' . $delimiter . ' ';
        if ($showCurrent == 1) echo $before . get_the_title() . $after;
      } else {
        $cat = get_the_category(); $cat = $cat[0];
        echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
        if ($showCurrent == 1) echo $before . get_the_title() . $after;
      }
 
    } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
      $post_type = get_post_type_object(get_post_type());
      echo $before . $post_type->labels->singular_name . $after;
 
    } elseif ( is_attachment() ) {
      $parent = get_post($post->post_parent);
      $cat = get_the_category($parent->ID); $cat = $cat[0];
      echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
      echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a> ' . $delimiter . ' ';
      if ($showCurrent == 1) echo $before . get_the_title() . $after;
 
    } elseif ( is_page() && !$post->post_parent ) {
      if ($showCurrent == 1) echo $before . get_the_title() . $after;
 
    } elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while ($parent_id) {
        $page = get_page($parent_id);
        $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse($breadcrumbs);
      foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
      if ($showCurrent == 1) echo $before . get_the_title() . $after;
 
    } elseif ( is_tag() ) {
      echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;
 
    } elseif ( is_author() ) {
       global $author;
      $userdata = get_userdata($author);
      echo $before . 'About ' . $userdata->display_name . $after;
 
    } elseif ( is_404() ) {
      echo $before . 'Error 404' . $after;
    }
 
    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page','lioit') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }
 
    echo '</div>';
 
  }
}




/*-----------------------------------------------------------------------------------*/
# Get Social Counter
/*-----------------------------------------------------------------------------------*/
function lioit_curl_subscribers_text_counter( $xml_url ) {
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_URL, $xml_url);
	$smof_data = curl_exec($ch);
	curl_close($ch);
	return $smof_data;
}
function lioit_rss_count( $rss_id ) {
	$feedburner['rss_count'] = $options['rss_count'];
	return $feedburner;
}
function lioit_followers_count() {
	global $smof_data;
	try {
		$twitter_username 		= $smof_data['twitter_username'];
		$consumer_key 			= $smof_data['twitter_consumer_key'];
		$consumer_secret		= $smof_data['twitter_consumer_secret'];
		$access_token 			= $smof_data['twitter_access_token'];
		$access_token_secret 	= $smof_data['twitter_access_token_secret'];
		
		$twitterConnection = new TwitterOAuth( $consumer_key , $consumer_secret , $access_token , $access_token_secret	);
		$twitterData = $twitterConnection->get('users/show', array('screen_name' => $twitter_username));
		$twitter['page_url'] = 'http://www.twitter.com/'.$twitter_username;
		$twitter['followers_count'] = $twitterData->followers_count;
	} catch (Exception $e) {
		$twitter['page_url'] = 'http://www.twitter.com/'.$twitter_username;
		$twitter['followers_count'] = 0;
	}
	if( !empty( $twitter['followers_count'] ) &&  get_option( 'followers_count') != $twitter['followers_count'] )
		update_option( 'followers_count' , $twitter['followers_count'] );
		
	if( $twitter['followers_count'] == 0 && get_option( 'followers_count') )
		$twitter['followers_count'] = get_option( 'followers_count');
			
	elseif( $twitter['followers_count'] == 0 && !get_option( 'followers_count') )
		$twitter['followers_count'] = 0;
	
	return $twitter;
}
function lioit_facebook_fans( $page_link ){
	$face_link = @parse_url($page_link);

	if( $face_link['host'] == 'www.facebook.com' || $face_link['host']  == 'facebook.com' ){
		try {
			$page_name = substr(@parse_url($page_link, PHP_URL_PATH), 1);
			$data = @json_decode(lioit_curl_subscribers_text_counter("https://graph.facebook.com/".$page_name));
			$fans = $data->likes;
		} catch (Exception $e) {
			$fans = 0;
		}
			
		if( !empty($fans) && get_option( 'fans_count') != $fans )
			update_option( 'fans_count' , $fans );
			
		if( $fans == 0 && get_option( 'fans_count') )
			$fans = get_option( 'fans_count');
				
		elseif( $fans == 0 && !get_option( 'fans_count') )
			$fans = 0;
			
		return $fans;
	}
}
function lioit_vimeo_count( $page_link ) {
	$vimeo_link = @parse_url($page_link);

	if( $vimeo_link['host'] == 'www.vimeo.com' || $vimeo_link['host']  == 'vimeo.com' ){
		$vimeo = get_transient('vimeo_count');
		if( empty( $vimeo ) ){
			try {
				$page_name = substr(@parse_url($page_link, PHP_URL_PATH), 10);
				@$data = @json_decode(lioit_remote_get( 'http://vimeo.com/api/v2/channel/' . $page_name  .'/info.json'));
			
				$vimeo = $data->total_subscribers;
			} catch (Exception $e) {
				$vimeo = 0;
			}

			if( !empty($vimeo) ){
				set_transient( 'vimeo_count' , $vimeo , 1200);
				if( get_option( 'vimeo_count') != $vimeo )
					update_option( 'vimeo_count' , $vimeo );
			}
				
			if( $vimeo == 0 && get_option( 'vimeo_count') )
				$vimeo = get_option( 'vimeo_count');
			elseif( $vimeo == 0 && !get_option( 'vimeo_count') )
				$vimeo = 0;
		}
		return $vimeo;
	}
}
function lioit_youtube_subs( $channel_link ){
	$youtube_link = @parse_url($channel_link);

	if( $youtube_link['host'] == 'www.youtube.com' || $youtube_link['host']  == 'youtube.com' ){
		try {
			$youtube_name = substr(@parse_url($channel_link, PHP_URL_PATH), 6);
			$json = @lioit_curl_subscribers_text_counter("http://gdata.youtube.com/feeds/api/users/".$youtube_name."?alt=json");
			$data = json_decode($json, true); 
			$subs = $data['entry']['yt$statistics']['subscriberCount']; 
		} catch (Exception $e) {
			$subs = 0;
		}
		
		if( !empty($subs) && get_option( 'youtube_count') != $subs )
			update_option( 'youtube_count' , $subs );
			
		if( $subs == 0 && get_option( 'youtube_count') )
			$subs = get_option( 'youtube_count');
				
		elseif( $subs == 0 && !get_option( 'youtube_count') )
			$subs = 0;
			
		return $subs;
	}
}
function lioit_dribbble_count( $page_link ) {
	$face_link = @parse_url($page_link);

	if( $face_link['host'] == 'www.dribbble.com' || $face_link['host']  == 'dribbble.com' ){
		try {
			$page_name = substr(@parse_url($page_link, PHP_URL_PATH), 1);
			@$data = @json_decode(lioit_curl_subscribers_text_counter( 'http://api.dribbble.com/' . $page_name));
		
			$dribbble = $data->followers_count;
		} catch (Exception $e) {
			$dribbble = 0;
		}

		if( !empty($dribbble) && get_option( 'dribbble_count') != $dribbble )
			update_option( 'dribbble_count' , $dribbble );
			
		if( $dribbble == 0 && get_option( 'dribbble_count') )
			$dribbble = get_option( 'dribbble_count');
				
		elseif( $dribbble == 0 && !get_option( 'dribbble_count') )
			$dribbble = 0;
			
		return $dribbble;
	}

}
/*-----------------------------------------------------------------------------------*/
# html5_audio
/*-----------------------------------------------------------------------------------*/
function html5_audio($atts, $content = null) {
    extract(shortcode_atts(array(
        "src" => '',
        "autoplay" => '',
        "preload"=> 'true',
        "loop" => '',
        "controls"=> ''
    ), $atts));
    return '<audio src="'.$src.'" autoplay="'.$autoplay.'" preload="'.$preload.'" loop="'.$loop.'" controls="'.$controls.'" autobuffer />';
}
add_shortcode('audio', 'html5_audio');



function html5_video($atts, $content = null) {
    extract(shortcode_atts(array(
        "src" => '',
        "width" => '',
        "height" => ''
    ), $atts));
    return '<video src="'.$src.'" width="'.$width.'" height="'.$height.'" controls autobuffer>';
}
add_shortcode('video', 'html5_video');





/**************************************************************
 *          Menus
 ***************************************************************/
if ( function_exists( 'register_nav_menu' ) ) {
  register_nav_menus(
   array(
    'mainnav'   => __('Categories' , 'lioit'),
   )
  );
  register_nav_menus(
   array(
    'mainmenu'   => __('Main Menu' , 'lioit'),
   )
  );
  
  register_nav_menus(
   array(
    'footermenu'   => __('Footer Menu' , 'lioit'),
   )
  );

}
/*-----------------------------------------------------------------------------------*/
/*	SIDEBARS
/*-----------------------------------------------------------------------------------*/
if ( function_exists('register_sidebar')) {
		if (isset($smof_data['footer_layout'])) {
		$footer_config = $smof_data['footer_layout'];
		} else {
		$footer_config = 'footer-1';
		}
	    register_sidebar(array(
	        'name'=>'Main sidebar',
			'description' => __( 'Widgets in this area will be shown on the Right in homepage.','lioit' ),
	        'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
	    ));
		
		

		register_sidebar(array(
	        'name'=>'Main sidebar Small',
			'description' => __( 'Widgets in this area will be shown on the Center in homepage.','lioit' ),
	        'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
	    ));
		register_sidebar(array(
	        'name'=>'Single sidebar Small',
			'description' => __( 'Widgets in this area will be shown on the Center in Single Pages.','lioit' ),
	        'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
	    ));
	    register_sidebar(array(
	        'name'=>'Pages Sidebar',
			'description' => __( 'Widgets in this area will be shown on the Right in Pages.','lioit' ),
	        'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
	    ));
		register_sidebar(array(
	        'name'=>'Page sidebar Small',
			'description' => __( 'Widgets in this area will be shown on the Center in Pages.','lioit' ),
	        'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
	    ));
		
		
		register_sidebar(array(
			'name'=>'Archive Sidebar',
			'description' => __( 'Widgets in this area will be shown on the Right in Archive.','lioit' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
		));
		register_sidebar(array(
			'name'=>'Single Sidebar',
			'description' => __( 'Widgets in this area will be shown on the Right in Single Posts.','lioit' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
		));
		register_sidebar(array(
	        'name'=>'Single Gallery',
			'description' => __( 'Widgets in this area will be shown on Single Gallery.','lioit' ),
	        'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
	    ));
		register_sidebar(array(
			'name'=>'Serach Results Sidebar',
			'description' => __( 'Widgets in this area will be shown on Search Results.','lioit' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
		));
	    register_sidebar(array(
	        'name'=>'Footer Column 1',
			'description' => __( 'Widgets in this area will be shown in Footer Column 1','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    register_sidebar(array(
	        'name'=>'Footer Column 2',
			'description' => __( 'Widgets in this area will be shown in Footer Column 2','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    register_sidebar(array(
	        'name'=>'Footer Column 3',
			'description' => __( 'Widgets in this area will be shown in Footer Column 3','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    if ($footer_config == "footer-1") {
	    register_sidebar(array(
	        'name'=>'Footer Column 4',
			'description' => __( 'Widgets in this area will be shown in Footer Column 4','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    }    
	} 
	
	
	
	
	
	
	if ( function_exists('register_sidebar')) {
		if (isset($smof_data['topwidgets_layout'])) {
		$topwidgets_config = $smof_data['topwidgets_layout'];
		} else {
		$topwidgets_config = 'topwidgets-1';
		}
	    register_sidebar(array(
	        'name'=>'Top Widgets Column 1',
			'description' => __( 'Widgets in this area will be shown in Top Widgets Column 1','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    register_sidebar(array(
	        'name'=>'Top Widgets Column 2',
			'description' => __( 'Widgets in this area will be shown in Top Widgets Column 2','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    register_sidebar(array(
	        'name'=>'Top Widgets Column 3',
			'description' => __( 'Widgets in this area will be shown in Top Widgets Column 3','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    if ($topwidgets_config == "topwidgets-1") {
	    register_sidebar(array(
	        'name'=>'Top Widgets Column 4',
			'description' => __( 'Widgets in this area will be shown in Top Widgets Column 4','lioit' ),
	        'before_widget' => '<div id="%1$s" class="footerWidget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h5>',
	        'after_title' => '</h5><span class="titleBorder"></span></div>',
	    ));
	    }    
	}


global $woocommerce; 
if ($woocommerce) {
           register_sidebar(array(
			'name'=>'WooCommerce Sidebar',
			'description' => __( 'Widgets in this area will be shown in WooCommerce Pages','lioit' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
	        'after_widget' => '</div>',
	        'before_title' => '<div class="widgetTitle"><h4>',
	        'after_title' => '</h4><span class="titleBorder"></span></div>',
		));
        }

/***************************************************************
@
@	Max Excerpt & Short Title Fanctions
@
/**************************************************************/
function the_excerpt_max_charlength($charlength) {
   $excerpt = get_the_excerpt();
   $charlength++;
   if(strlen($excerpt)>$charlength) {
       $subex = substr($excerpt,0,$charlength-5);
       $exwords = explode(" ",$subex);
       $excut = -(strlen($exwords[count($exwords)-1]));
       if($excut<0) {
            echo substr($subex,0,$excut);
       } else {
       	    echo $subex;
       }
   } else {
	   echo $excerpt;
   }
}
function ShortenText($text, $chars_limit)
	{
	$text = strip_tags($text);
	$text = strip_shortcodes( $text );
	
	$chars_text = strlen($text);
	$text = $text." ";
	$text = substr($text,0,$chars_limit);
	$text = substr($text,0,strrpos($text,' '));
	
	if ($chars_text > $chars_limit) {
		$text = $text."...";
	}
	$text = preg_replace( '|\[(.+?)\](.+?\[/\\1\])?|s', '', $text);
	return $text;
}
function short_title($after = '', $length) {
	$mytitle = explode(' ', get_the_title(), $length);
	if (count($mytitle)>=$length) {
		array_pop($mytitle);
		$mytitle = implode(" ",$mytitle). $after;
	} else {
		$mytitle = implode(" ",$mytitle);
	}
	return $mytitle;
}
function excerpt($limit) {
      $excerpt = explode(' ', get_the_excerpt(), $limit);
      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
      return $excerpt;
    }
// Empty Pragraph Fix
  /*
    Plugin Name: Shortcode empty Paragraph fix
    Plugin URI: http://www.johannheyne.de/wordpress/shortcode-empty-paragraph-fix/
    Description: Fix issues when shortcodes are embedded in a block of content that is filtered by wpautop.
    Author URI: http://www.johannheyne.de
    Version: 0.1
    Put this in /wp-content/plugins/ of your Wordpress installation
    */


    add_filter('the_content', 'shortcode_empty_paragraph_fix');
    function shortcode_empty_paragraph_fix($content)
    {   
        $array = array (
            '<p>[' => '[', 
            ']</p>' => ']', 
            ']<br />' => ']'
        );

        $content = strtr($content, $array);

		return $content;
    }

//shortcodes in widgets
add_filter( 'widget_text', 'shortcode_unautop');
add_filter( 'widget_text', 'do_shortcode', 11);
/*-----------------------------------------------------------------------------------*/
/*	OTHER FUNCTIONS
/*-----------------------------------------------------------------------------------*/
// SHOW HOME LINK
function home_page_menu_args( $args ) {
$args['show_home'] = true;
return $args;
}
add_filter( 'wp_page_menu_args', 'home_page_menu_args' );

function wpe_excerptlength_index($length) {
    return 15;
}
// LOCALIZATION SUPPORT
load_theme_textdomain( 'lioit', Lioit_DIR.'/lang' );
// FLUSH
if ( is_admin() && isset($_GET['activated'] ) && $pagenow == 'themes.php' ) {
	$wp_rewrite->flush_rules();
}
/*-----------------------------------------------------------------------------------*/
// OPTIONS Lioit
/*-----------------------------------------------------------------------------------*/
include (get_template_directory() . '/Lioit/comments.php');
if (!function_exists('post_image_show')) {

    function post_image_show($width = 0, $height = "", $returnURL = false) {
        global $post;
        if (has_post_thumbnail($post->ID)) {
            $attachment = get_post(get_post_thumbnail_id($post->ID));
            if (isset($attachment)) {
                $lrg_img = wp_get_attachment_image_src($attachment->ID, 'full');
                $url = $lrg_img[0];
                if($returnURL) {
                    return $url;
                } else {
                    $alt = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);
                    $alt = !empty($alt) ? $alt : $attachment->post_title;
                    if ($width != 0) {
                        $url = aq_resize($url, $width, $height, true);
                    }
                    $urll = !empty($url) ? $url : $lrg_img[0];
                    return '<img src="' . $urll . '" alt="' . $alt . '"/>';
                }  
            }
            else
                return false;
        }
        return false;
    }

}
