<?php 

/*-----------------------------------------------------------------------------------*/
#Author Box
/*-----------------------------------------------------------------------------------*/
function lioit_author_box($avatar = true , $social = true ){
	
	if( $avatar ) : ?>

<div class="author-wrap">
  
  <!-- #author-avatar -->
  <?php endif; ?>
  <div class="author-description">
  <div class="author-avatar"> <?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'author_bio_avatar_size', 80 ) ); ?> </div>
    <p><?php the_author_meta( 'description' ); ?></p>
  </div>
  <!-- #author-description -->
  <?php  if( $social ) :	?>
  <div class="author-social">
    <?php if ( get_the_author_meta( 'url' ) ) : ?>
    <a class="icon-wordpress social-icon  size-m" href="<?php the_author_meta( 'url' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( " 's site", 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'twitter' ) ) : ?>
    <a class="icon-twitter social-icon  size-m" href="http://twitter.com/<?php the_author_meta( 'twitter' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Twitter', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'facebook' ) ) : ?>
    <a class="icon-facebook social-icon  size-m" href="<?php the_author_meta( 'facebook' ); ?>" title="<?php the_author_meta( 'display_name' ); ?> <?php _e( '  on Facebook', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'gplus' ) ) : ?>
    <a class="icon-googleplus social-icon  size-m" href="<?php the_author_meta( 'gplus' ); ?>" title="<?php the_author_meta( 'display_name' ); ?> <?php _e( '  on Google+', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'linkedin' ) ) : ?>
    <a class="icon-linkedin social-icon  size-m" href="<?php the_author_meta( 'linkedin' ); ?>" title="<?php the_author_meta( 'display_name' ); ?> <?php _e( '  on Linkedin', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'flickr' ) ) : ?>
    <a class="icon-flickr social-icon  size-m" href="<?php the_author_meta( 'flickr' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Flickr', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'youtube' ) ) : ?>
    <a class="icon-youtube social-icon  size-m" href="<?php the_author_meta( 'youtube' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on YouTube', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'pinterest' ) ) : ?>
    <a class="icon-pinterest social-icon  size-m" href="<?php the_author_meta( 'pinterest' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Pinterest', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'dribbble' ) ) : ?>
    <a class="icon-dribbble social-icon  size-m" href="<?php the_author_meta( 'dribbble' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on dribbble', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'vimeo' ) ) : ?>
    <a class="icon-vimeo social-icon  size-m" href="<?php the_author_meta( 'vimeo' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Vimeo', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'behance' ) ) : ?>
    <a class="icon-behance social-icon  size-m" href="<?php the_author_meta( 'behance' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on behance', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'tumblr' ) ) : ?>
    <a class="icon-tumblr social-icon  size-m" href="<?php the_author_meta( 'tumblr' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Tumblr', 'lioit' ); ?>"></a>
    <?php endif ?>
  </div>
  <?php endif; ?>
  <div class="clear"></div>
</div>
<?php
}



/*-----------------------------------------------------------------------------------*/
# Add user's  Extra Fields
/*-----------------------------------------------------------------------------------*/

add_action( 'show_user_profile', 'extra_user_profile_fields' );
add_action( 'edit_user_profile', 'extra_user_profile_fields' );
 
function extra_user_profile_fields( $user ) { ?>
<h3><?php _e("Extra Informations", "lioit"); ?></h3>
 
<table class="form-table">
<h4><?php _e("Basic Info", "lioit"); ?></h4>

<tr>
<th><label for="image">Profile Image</label></th>
 
<td>

<input type="text" name="image" id="image" value="<?php echo esc_attr( get_the_author_meta( 'image', $user->ID ) ); ?>" class="regular-text" /><input type='button' class="btn button-primary" value="Upload Image" id="uploadimage"/><br />
<span class="description"><?php _e("Please upload your image for your profile.", "lioit"); ?></span>
<img src="<?php echo esc_attr( get_the_author_meta( 'image', $user->ID ) ); ?>" style="height:50px; margin:5px;">
</td>
</tr

><tr>
    <th><label for="gender"><?php _e("Gender", "lioit"); ?></label></th>
    <td>
        <select name="gender" id="gender" >
            <option value="male" <?php selected( 'male', get_the_author_meta( 'gender', $user->ID ) ); ?>><?php _e("Male", "lioit"); ?></option>
            <option value="female" <?php selected( 'female', get_the_author_meta( 'gender', $user->ID ) ); ?>><?php _e("Female", "lioit"); ?></option>
        </select>
    </td>
</tr>
<tr>
<th><label for="birthday"><?php _e("Birthday", "lioit"); ?></label></th>
<td>
<input type="text" name="birthday" id="birthday" value="<?php echo esc_attr( get_the_author_meta( 'birthday', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("EX : 13/06/1983", "lioit"); ?></span>
</td>
</tr>
<tr>

<tr>
<th><label for="phone"><?php _e("Phone", "lioit"); ?></label></th>
<td>
<input type="text" name="phone" id="phone" value="<?php echo esc_attr( get_the_author_meta( 'phone', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Phone Number", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="country"><?php _e("Country", "lioit"); ?></label></th>
<td>
<input type="text" name="country" id="country" value="<?php echo esc_attr( get_the_author_meta( 'country', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Country", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="address"><?php _e("Address", "lioit"); ?></label></th>
<td>
<input type="text" name="address" id="address" value="<?php echo esc_attr( get_the_author_meta( 'address', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Address", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="city"><?php _e("City", "lioit"); ?></label></th>
<td>
<input type="text" name="city" id="city" value="<?php echo esc_attr( get_the_author_meta( 'city', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("City", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="province"><?php _e("Province", "lioit"); ?></label></th>
<td>
<input type="text" name="province" id="province" value="<?php echo esc_attr( get_the_author_meta( 'province', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Province", "lioit"); ?></span>
</td>
</tr>

<tr>
<th><label for="job"><?php _e("Jop Title", "lioit"); ?></label></th>
<td>
<input type="text" name="job" id="job" value="<?php echo esc_attr( get_the_author_meta( 'job', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("EX : Web Developer", "lioit"); ?></span>
</td>
</tr>
<tr>


</table>

<table class="form-table">
<h4><?php _e("Social Networks", "lioit"); ?></h4>
<tr>
<th><label for="facebook"><?php _e("Facebook", "lioit"); ?></label></th>
<td>
<input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Facebook URL", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="twitter"><?php _e("Twitter", "lioit"); ?></label></th>
<td>
<input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Twitter URL ", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="tumblr"><?php _e("Tumblr", "lioit"); ?></label></th>
<td>
<input type="text" name="tumblr" id="tumblr" value="<?php echo esc_attr( get_the_author_meta( 'tumblr', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Tumblr URL", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="linkedin"><?php _e("Linkedin", "lioit"); ?></label></th>
<td>
<input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'linkedin', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Linkedin URL ", "lioit"); ?></span>
</td>
</tr>

<tr>
<th><label for="behance"><?php _e("Behance", "lioit"); ?></label></th>
<td>
<input type="text" name="behance" id="behance" value="<?php echo esc_attr( get_the_author_meta( 'behance', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("behance URL ", "lioit"); ?></span>
</td>
</tr>

<tr>
<th><label for="dribbble"><?php _e("Dribbble", "lioit"); ?></label></th>
<td>
<input type="text" name="dribbble" id="dribbble" value="<?php echo esc_attr( get_the_author_meta( 'dribbble', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("dribbble URL ", "lioit"); ?></span>
</td>
</tr>


<tr>
<th><label for="pinterest"><?php _e("Pinterest", "lioit"); ?></label></th>
<td>
<input type="text" name="pinterest" id="pinterest" value="<?php echo esc_attr( get_the_author_meta( 'pinterest', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("pinterest URL ", "lioit"); ?></span>
</td>
</tr>


<tr>
<th><label for="vimeo"><?php _e("Vimeo", "lioit"); ?></label></th>
<td>
<input type="text" name="vimeo" id="vimeo" value="<?php echo esc_attr( get_the_author_meta( 'vimeo', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Vimeo URL", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="youtube"><?php _e("Youtube", "lioit"); ?></label></th>
<td>
<input type="text" name="youtube" id="youtube" value="<?php echo esc_attr( get_the_author_meta( 'youtube', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Youtube URL", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="gplus"><?php _e("Google+", "lioit"); ?></label></th>
<td>
<input type="text" name="gplus" id="gplus" value="<?php echo esc_attr( get_the_author_meta( 'gplus', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Google+ URL", "lioit"); ?></span>
</td>
</tr>
<tr>
<th><label for="skype"><?php _e("Skype", "lioit"); ?></label></th>
<td>
<input type="text" name="skype" id="skype" value="<?php echo esc_attr( get_the_author_meta( 'skype', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description"><?php _e("Skype URL", "lioit"); ?></span>
</td>
</tr>




</table>
<?php }
 
add_action( 'personal_options_update', 'save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'save_extra_user_profile_fields' );
 
function save_extra_user_profile_fields( $user_id ) {
 
if ( !current_user_can( 'edit_user', $user_id ) ) { return false; }
 
update_user_meta( $user_id, 'facebook', $_POST['facebook'] );
update_user_meta( $user_id, 'twitter', $_POST['twitter'] );
update_user_meta( $user_id, 'dribbble', $_POST['dribbble'] );
update_user_meta( $user_id, 'pinterest', $_POST['pinterest'] );
update_user_meta( $user_id, 'gplus', $_POST['gplus'] );
update_user_meta( $user_id, 'linkedin', $_POST['linkedin'] );
update_user_meta( $user_id, 'tumblr', $_POST['tumblr'] );
update_user_meta( $user_id, 'behance', $_POST['behance'] );
update_user_meta( $user_id, 'vimeo', $_POST['vimeo'] );
update_user_meta( $user_id, 'youtube', $_POST['youtube'] );
update_user_meta( $user_id, 'skype', $_POST['skype'] );
update_user_meta( $user_id, 'birthday', $_POST['birthday'] );
update_user_meta( $user_id, 'phone', $_POST['phone'] );
update_user_meta( $user_id, 'country', $_POST['country'] );
update_user_meta( $user_id, 'address', $_POST['address'] );
update_user_meta( $user_id, 'city', $_POST['city'] );
update_user_meta( $user_id, 'province', $_POST['province'] );
update_user_meta( $user_id, 'gender', $_POST['gender'] );
update_user_meta( $user_id, 'job', $_POST['job'] );
update_user_meta( $user_id, 'image', $_POST['image'] );
}
/*-----------------------------------------------------------------------------------*/
# Login Form
/*-----------------------------------------------------------------------------------*/
function lioit_login_form( $login_only  = 0 ) {
	global $user_ID, $user_identity, $user_level;
	
	if ( $user_ID ) : ?>
<?php if( empty( $login_only ) ): ?>

<div id="user-login">
  <p class="welcome-text">
    <?php _e( 'Welcome' , 'lioit' ) ?>
    <strong><?php echo $user_identity ?></strong> .</p>
  <span class="author-avatar"><?php echo get_avatar( $user_ID, $size = '90'); ?></span>
  <ul>
    <li class="userWpAdmin"><a href="<?php echo home_url() ?>/wp-admin/">
      <?php _e( 'Dashboard' , 'lioit' ) ?>
      </a></li>
    <li class="userprofile"><a href="<?php echo home_url() ?>/wp-admin/profile.php">
      <?php _e( 'Your Profile' , 'lioit' ) ?>
      </a></li>
    <li class="userlogout"><a href="<?php echo wp_logout_url(); ?>">
      <?php _e( 'Logout' , 'lioit' ) ?>
      </a></li>
  </ul>
  <div class="author-social">
    <?php if ( get_the_author_meta( 'url' , $user_ID) ) : ?>
    <a class="icon-wordpress social-icon  size-m" href="<?php the_author_meta( 'url' , $user_ID); ?>" title="<?php echo $user_identity ?> <?php _e( " 's site", 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'twitter' , $user_ID) ) : ?>
    <a class="icon-twitter social-icon  size-m" href="http://twitter.com/<?php the_author_meta( 'twitter' ); ?>" title="<?php echo $user_identity ?><?php _e( '  on Twitter', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'facebook' , $user_ID) ) : ?>
    <a class="icon-facebook social-icon  size-m" href="<?php the_author_meta( 'facebook' ); ?>" title="<?php echo $user_identity ?><?php _e( '  on Facebook', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'gplus' , $user_ID) ) : ?>
    <a class="icon-googleplus social-icon  size-m" href="<?php the_author_meta( 'gplus' ); ?>" title="<?php echo $user_identity ?><?php _e( '  on Google+', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'linkedin' , $user_ID) ) : ?>
    <a class="icon-linkedin social-icon  size-m" href="<?php the_author_meta( 'linkedin' , $user_ID); ?>" title="<?php echo $user_identity ?><?php _e( '  on Linkedin', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'flickr' , $user_ID) ) : ?>
    <a class="icon-flickr social-icon  size-m" href="<?php the_author_meta( 'flickr' , $user_ID); ?>" title="<?php echo $user_identity ?><?php _e( '  on Flickr', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'youtube' , $user_ID) ) : ?>
    <a class="icon-youtube social-icon  size-m" href="<?php the_author_meta( 'youtube' , $user_ID); ?>" title="<?php echo $user_identity ?><?php _e( '  on YouTube', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'pinterest' ) ) : ?>
    <a class="icon-pinterest social-icon  size-m" href="<?php the_author_meta( 'pinterest' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Pinterest', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'dribbble' ) ) : ?>
    <a class="icon-dribbble social-icon  size-m" href="<?php the_author_meta( 'dribbble' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on dribbble', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'vimeo' ) ) : ?>
    <a class="icon-vimeo social-icon  size-m" href="<?php the_author_meta( 'vimeo' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Vimeo', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'behance' ) ) : ?>
    <a class="icon-behance social-icon  size-m" href="<?php the_author_meta( 'behance' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on behance', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'linkedin' ) ) : ?>
    <a class="icon-linkedin social-icon  size-m" href="<?php the_author_meta( 'linkedin' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Linkedin', 'lioit' ); ?>"></a>
    <?php endif ?>
    <?php if ( get_the_author_meta( 'tumblr' ) ) : ?>
    <a class="icon-tumblr social-icon  size-m" href="<?php the_author_meta( 'tumblr' ); ?>" title="<?php the_author_meta( 'display_name' ); ?><?php _e( '  on Tumblr', 'lioit' ); ?>"></a>
    <?php endif ?>
  </div>
  <div class="clear"></div>
</div>
<?php endif; ?>
<?php else: ?>
<div id="login-form">
  <form action="<?php echo home_url() ?>/wp-login.php" method="post">
    <span id="log-username">
    <input type="text" name="log" id="log" value="" placeholder="<?php _e( 'Username' , 'lioit' ) ?>"  size="33" />
    </span> <span id="log-pass">
    <input type="password" name="pwd" id="pwd" value="" placeholder="<?php _e( 'Password' , 'lioit' ) ?>"  size="33" />
    </span>
    <button  type="submit" name="submit" class="login-button btn ButtonShadow" />
    <?php _e( 'Log in' , 'lioit' ) ?>
    </button>
    <label for="rememberme">
      <input name="rememberme" id="rememberme" type="checkbox" checked="checked" value="forever" />
      <?php _e( 'Remember Me' , 'lioit' ) ?>
    </label>
    <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>"/>
  </form>
  <ul class="login-links">
    <li><a href="<?php echo home_url() ?>/wp-login.php?action=lostpassword">
      <?php _e( 'Lost your password?' , 'lioit' ) ?>
      </a></li>
    <?php if ( get_option('users_can_register') ) : ?>
    <li><a href="<?php echo home_url() ?>/wp-register.php">
      <?php _e( 'Register' , 'lioit' ) ?>
      </a></li>
    <?php endif; ?>
  </ul>
</div>
<?php endif;
}
?>
<?php
function zkr_profile_upload_js() {
?><script type="text/javascript">
jQuery(document).ready(function() {
jQuery(document).find("input[id^='uploadimage']").live('click', function(){
//var num = this.id.split('-')[1];
formfield = jQuery('#image').attr('name');
tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');
 
window.send_to_editor = function(html) {
imgurl = jQuery('img',html).attr('src');
jQuery('#image').val(imgurl);
tb_remove();
}
 
return false;
});
});
</script>
<?php
}
add_action('admin_head','zkr_profile_upload_js');
 
// the following is the js and css for the upload functionality
function zkr_enque_scripts_init(){
wp_enqueue_script('media-upload');
wp_enqueue_script('thickbox');
wp_enqueue_style('thickbox');
}
add_action('init', 'zkr_enque_scripts_init');


